/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image.wms;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.wms.request.GetMapRequest;
import org.geotools.referencing.CRS;
import org.mapfish.print.URIUtils;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.image.wms.WmsLayerParam;
import org.mapfish.print.map.image.wms.WmsVersion;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class WmsUtilities {
    private static final String FORMAT_OPTIONS = "FORMAT_OPTIONS";

    private WmsUtilities() {
    }

    public static URI makeWmsGetLayerRequest(WmsLayerParam wmsLayerParam, URI commonURI, Dimension imageSize, double dpi, double angle, ReferencedEnvelope bounds) throws FactoryException, URISyntaxException, IOException {
        URL url = WmsUtilities.getUrl(commonURI);
        GetMapRequest getMapRequest = WmsVersion.lookup(wmsLayerParam.version).getGetMapRequest(url);
        getMapRequest.setBBox((Bounds)bounds);
        getMapRequest.setDimensions(imageSize.width, imageSize.height);
        getMapRequest.setFormat(wmsLayerParam.imageFormat);
        getMapRequest.setSRS(CRS.lookupIdentifier((IdentifiedObject)bounds.getCoordinateReferenceSystem(), (boolean)false));
        for (int i = wmsLayerParam.layers.length - 1; i > -1; --i) {
            String layer = wmsLayerParam.layers[i];
            String style = "";
            if (wmsLayerParam.styles != null) {
                style = wmsLayerParam.styles[i];
            }
            getMapRequest.addLayer(layer, style);
        }
        URI getMapUri = getMapRequest.getFinalURL().toURI();
        HashMultimap extraParams = HashMultimap.create();
        if (commonURI.getQuery() != null) {
            for (NameValuePair pair : URLEncodedUtils.parse((URI)commonURI, (Charset)StandardCharsets.UTF_8)) {
                extraParams.put((Object)pair.getName(), (Object)pair.getValue());
            }
        }
        extraParams.putAll(wmsLayerParam.getMergeableParams());
        extraParams.putAll(wmsLayerParam.getCustomParams());
        if (wmsLayerParam.serverType != null) {
            WmsUtilities.addDpiParam((Multimap<String, String>)extraParams, (int)Math.round(dpi), wmsLayerParam.serverType);
            if (wmsLayerParam.useNativeAngle && angle != 0.0) {
                WmsUtilities.addAngleParam((Multimap<String, String>)extraParams, angle, wmsLayerParam.serverType);
            }
        }
        return URIUtils.addParams(getMapUri, (Multimap<String, String>)extraParams, Collections.emptySet());
    }

    private static URL getUrl(URI commonURI) throws MalformedURLException {
        if (commonURI == null || commonURI.getAuthority() == null) {
            throw new RuntimeException("Invalid WMS URI: " + commonURI);
        }
        String[] authority = commonURI.getAuthority().split(":");
        URL url = authority.length == 2 ? new URL(commonURI.getScheme(), authority[0], Integer.parseInt(authority[1]), commonURI.getPath()) : new URL(commonURI.getScheme(), authority[0], commonURI.getPath());
        return url;
    }

    private static void addDpiParam(Multimap<String, String> extraParams, int dpi, WmsLayerParam.ServerType type) {
        switch (type) {
            case MAPSERVER: {
                if (WmsUtilities.contains(extraParams, "MAP_RESOLUTION")) break;
                extraParams.put((Object)"MAP_RESOLUTION", (Object)Integer.toString(dpi));
                break;
            }
            case QGISSERVER: {
                if (WmsUtilities.contains(extraParams, "DPI")) break;
                extraParams.put((Object)"DPI", (Object)Integer.toString(dpi));
                break;
            }
            case GEOSERVER: {
                if (!WmsUtilities.contains(extraParams, FORMAT_OPTIONS)) {
                    extraParams.put((Object)FORMAT_OPTIONS, (Object)("dpi:" + dpi));
                    break;
                }
                if (WmsUtilities.isDpiSet(extraParams)) break;
                WmsUtilities.setDpiValue(extraParams, dpi);
                break;
            }
        }
    }

    private static void addAngleParam(Multimap<String, String> extraParams, double angle, WmsLayerParam.ServerType type) {
        switch (type) {
            case MAPSERVER: 
            case GEOSERVER: {
                if (WmsUtilities.contains(extraParams, "ANGLE")) break;
                extraParams.put((Object)"ANGLE", (Object)Double.toString(Math.toDegrees(angle)));
                break;
            }
        }
    }

    private static boolean contains(Multimap<String, ?> map, String searchKey) {
        for (String key : map.keys()) {
            if (!key.equalsIgnoreCase(searchKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDpiSet(Multimap<String, String> extraParams) {
        for (String key : extraParams.keys()) {
            if (!key.equalsIgnoreCase(FORMAT_OPTIONS)) continue;
            for (String value : extraParams.get((Object)key)) {
                if (!value.toLowerCase().contains("dpi:")) continue;
                return true;
            }
        }
        return false;
    }

    private static void setDpiValue(Multimap<String, String> extraParams, int dpi) {
        for (String key : extraParams.keys()) {
            if (!key.equalsIgnoreCase(FORMAT_OPTIONS)) continue;
            Collection values = extraParams.removeAll((Object)key);
            ArrayList<Object> newValues = new ArrayList<Object>();
            for (Object value : values) {
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                value = (String)value + ";dpi:" + dpi;
                newValues.add(value);
            }
            extraParams.putAll((Object)key, newValues);
            return;
        }
    }

    public static ClientHttpRequest createWmsRequest(MfClientHttpRequestFactory httpRequestFactory, URI uri, HttpMethod method) throws IOException {
        switch (method) {
            case GET: {
                return httpRequestFactory.createRequest(uri, method);
            }
            case POST: {
                URI paramlessUri;
                String params = uri.getQuery();
                try {
                    paramlessUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                ClientHttpRequest request = httpRequestFactory.createRequest(paramlessUri, method);
                byte[] encodedParams = params.getBytes(StandardCharsets.UTF_8);
                request.getHeaders().set("Content-Type", "application/x-www-form-urlencoded");
                request.getHeaders().set("Charset", "utf-8");
                request.getHeaders().set("Content-Length", Integer.toString(encodedParams.length));
                request.getBody().write(encodedParams);
                return request;
            }
        }
        throw new RuntimeException("Unsupported WMS request method: " + method);
    }
}

