/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image;

import com.codahale.metrics.MetricRegistry;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.MapLayerFactoryPlugin;
import org.mapfish.print.map.geotools.AbstractGridCoverageLayerPlugin;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.image.AbstractSingleImageLayer;
import org.mapfish.print.parser.HasDefaultValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class ImageLayer
extends AbstractSingleImageLayer {
    private final ImageParam params;
    private final boolean failOnError;
    private final StyleSupplier<GridCoverage2D> styleSupplier;
    private final ExecutorService executorService;
    private final MapLayer.RenderType renderType;
    private double imageBufferScaling;
    private BufferedImage image;
    private boolean imageLoadError = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageLayer.class);

    protected ImageLayer(@Nonnull ExecutorService executorService, @Nonnull StyleSupplier<GridCoverage2D> styleSupplier, @Nonnull ImageParam params, @Nonnull Configuration configuration, @Nonnull MetricRegistry registry) {
        super(executorService, styleSupplier, params, registry, configuration);
        this.params = params;
        this.failOnError = params.failOnError;
        params.failOnError = true;
        this.styleSupplier = styleSupplier;
        this.executorService = executorService;
        this.renderType = MapLayer.RenderType.fromMimeType(params.imageFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BufferedImage loadImage(MfClientHttpRequestFactory requestFactory, MapfishMapContext transformer) {
        ReferencedEnvelope envelopeOrig = transformer.getBounds().toReferencedEnvelope(transformer.getPaintArea());
        Rectangle paintArea = this.imageLoadError ? transformer.getPaintArea() : this.calculateNewBounds(this.image, envelopeOrig);
        ReferencedEnvelope envelope = transformer.getBounds().toReferencedEnvelope(paintArea);
        BufferedImage bufferedImage = new BufferedImage(paintArea.width, paintArea.height, 3);
        Graphics2D graphics = bufferedImage.createGraphics();
        MapContent content = new MapContent();
        try {
            GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
            CoordinateReferenceSystem mapProjection = envelope.getCoordinateReferenceSystem();
            GeneralBounds gridEnvelope = new GeneralBounds(mapProjection);
            gridEnvelope.setEnvelope(this.params.extent);
            GridCoverage2D coverage = factory.create((CharSequence)this.params.getBaseUrl(), (RenderedImage)this.image, (Bounds)gridEnvelope, null, null, null);
            Style style = this.styleSupplier.load(requestFactory, coverage);
            content.addLayers(Collections.singletonList(new GridCoverageLayer(coverage, style)));
            StreamingRenderer renderer = new StreamingRenderer();
            RenderingHints hints = new RenderingHints(Collections.emptyMap());
            hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.addRenderingHints(hints);
            renderer.setJava2DHints(hints);
            HashMap<String, Boolean> renderHints = new HashMap<String, Boolean>();
            if (transformer.isForceLongitudeFirst() != null) {
                renderHints.put("ForceEPSGAxisOrder", transformer.isForceLongitudeFirst());
            }
            renderer.setRendererHints(renderHints);
            renderer.setMapContent(content);
            renderer.setThreadPool(this.executorService);
            renderer.paint(graphics, paintArea, envelope);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            graphics.dispose();
            content.dispose();
        }
    }

    private Rectangle calculateNewBounds(BufferedImage image, ReferencedEnvelope envelope) {
        double w = (double)image.getWidth() / (this.params.extent[2] - this.params.extent[0]) * envelope.getWidth();
        double h = (double)image.getHeight() / (this.params.extent[3] - this.params.extent[1]) * envelope.getHeight();
        return new Rectangle(Math.toIntExact(Math.round(w)), Math.toIntExact(Math.round(h)));
    }

    @Override
    public MapLayer.RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    public double getImageBufferScaling() {
        return this.imageBufferScaling;
    }

    @Override
    public void prepareRender(MapfishMapContext transformer, MfClientHttpRequestFactory clientHttpRequestFactory) {
        try {
            this.image = this.fetchLayerImage(transformer, clientHttpRequestFactory);
        }
        catch (IOException | RuntimeException | URISyntaxException e) {
            if (this.failOnError) {
                throw new RuntimeException(e);
            }
            LOGGER.error("Error while fetching image", (Throwable)e);
            this.image = this.createErrorImage(new Rectangle(1, 1));
            this.imageLoadError = true;
            this.imageBufferScaling = 1.0;
            return;
        }
        this.imageLoadError = false;
        ReferencedEnvelope envelopeOrig = transformer.getBounds().toReferencedEnvelope(transformer.getPaintArea());
        Rectangle paintArea = this.calculateNewBounds(this.image, envelopeOrig);
        double widthImageBufferScaling = paintArea.getWidth() / transformer.getMapSize().getWidth();
        double heightImageBufferScaling = paintArea.getHeight() / transformer.getMapSize().getHeight();
        this.imageBufferScaling = Math.sqrt((Math.pow(widthImageBufferScaling, 2.0) + Math.pow(heightImageBufferScaling, 2.0)) / 2.0);
    }

    private BufferedImage fetchLayerImage(MapfishMapContext transformer, MfClientHttpRequestFactory clientHttpRequestFactory) throws URISyntaxException, IOException {
        URI commonUri = new URI(this.params.getBaseUrl());
        ClientHttpRequest request = clientHttpRequestFactory.createRequest(commonUri, HttpMethod.GET);
        return this.fetchImage(request, transformer);
    }

    public static final class ImageParam
    extends AbstractLayerParams {
        private static final int NUMBER_OF_EXTENT_COORDS = 4;
        public String baseURL;
        public double[] extent;
        @HasDefaultValue
        public String style = "raster";
        @HasDefaultValue
        public String imageFormat = "";

        public void postConstruct() {
            Assert.equals((Object)4, (Object)this.extent.length, (String)("maxExtent must have exactly 4 elements to the array.  Was: " + Arrays.toString(this.extent)));
        }

        public String getBaseUrl() {
            return this.baseURL;
        }
    }

    public static final class ImageLayerPlugin
    extends AbstractGridCoverageLayerPlugin
    implements MapLayerFactoryPlugin<ImageParam> {
        private static final String TYPE = "image";
        @Autowired
        private ForkJoinPool forkJoinPool;
        @Autowired
        private MetricRegistry metricRegistry;

        @Override
        public Set<String> getTypeNames() {
            return Collections.singleton(TYPE);
        }

        @Override
        public ImageParam createParameter() {
            return new ImageParam();
        }

        @Nonnull
        public ImageLayer parse(@Nonnull Template template, @Nonnull ImageParam layerData) {
            String styleRef = layerData.style;
            return new ImageLayer((ExecutorService)this.forkJoinPool, super.createStyleSupplier(template, styleRef), layerData, template.getConfiguration(), this.metricRegistry);
        }
    }
}

