/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.mapfish.print.FileUtils;
import org.mapfish.print.PrintException;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.MapLayerFactoryPlugin;
import org.mapfish.print.map.geotools.AbstractGridCoverage2DReaderLayer;
import org.mapfish.print.map.geotools.AbstractGridCoverageLayerPlugin;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.parser.HasDefaultValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class GeotiffLayer
extends AbstractGridCoverage2DReaderLayer {
    public GeotiffLayer(Function<MfClientHttpRequestFactory, AbstractGridCoverage2DReader> reader, StyleSupplier<AbstractGridCoverage2DReader> style, ExecutorService executorService, AbstractLayerParams params) {
        super(reader::apply, style, executorService, params);
    }

    @Override
    public MapLayer.RenderType getRenderType() {
        return MapLayer.RenderType.TIFF;
    }

    public static final class GeotiffParam
    extends AbstractLayerParams {
        public String url;
        @HasDefaultValue
        public String style = "raster";
    }

    public static final class Plugin
    extends AbstractGridCoverageLayerPlugin
    implements MapLayerFactoryPlugin<GeotiffParam> {
        private static final Set<String> TYPENAMES = Collections.singleton("geotiff");
        @Autowired
        private ExecutorService forkJoinPool;

        @Override
        public Set<String> getTypeNames() {
            return TYPENAMES;
        }

        @Override
        public GeotiffParam createParameter() {
            return new GeotiffParam();
        }

        @Nonnull
        public GeotiffLayer parse(@Nonnull Template template, @Nonnull GeotiffParam param) throws IOException {
            Function<MfClientHttpRequestFactory, AbstractGridCoverage2DReader> geotiffReader = this.getGeotiffReader(template, param.url);
            String styleRef = param.style;
            return new GeotiffLayer(geotiffReader::apply, super.createStyleSupplier(template, styleRef), this.forkJoinPool, param);
        }

        private Function<MfClientHttpRequestFactory, AbstractGridCoverage2DReader> getGeotiffReader(Template template, String geotiffUrl) throws IOException {
            URL url = FileUtils.testForLegalFileUrl(template.getConfiguration(), new URL(geotiffUrl));
            return requestFactory -> {
                try {
                    File geotiffFile;
                    if (url.getProtocol().equalsIgnoreCase("file")) {
                        geotiffFile = new File(url.toURI());
                    } else {
                        geotiffFile = File.createTempFile("downloadedGeotiff", ".tiff");
                        ClientHttpRequest request = requestFactory.createRequest(url.toURI(), HttpMethod.GET);
                        try (ClientHttpResponse httpResponse = request.execute();
                             FileOutputStream output = new FileOutputStream(geotiffFile);){
                            IOUtils.copy((InputStream)httpResponse.getBody(), (OutputStream)output);
                        }
                    }
                    return new GeoTiffFormat().getReader((Object)geotiffFile);
                }
                catch (IOException | URISyntaxException e) {
                    throw new PrintException("Failed to get GeotiffReader", e);
                }
            };
        }
    }
}

