/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;

public final class MfSSLSocketFactory
implements LayeredConnectionSocketFactory {
    private LayeredConnectionSocketFactory defaultFactory = SSLConnectionSocketFactory.getSystemSocketFactory();

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        LayeredConnectionSocketFactory factory = this.getSSLSocketFactory();
        return factory.createLayeredSocket(socket, target, port, context);
    }

    public Socket createSocket(HttpContext context) throws IOException {
        LayeredConnectionSocketFactory factory = this.getSSLSocketFactory();
        return factory.createSocket(context);
    }

    public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        LayeredConnectionSocketFactory factory = this.getSSLSocketFactory();
        return factory.connectSocket(connectTimeout, sock, host, remoteAddress, localAddress, context);
    }

    private LayeredConnectionSocketFactory getSSLSocketFactory() {
        Configuration currentConfiguration = MfClientHttpRequestFactoryImpl.getCurrentConfiguration();
        if (currentConfiguration == null || currentConfiguration.getCertificateStore() == null) {
            return this.defaultFactory;
        }
        SSLContext context = currentConfiguration.getCertificateStore().getSSLContext();
        return new SSLConnectionSocketFactory(context);
    }
}

