/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.mapfish.print.StatsUtils;
import org.mapfish.print.http.ErrorResponseClientHttpResponse;
import org.mapfish.print.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class HttpRequestFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestFetcher.class);
    private final File temporaryDirectory;
    private final MetricRegistry registry;
    private final Processor.ExecutionContext context;
    private final ForkJoinPool requestForkJoinPool;

    public HttpRequestFetcher(File temporaryDirectory, MetricRegistry registry, Processor.ExecutionContext context, ForkJoinPool requestForkJoinPool) {
        this.temporaryDirectory = temporaryDirectory;
        this.registry = registry;
        this.context = context;
        this.requestForkJoinPool = requestForkJoinPool;
    }

    private CachedClientHttpRequest add(CachedClientHttpRequest request) {
        Future future = this.requestForkJoinPool.submit((Callable)request);
        request.setFuture((ForkJoinTask<Void>)future);
        return request;
    }

    public ClientHttpRequest register(ClientHttpRequest originalRequest) {
        return this.add(new CachedClientHttpRequest(originalRequest, this.context));
    }

    private final class CachedClientHttpRequest
    implements ClientHttpRequest,
    Callable<Void> {
        private final ClientHttpRequest originalRequest;
        private final Processor.ExecutionContext context;
        @Nullable
        private ClientHttpResponse response;
        private ForkJoinTask<Void> future;

        private CachedClientHttpRequest(ClientHttpRequest request, Processor.ExecutionContext context) {
            this.originalRequest = request;
            this.context = context;
        }

        public HttpMethod getMethod() {
            return this.originalRequest.getMethod();
        }

        @Nonnull
        public String getMethodValue() {
            HttpMethod method = this.getMethod();
            return method != null ? method.name() : "";
        }

        @Nonnull
        public URI getURI() {
            return this.originalRequest.getURI();
        }

        @Nonnull
        public HttpHeaders getHeaders() {
            return this.originalRequest.getHeaders();
        }

        @Nonnull
        public OutputStream getBody() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public ClientHttpResponse execute() {
            assert (this.future != null);
            Timer timerWait = HttpRequestFetcher.this.registry.timer(MetricRegistry.name((String)HttpRequestFetcher.class.getSimpleName(), (String[])new String[]{"TimeWaitingDownloader"}));
            try (Timer.Context ignored = timerWait.time();){
                this.future.join();
            }
            assert (this.response != null);
            LOGGER.debug("Loading cached URI resource {}", (Object)this.originalRequest.getURI());
            ClientHttpResponse result = this.response;
            this.response = null;
            this.future = null;
            return result;
        }

        @Override
        public Void call() throws Exception {
            return this.context.mdcContextEx(() -> {
                String baseMetricName = MetricRegistry.name((String)HttpRequestFetcher.class.getSimpleName(), (String[])new String[]{"read", StatsUtils.quotePart(this.getURI().getHost())});
                Timer timerDownload = HttpRequestFetcher.this.registry.timer(baseMetricName);
                try (Timer.Context ignored = timerDownload.time();){
                    try {
                        this.context.stopIfCanceled();
                        this.response = new CachedClientHttpResponse(this.originalRequest.execute());
                    }
                    catch (IOException | RuntimeException e) {
                        LOGGER.error("Request failed {}", (Object)this.originalRequest.getURI(), (Object)e);
                        String errorCounter = MetricRegistry.name((String)baseMetricName, (String[])new String[]{"error"});
                        HttpRequestFetcher.this.registry.counter(errorCounter).inc();
                        this.response = new ErrorResponseClientHttpResponse(e);
                    }
                }
                return null;
            });
        }

        public void setFuture(@Nonnull ForkJoinTask<Void> future) {
            this.future = future;
        }
    }

    private final class CachedClientHttpResponse
    extends AbstractClientHttpResponse {
        private final File cachedFile;
        private final HttpHeaders headers;
        private final int status;
        private final String statusText;
        private InputStream body;

        private CachedClientHttpResponse(ClientHttpResponse originalResponse) throws IOException {
            this.headers = originalResponse.getHeaders();
            this.status = originalResponse.getRawStatusCode();
            this.statusText = originalResponse.getStatusText();
            this.cachedFile = this.createCachedFile(originalResponse.getBody());
        }

        private File createCachedFile(InputStream originalBody) throws IOException {
            File tempFile = File.createTempFile("cacheduri", null, HttpRequestFetcher.this.temporaryDirectory);
            LOGGER.debug("Caching URI resource to {}", (Object)tempFile);
            try (OutputStream os = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);){
                LOGGER.debug("Get from input stream {}, body available: {}", originalBody.getClass(), (Object)originalBody.available());
                IOUtils.copy((InputStream)originalBody, (OutputStream)os);
                originalBody.close();
            }
            return tempFile;
        }

        @Nonnull
        public InputStream getBody() throws IOException {
            if (this.body == null) {
                LOGGER.debug("Loading cached URI resource from {}", (Object)this.cachedFile);
                this.body = new FileInputStream(this.cachedFile);
            }
            return this.body;
        }

        @Nonnull
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public int getRawStatusCode() {
            return this.status;
        }

        @Nonnull
        public String getStatusText() {
            return this.statusText;
        }

        public void close() {
            if (this.body != null) {
                try {
                    this.body.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close body", (Throwable)e);
                }
                finally {
                    this.body = null;
                }
            }
        }
    }
}

