/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.PrintException;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.ConfigFileResolvingHttpRequestFactory;
import org.mapfish.print.http.ConfigurableRequest;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.url.data.DataUrlConnection;
import org.mapfish.print.url.data.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

final class ConfigFileResolvingRequest
extends AbstractClientHttpRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileResolvingRequest.class);
    private final ConfigFileResolvingHttpRequestFactory configFileResolvingHttpRequestFactory;
    private final URI uri;
    private final HttpMethod httpMethod;
    private ClientHttpRequest request;

    ConfigFileResolvingRequest(@Nonnull ConfigFileResolvingHttpRequestFactory configFileResolvingHttpRequestFactory, @Nonnull URI uri, @Nonnull HttpMethod httpMethod) {
        this.configFileResolvingHttpRequestFactory = configFileResolvingHttpRequestFactory;
        this.uri = uri;
        this.httpMethod = httpMethod;
    }

    @Nonnull
    protected synchronized OutputStream getBodyInternal(@Nonnull HttpHeaders headers) throws IOException {
        Assert.isTrue((this.request == null ? 1 : 0) != 0, (String)"getBodyInternal() can only be called once.");
        this.request = this.createRequestFromWrapped(headers);
        return this.request.getBody();
    }

    private synchronized ClientHttpRequest createRequestFromWrapped(HttpHeaders headers) {
        ConfigurableRequest httpRequest = this.createHttpRequest();
        httpRequest.setConfiguration(this.configFileResolvingHttpRequestFactory.getConfig());
        httpRequest.getHeaders().putAll((Map)headers);
        this.setHeadersFromMDCContext(httpRequest, "job_id", "X-Request-ID", "X-Job-ID");
        this.setHeadersFromMDCContext(httpRequest, "application_id", "X-Application-ID");
        return httpRequest;
    }

    private ConfigurableRequest createHttpRequest() {
        return this.configFileResolvingHttpRequestFactory.getHttpRequestFactory().createRequest(this.uri, this.httpMethod);
    }

    private void setHeadersFromMDCContext(ConfigurableRequest request, String mdcContextKey, String ... headersKeys) {
        Map<String, String> mdcContext = this.getMdcContext();
        if (mdcContext.containsKey(mdcContextKey)) {
            String value = mdcContext.get(mdcContextKey);
            Arrays.stream(headersKeys).forEach(headerKey -> request.getHeaders().set(headerKey, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected synchronized ClientHttpResponse executeInternal(@Nonnull HttpHeaders headers) throws IOException {
        Map prev = MDC.getCopyOfContextMap();
        boolean mdcChanged = this.getMdcContext().equals(prev);
        if (mdcChanged) {
            MDC.setContextMap(this.getMdcContext());
        }
        try {
            if ("data".equals(this.uri.getScheme())) {
                ClientHttpResponse clientHttpResponse = this.doDataUriRequest();
                return clientHttpResponse;
            }
            if (this.getURI().getScheme() == null || Arrays.asList("file", "", "servlet", "classpath").contains(this.getURI().getScheme())) {
                ClientHttpResponse clientHttpResponse = this.doFileRequest();
                return clientHttpResponse;
            }
            ClientHttpResponse clientHttpResponse = this.doHttpRequestWithRetry(headers);
            return clientHttpResponse;
        }
        finally {
            if (mdcChanged) {
                MDC.setContextMap((Map)prev);
            }
        }
    }

    private Map<String, String> getMdcContext() {
        return this.configFileResolvingHttpRequestFactory.getMdcContext();
    }

    private ClientHttpResponse doDataUriRequest() throws IOException {
        String urlStr = this.uri.toString();
        URL url = new URL("data", null, 0, urlStr.substring("data:".length()), new Handler());
        DataUrlConnection duc = new DataUrlConnection(url);
        InputStream is = duc.getInputStream();
        String contentType = duc.getContentType();
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Content-Type", contentType);
        ConfigFileResolverHttpResponse response = new ConfigFileResolverHttpResponse(is, responseHeaders);
        LOGGER.debug("Resolved request using DataUrlConnection: {}", (Object)contentType);
        return response;
    }

    private ClientHttpResponse doFileRequest() throws IOException {
        String uriString = this.uri.toString();
        Configuration configuration = this.configFileResolvingHttpRequestFactory.getConfig();
        byte[] bytes = configuration.loadFile(uriString);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        HttpHeaders responseHeaders = new HttpHeaders();
        Optional<File> file = configuration.getFile(uriString);
        if (file.isPresent()) {
            responseHeaders.set("Content-Length", String.valueOf(Files.probeContentType(file.get().toPath())));
        }
        ConfigFileResolverHttpResponse response = new ConfigFileResolverHttpResponse(is, responseHeaders);
        LOGGER.debug("Resolved request: {} using MapFish print config file loaders.", (Object)uriString);
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClientHttpResponse doHttpRequestWithRetry(HttpHeaders headers) throws IOException {
        AtomicInteger counter = new AtomicInteger();
        while (true) {
            this.logFetchingURIResource(headers);
            try {
                ClientHttpResponse response = this.attemptToFetchResponse(headers);
                if (response != null) {
                    return response;
                }
                if (this.canRetry(counter)) {
                    this.sleepWithExceptionHandling();
                    LOGGER.debug("Retry fetching {}", (Object)this.getURI());
                    continue;
                }
                PrintException printException = new PrintException("Failed fetching " + this.getURI());
                LOGGER.debug("Throwing exception since it cannot retry.", (Throwable)printException);
                throw printException;
            }
            catch (IOException | RuntimeException e) {
                boolean hasSlept = this.sleepIfPossible(e, counter);
                if (!hasSlept) throw e;
                continue;
            }
            break;
        }
    }

    private void logFetchingURIResource(HttpHeaders headers) {
        LOGGER.debug("Fetching {}, using headers:\n{}", (Object)this.getURI(), (Object)headers.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + String.join((CharSequence)", ", (Iterable)entry.getValue())).collect(Collectors.joining("\n")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientHttpResponse attemptToFetchResponse(HttpHeaders headers) throws IOException {
        int minStatusCodeError;
        ClientHttpRequest requestUsed = this.request != null ? this.request : this.createRequestFromWrapped(headers);
        LOGGER.debug("Executing http request: {}", (Object)requestUsed.getURI());
        ClientHttpResponse response = this.executeCallbacksAndRequest(requestUsed);
        int rawStatusCode = minStatusCodeError = HttpStatus.INTERNAL_SERVER_ERROR.value();
        try {
            rawStatusCode = response.getRawStatusCode();
            if (rawStatusCode < minStatusCodeError) {
                LOGGER.debug("Successfully fetched {}, with status code {}", (Object)this.getURI(), (Object)rawStatusCode);
                ClientHttpResponse clientHttpResponse = response;
                return clientHttpResponse;
            }
            LOGGER.debug("Failed fetching {}, with error code {}", (Object)this.getURI(), (Object)rawStatusCode);
            ClientHttpResponse clientHttpResponse = null;
            return clientHttpResponse;
        }
        finally {
            if (rawStatusCode >= minStatusCodeError) {
                response.close();
            }
        }
    }

    private boolean sleepIfPossible(Exception e, AtomicInteger counter) {
        if (this.canRetry(counter)) {
            this.sleepWithExceptionHandling();
            LOGGER.debug("Retry fetching {} following exception", (Object)this.getURI(), (Object)e);
            return true;
        }
        LOGGER.debug("Reached maximum number of {} allowed requests attempts for {}", (Object)this.getHttpRequestMaxNumberFetchRetry(), (Object)this.getURI());
        return false;
    }

    private void sleepWithExceptionHandling() {
        int sleepMs = this.configFileResolvingHttpRequestFactory.getHttpRequestFetchRetryIntervalMillis();
        LOGGER.debug("Sleeping {} ms before retrying.", (Object)sleepMs);
        try {
            TimeUnit.MILLISECONDS.sleep(sleepMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrintException("Interrupted while sleeping", e);
        }
    }

    private boolean canRetry(AtomicInteger counter) {
        return counter.incrementAndGet() < this.getHttpRequestMaxNumberFetchRetry();
    }

    private int getHttpRequestMaxNumberFetchRetry() {
        return this.configFileResolvingHttpRequestFactory.getHttpRequestMaxNumberFetchRetry();
    }

    private ClientHttpResponse executeCallbacksAndRequest(ClientHttpRequest requestToExecute) throws IOException {
        for (MfClientHttpRequestFactory.RequestConfigurator callback : this.configFileResolvingHttpRequestFactory.getCallbacks()) {
            callback.configureRequest(requestToExecute);
        }
        return requestToExecute.execute();
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    @Nonnull
    public String getMethodValue() {
        return this.httpMethod.name();
    }

    @Nonnull
    public URI getURI() {
        return this.uri;
    }

    private static class ConfigFileResolverHttpResponse
    implements ClientHttpResponse {
        private final InputStream is;
        private final HttpHeaders headers;

        ConfigFileResolverHttpResponse(InputStream is, HttpHeaders headers) {
            this.headers = headers;
            this.is = is;
        }

        @Nonnull
        public HttpStatus getStatusCode() {
            return HttpStatus.OK;
        }

        public int getRawStatusCode() {
            return this.getStatusCode().value();
        }

        @Nonnull
        public String getStatusText() {
            return "OK";
        }

        public void close() {
        }

        @Nonnull
        public InputStream getBody() {
            return this.is;
        }

        @Nonnull
        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }
}

