/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.ConfigFileResolvingRequest;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class ConfigFileResolvingHttpRequestFactory
implements MfClientHttpRequestFactory {
    private final Configuration config;
    @Nonnull
    private final Map<String, String> mdcContext;
    private final MfClientHttpRequestFactoryImpl httpRequestFactory;
    private final List<MfClientHttpRequestFactory.RequestConfigurator> callbacks = new CopyOnWriteArrayList<MfClientHttpRequestFactory.RequestConfigurator>();
    @Value(value="${httpRequest.fetchRetry.maxNumber}")
    private int httpRequestMaxNumberFetchRetry;
    @Value(value="${httpRequest.fetchRetry.intervalMillis}")
    private int httpRequestFetchRetryIntervalMillis;

    public ConfigFileResolvingHttpRequestFactory(MfClientHttpRequestFactoryImpl httpRequestFactory, Configuration config, @Nonnull Map<String, String> mdcContext, int httpRequestMaxNumberFetchRetry, int httpRequestFetchRetryIntervalMillis) {
        this.httpRequestFactory = httpRequestFactory;
        this.config = config;
        this.mdcContext = mdcContext;
        this.httpRequestMaxNumberFetchRetry = httpRequestMaxNumberFetchRetry;
        this.httpRequestFetchRetryIntervalMillis = httpRequestFetchRetryIntervalMillis;
    }

    @Override
    public void register(@Nonnull MfClientHttpRequestFactory.RequestConfigurator callback) {
        this.callbacks.add(callback);
    }

    @Nonnull
    public ClientHttpRequest createRequest(@Nonnull URI uri, @Nonnull HttpMethod httpMethod) {
        return new ConfigFileResolvingRequest(this, uri, httpMethod);
    }

    public MfClientHttpRequestFactoryImpl getHttpRequestFactory() {
        return this.httpRequestFactory;
    }

    @Nonnull
    public Map<String, String> getMdcContext() {
        return this.mdcContext;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public int getHttpRequestMaxNumberFetchRetry() {
        return this.httpRequestMaxNumberFetchRetry;
    }

    public int getHttpRequestFetchRetryIntervalMillis() {
        return this.httpRequestFetchRetryIntervalMillis;
    }

    public List<MfClientHttpRequestFactory.RequestConfigurator> getCallbacks() {
        return this.callbacks;
    }
}

