/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import java.io.IOException;
import java.net.URI;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.http.matcher.UriMatchers;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.util.Assert;

public abstract class AbstractMfClientHttpRequestFactoryWrapper
implements MfClientHttpRequestFactory {
    private final MfClientHttpRequestFactory wrappedFactory;
    private final UriMatchers matchers;
    private final boolean failIfNotMatch;

    protected AbstractMfClientHttpRequestFactoryWrapper(MfClientHttpRequestFactory wrappedFactory, UriMatchers matchers, boolean failIfNotMatch) {
        Assert.notNull((Object)wrappedFactory, (String)"'requestFactory' must not be null");
        Assert.notNull((Object)matchers, (String)"'matchers' must not be null");
        this.wrappedFactory = wrappedFactory;
        this.matchers = matchers;
        this.failIfNotMatch = failIfNotMatch;
    }

    public final ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        if (uri.getScheme() == null || uri.getScheme().equals("file") || this.matchers.matches(uri, httpMethod)) {
            return this.createRequest(uri, httpMethod, this.wrappedFactory);
        }
        if (this.failIfNotMatch) {
            throw new IllegalArgumentException(uri + " is denied.");
        }
        return this.wrappedFactory.createRequest(uri, httpMethod);
    }

    protected abstract ClientHttpRequest createRequest(URI var1, HttpMethod var2, MfClientHttpRequestFactory var3) throws IOException;

    @Override
    public final void register(MfClientHttpRequestFactory.RequestConfigurator callback) {
        this.wrappedFactory.register(callback);
    }
}

