/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import java.awt.Rectangle;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.Scale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapBounds {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapBounds.class);
    private final CoordinateReferenceSystem projection;

    protected MapBounds(CoordinateReferenceSystem projection) {
        this.projection = projection;
    }

    public abstract ReferencedEnvelope toReferencedEnvelope(Rectangle var1);

    public abstract MapBounds adjustedEnvelope(Rectangle var1);

    public final CoordinateReferenceSystem getProjection() {
        return this.projection;
    }

    public abstract MapBounds adjustBoundsToNearestScale(ZoomLevels var1, double var2, ZoomLevelSnapStrategy var4, boolean var5, Rectangle var6, double var7);

    public Scale getNearestScale(ZoomLevels zoomLevels, double tolerance, ZoomLevelSnapStrategy zoomLevelSnapStrategy, boolean geodetic, Rectangle paintArea, double dpi) {
        Scale correctedScale;
        double scaleRatio;
        Scale scale = this.getScale(paintArea, dpi);
        if (geodetic) {
            double currentScaleDenominator = scale.getGeodeticDenominator(this.getProjection(), dpi, this.getCenter());
            scaleRatio = scale.getDenominator(dpi) / currentScaleDenominator;
            correctedScale = scale.toResolution(scale.getResolution() / scaleRatio);
        } else {
            scaleRatio = 1.0;
            correctedScale = scale;
        }
        DistanceUnit unit = DistanceUnit.fromProjection(this.getProjection());
        ZoomLevelSnapStrategy.SearchResult result = zoomLevelSnapStrategy.search(correctedScale, tolerance, zoomLevels);
        Scale newScale = geodetic ? new Scale(result.getScale(unit).getDenominator(72.0) * scaleRatio, this.getProjection(), dpi) : result.getScale(unit);
        return newScale;
    }

    public abstract Scale getScale(Rectangle var1, double var2);

    public abstract MapBounds adjustBoundsToRotation(double var1);

    public abstract MapBounds zoomOut(double var1);

    public abstract MapBounds zoomToScale(Scale var1);

    public abstract Coordinate getCenter();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBounds mapBounds = (MapBounds)o;
        return this.projection.equals(mapBounds.projection);
    }

    public int hashCode() {
        return this.projection.hashCode();
    }
}

