/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.geom.GeometryJSON;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.Constants;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.parser.HasDefaultValue;

public final class AreaOfInterest {
    public String area;
    @HasDefaultValue
    public AoiDisplay display = AoiDisplay.RENDER;
    @HasDefaultValue
    public String style;
    @HasDefaultValue
    public Boolean renderAsSvg;
    private Geometry polygon;

    public void postConstruct() {
        this.parseGeometry();
        Assert.isTrue((this.polygon != null ? 1 : 0) != 0, (String)("Polygon is null. 'area' string is: '" + this.area + "'"));
        Assert.isTrue((this.display != null ? 1 : 0) != 0, (String)"'display' is null");
        Assert.isTrue((this.style == null || this.display == AoiDisplay.RENDER ? 1 : 0) != 0, (String)("'style' does not make sense unless 'display' == RENDER.  In this case 'display' == " + this.display));
    }

    private void parseGeometry() {
        GeometryJSON json = new GeometryJSON();
        try {
            byte[] bytes = this.area.getBytes(Constants.DEFAULT_ENCODING);
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            this.polygon = json.read((InputStream)input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Geometry getArea() {
        if (this.polygon == null) {
            this.parseGeometry();
        }
        return this.polygon;
    }

    public SimpleFeatureCollection areaToFeatureCollection(@Nonnull MapAttribute.MapAttributeValues mapAttributes) {
        Assert.isTrue((mapAttributes.areaOfInterest == this ? 1 : 0) != 0, (String)"map attributes passed in does not contain this area of interest object");
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("aoi");
        CoordinateReferenceSystem crs = mapAttributes.getMapBounds().getProjection();
        typeBuilder.add("geom", this.polygon.getClass(), crs);
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)typeBuilder.buildFeatureType(), (Object[])new Object[]{this.polygon}, (String)"aoi");
        DefaultFeatureCollection features = new DefaultFeatureCollection();
        features.add(feature);
        return features;
    }

    public void setPolygon(Geometry polygon) {
        this.polygon = polygon;
    }

    public AreaOfInterest copy() {
        AreaOfInterest aoi = new AreaOfInterest();
        aoi.display = this.display;
        aoi.area = this.area;
        aoi.polygon = this.polygon;
        aoi.style = this.style;
        aoi.renderAsSvg = this.renderAsSvg;
        return aoi;
    }

    public static enum AoiDisplay {
        RENDER,
        CLIP,
        NONE;

    }
}

