/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute;

import java.io.IOException;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.mapfish.print.attribute.ReflectiveAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.FeaturesParser;
import org.mapfish.print.parser.HasDefaultValue;

public final class FeaturesAttribute
extends ReflectiveAttribute<FeaturesAttributeValues> {
    @Override
    public Class<FeaturesAttributeValues> getValueType() {
        return FeaturesAttributeValues.class;
    }

    @Override
    public FeaturesAttributeValues createValue(Template template) {
        return new FeaturesAttributeValues(template);
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
    }

    public static final class FeaturesAttributeValues {
        private final Template template;
        public String features;
        @HasDefaultValue
        public Boolean longitudeFirst = null;
        private SimpleFeatureCollection featuresCollection;

        public FeaturesAttributeValues(Template template) {
            this.template = template;
        }

        public synchronized SimpleFeatureCollection getFeatures(MfClientHttpRequestFactory httpRequestFactory) throws IOException {
            if (this.featuresCollection == null) {
                boolean forceLongitudeFirst = this.longitudeFirst == null ? false : this.longitudeFirst;
                FeaturesParser parser = new FeaturesParser(httpRequestFactory, forceLongitudeFirst);
                this.featuresCollection = parser.autoTreat(this.template, this.features);
            }
            return this.featuresCollection;
        }
    }
}

