/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary.config;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;

public class MToastConfig {
    public float toastTextSize = 13.0f;
    public int toastTextColor = Color.parseColor((String)"#FFFFFFFF");
    public int toastBackgroundColor = Color.parseColor((String)"#b2000000");
    public float toastBackgroundCornerRadius = 4.0f;
    public float toastBackgroundStrokeWidth = 0.0f;
    public int toastBackgroundStrokeColor = Color.parseColor((String)"#00000000");
    public MToastGravity toastGravity = MToastGravity.BOTTOM;
    public Drawable toastIcon = null;
    public int paddingLeft = 20;
    public int paddingTop = 12;
    public int paddingRight = 20;
    public int paddingBottom = 12;
    public int imgWidth = 20;
    public int imgHeight = 20;

    private MToastConfig() {
    }

    public static class Builder {
        private MToastConfig mToastConfig = new MToastConfig();

        public MToastConfig build() {
            return this.mToastConfig;
        }

        public Builder setTextColor(@ColorInt int textColor) {
            this.mToastConfig.toastTextColor = textColor;
            return this;
        }

        public Builder setTextSize(float textSize) {
            this.mToastConfig.toastTextSize = textSize;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int backgroundColor) {
            this.mToastConfig.toastBackgroundColor = backgroundColor;
            return this;
        }

        public Builder setBackgroundCornerRadius(float radius) {
            this.mToastConfig.toastBackgroundCornerRadius = radius;
            return this;
        }

        public Builder setGravity(MToastGravity toastGravity) {
            this.mToastConfig.toastGravity = toastGravity;
            return this;
        }

        public Builder setToastIcon(Drawable ToastIcon) {
            this.mToastConfig.toastIcon = ToastIcon;
            return this;
        }

        public Builder setBackgroundStrokeWidth(float width) {
            this.mToastConfig.toastBackgroundStrokeWidth = width;
            return this;
        }

        public Builder setBackgroundStrokeColor(@ColorInt int strokeColor) {
            this.mToastConfig.toastBackgroundStrokeColor = strokeColor;
            return this;
        }

        public Builder setImgWidthAndHeight(int imgWidth, int imgHeight) {
            this.mToastConfig.imgWidth = imgWidth;
            this.mToastConfig.imgHeight = imgHeight;
            return this;
        }

        public Builder setPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
            this.mToastConfig.paddingLeft = paddingLeft;
            this.mToastConfig.paddingTop = paddingTop;
            this.mToastConfig.paddingRight = paddingRight;
            this.mToastConfig.paddingBottom = paddingBottom;
            return this;
        }
    }

    public static enum MToastGravity {
        CENTRE,
        BOTTOM;

    }
}

