/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary.base;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.maning.mndialoglibrary.R;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public abstract class BaseFragmentDialog
extends DialogFragment {
    protected static FragmentActivity mActivity;
    private boolean isShowing = false;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.getDialog().getWindow() != null) {
            this.getDialog().getWindow().setSoftInputMode(16);
            this.getDialog().getWindow().setBackgroundDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)17170445));
            int animations = this.initAnimations();
            if (animations != 0) {
                this.getDialog().getWindow().setWindowAnimations(animations);
            }
        }
        this.setStyle(R.style.MNCustomDialog, 16973834);
        this.getDialog().requestWindowFeature(1);
        this.getDialog().setCanceledOnTouchOutside(false);
        this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                return keyCode == 4;
            }
        });
        this.initDialog();
        return this.initView(inflater);
    }

    protected abstract View initView(LayoutInflater var1);

    public void initDialog() {
    }

    protected abstract int initAnimations();

    public float initBackgroundAlpha() {
        return 0.6f;
    }

    public void showDialog(FragmentActivity mAct) {
        try {
            if (mAct == null) {
                return;
            }
            mActivity = mAct;
            if (this.isShowing()) {
                return;
            }
            if (mActivity != null && mActivity.getSupportFragmentManager() != null) {
                FragmentManager supportFragmentManager = mActivity.getSupportFragmentManager();
                supportFragmentManager.beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
                this.show(supportFragmentManager, mActivity.getLocalClassName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show(FragmentManager manager, String tag) {
        this.isShowing = true;
        try {
            Class<?> c = Class.forName("android.support.v4.app.DialogFragment");
            Constructor<?> con = c.getConstructor(new Class[0]);
            Object obj = con.newInstance(new Object[0]);
            Field dismissed = c.getDeclaredField("mDismissed");
            dismissed.setAccessible(true);
            dismissed.set(obj, false);
            Field shownByMe = c.getDeclaredField("mShownByMe");
            shownByMe.setAccessible(true);
            shownByMe.set(obj, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FragmentTransaction ft = manager.beginTransaction();
        ft.add((Fragment)this, tag);
        ft.commitAllowingStateLoss();
    }

    public boolean isShowing() {
        return this.isShowing || this.getDialog() != null && this.getDialog().isShowing();
    }

    public void onStart() {
        super.onStart();
        Window window = this.getDialog().getWindow();
        if (window != null) {
            WindowManager.LayoutParams windowParams = window.getAttributes();
            windowParams.dimAmount = this.initBackgroundAlpha();
            windowParams.width = -1;
            windowParams.height = -2;
            window.setAttributes(windowParams);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.isShowing = false;
        mActivity = null;
    }

    public void dismiss() {
        this.isShowing = false;
        mActivity = null;
        this.dismissAllowingStateLoss();
    }

    public void dismissAllowingStateLoss() {
        this.isShowing = false;
        mActivity = null;
        super.dismissAllowingStateLoss();
    }
}

