/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.maning.mndialoglibrary.R;
import com.maning.mndialoglibrary.utils.MSizeUtils;
import com.maning.mndialoglibrary.view.MNHudCircularProgressBar;

public class MProgressBarDialog {
    public static final int MProgressBarDialogStyle_Horizontal = 0;
    public static final int MProgressBarDialogStyle_Circle = 1;
    private long mDuration = 300L;
    private Context mContext;
    private Dialog mDialog;
    private Builder mBuilder;
    private RelativeLayout dialog_window_background;
    private RelativeLayout dialog_view_bg;
    private TextView tvShow;
    private ProgressBar horizontalProgressBar;
    private MNHudCircularProgressBar circularProgressBar;

    public MProgressBarDialog(Context context) {
        this(context, new Builder(context));
    }

    public MProgressBarDialog(Context context, Builder builder) {
        this.mContext = context;
        this.mBuilder = builder;
        if (this.mBuilder == null) {
            this.mBuilder = new Builder(this.mContext);
        }
        this.initDialog();
    }

    private void initDialog() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        View mProgressDialogView = inflater.inflate(R.layout.mn_progress_bar_dialog_layout, null);
        this.mDialog = new Dialog(this.mContext, R.style.MNCustomDialog);
        this.mDialog.setCancelable(false);
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setContentView(mProgressDialogView);
        Resources resources = this.mContext.getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        int screenW = dm.widthPixels;
        int screenH = dm.heightPixels;
        WindowManager.LayoutParams layoutParams = this.mDialog.getWindow().getAttributes();
        layoutParams.width = screenW;
        layoutParams.height = screenH;
        this.mDialog.getWindow().setAttributes(layoutParams);
        if (this.mBuilder.animationID != 0) {
            try {
                this.mDialog.getWindow().setWindowAnimations(this.mBuilder.animationID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dialog_window_background = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_window_background);
        this.dialog_view_bg = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_view_bg);
        this.tvShow = (TextView)mProgressDialogView.findViewById(R.id.tvShow);
        this.horizontalProgressBar = (ProgressBar)mProgressDialogView.findViewById(R.id.horizontalProgressBar);
        this.circularProgressBar = (MNHudCircularProgressBar)mProgressDialogView.findViewById(R.id.circularProgressBar);
        this.horizontalProgressBar.setVisibility(8);
        this.circularProgressBar.setVisibility(8);
        this.horizontalProgressBar.setProgress(0);
        this.horizontalProgressBar.setSecondaryProgress(0);
        this.circularProgressBar.setProgress(0.0f);
        this.tvShow.setText((CharSequence)"");
        this.configView();
    }

    private void configView() {
        if (this.mBuilder == null) {
            this.mBuilder = new Builder(this.mContext);
        }
        this.dialog_window_background.setBackgroundColor(this.mBuilder.backgroundWindowColor);
        this.tvShow.setTextColor(this.mBuilder.textColor);
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setColor(this.mBuilder.backgroundViewColor);
        myGrad.setStroke(MSizeUtils.dp2px(this.mContext, this.mBuilder.strokeWidth), this.mBuilder.strokeColor);
        myGrad.setCornerRadius((float)MSizeUtils.dp2px(this.mContext, this.mBuilder.cornerRadius));
        if (Build.VERSION.SDK_INT >= 16) {
            this.dialog_view_bg.setBackground((Drawable)myGrad);
        } else {
            this.dialog_view_bg.setBackgroundDrawable((Drawable)myGrad);
        }
        GradientDrawable progressBarBackgroundDrawable = new GradientDrawable();
        progressBarBackgroundDrawable.setColor(this.mBuilder.progressbarBackgroundColor);
        progressBarBackgroundDrawable.setCornerRadius((float)MSizeUtils.dp2px(this.mContext, this.mBuilder.progressCornerRadius));
        GradientDrawable secondProgressDrawable = new GradientDrawable();
        secondProgressDrawable.setColor(this.mBuilder.progressbarBackgroundColor);
        secondProgressDrawable.setCornerRadius((float)MSizeUtils.dp2px(this.mContext, this.mBuilder.progressCornerRadius));
        ClipDrawable hProgressBar02 = new ClipDrawable((Drawable)secondProgressDrawable, 3, 1);
        GradientDrawable progressDrawable = new GradientDrawable();
        progressDrawable.setColor(this.mBuilder.progressColor);
        progressDrawable.setCornerRadius((float)MSizeUtils.dp2px(this.mContext, this.mBuilder.progressCornerRadius));
        ClipDrawable hProgressBar03 = new ClipDrawable((Drawable)progressDrawable, 3, 1);
        Drawable[] layers = new Drawable[]{progressBarBackgroundDrawable, hProgressBar02, hProgressBar03};
        LayerDrawable layerDrawable = new LayerDrawable(layers);
        layerDrawable.setId(0, 0x1020000);
        layerDrawable.setId(1, 16908303);
        layerDrawable.setId(2, 16908301);
        this.horizontalProgressBar.setProgressDrawable((Drawable)layerDrawable);
        ViewGroup.LayoutParams layoutParams = this.horizontalProgressBar.getLayoutParams();
        layoutParams.height = MSizeUtils.dp2px(this.mContext, this.mBuilder.horizontalProgressBarHeight);
        this.horizontalProgressBar.setLayoutParams(layoutParams);
        this.circularProgressBar.setBackgroundColor(this.mBuilder.progressbarBackgroundColor);
        this.circularProgressBar.setColor(this.mBuilder.progressColor);
        this.circularProgressBar.setProgressBarWidth(MSizeUtils.dp2px(this.mContext, this.mBuilder.circleProgressBarWidth));
        this.circularProgressBar.setBackgroundProgressBarWidth(MSizeUtils.dp2px(this.mContext, this.mBuilder.circleProgressBarBackgroundWidth));
    }

    public void showProgress(int progress, String message) {
        this.showProgress(progress, 0, message, true);
    }

    public void showProgress(int progress, String message, boolean animate) {
        this.showProgress(progress, 0, message, animate);
    }

    public void showProgress(int progress, int secondProgress, String message) {
        this.showProgress(progress, secondProgress, message, true);
    }

    public void showProgress(int progress, int secondProgress, String message, boolean animate) {
        if (this.mBuilder.style == 0) {
            if (this.horizontalProgressBar.getVisibility() == 8) {
                this.horizontalProgressBar.setVisibility(0);
            }
            if (!animate) {
                this.horizontalProgressBar.setProgress(progress);
                this.horizontalProgressBar.setSecondaryProgress(secondProgress);
            } else {
                ValueAnimator progressAnim = ValueAnimator.ofInt((int[])new int[]{this.horizontalProgressBar.getProgress(), progress});
                progressAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                progressAnim.setDuration(this.mDuration);
                progressAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        int progressCurrent = (Integer)valueAnimator.getAnimatedValue();
                        MProgressBarDialog.this.horizontalProgressBar.setProgress(progressCurrent);
                    }
                });
                progressAnim.start();
                ValueAnimator progressSecondAnim = ValueAnimator.ofInt((int[])new int[]{this.horizontalProgressBar.getSecondaryProgress(), secondProgress});
                progressSecondAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                progressSecondAnim.setDuration(this.mDuration);
                progressSecondAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        int progressCurrent = (Integer)valueAnimator.getAnimatedValue();
                        MProgressBarDialog.this.horizontalProgressBar.setSecondaryProgress(progressCurrent);
                    }
                });
                progressSecondAnim.start();
            }
        } else {
            if (this.circularProgressBar.getVisibility() == 8) {
                this.circularProgressBar.setVisibility(0);
            }
            this.circularProgressBar.setProgress(progress, animate);
        }
        this.tvShow.setText((CharSequence)message);
        this.mDialog.show();
    }

    public boolean isShowing() {
        if (this.mDialog != null) {
            return this.mDialog.isShowing();
        }
        return false;
    }

    public void dismiss() {
        try {
            if (this.mDialog != null && this.mDialog.isShowing()) {
                this.mDialog.dismiss();
                this.mDialog = null;
                this.mContext = null;
                this.mBuilder = null;
                this.dialog_window_background = null;
                this.dialog_view_bg = null;
                this.tvShow = null;
                this.horizontalProgressBar = null;
                this.circularProgressBar = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshBuilder(Builder builder) {
        this.mBuilder = builder;
        if (this.mBuilder == null) {
            this.mBuilder = new Builder(this.mContext);
        }
        this.configView();
    }

    public static final class Builder {
        private Context mContext;
        int backgroundWindowColor;
        int backgroundViewColor;
        int strokeColor;
        float cornerRadius;
        float strokeWidth;
        int textColor;
        int progressbarBackgroundColor;
        int progressColor;
        float progressCornerRadius;
        int style;
        int circleProgressBarWidth;
        int circleProgressBarBackgroundWidth;
        int horizontalProgressBarHeight;
        int animationID;

        public Builder(Context context) {
            this.mContext = context;
            this.backgroundWindowColor = this.mContext.getResources().getColor(R.color.mn_colorDialogWindowBg);
            this.backgroundViewColor = this.mContext.getResources().getColor(R.color.mn_colorDialogViewBg);
            this.strokeColor = this.mContext.getResources().getColor(R.color.mn_colorDialogTrans);
            this.textColor = this.mContext.getResources().getColor(R.color.mn_colorDialogTextColor);
            this.cornerRadius = 6.0f;
            this.strokeWidth = 0.0f;
            this.progressbarBackgroundColor = this.mContext.getResources().getColor(R.color.mn_colorDialogProgressBarBgColor);
            this.progressColor = this.mContext.getResources().getColor(R.color.mn_colorDialogProgressBarProgressColor);
            this.progressCornerRadius = 2.0f;
            this.style = 0;
            this.circleProgressBarWidth = 3;
            this.circleProgressBarBackgroundWidth = 1;
            this.horizontalProgressBarHeight = 4;
            this.animationID = 0;
        }

        public MProgressBarDialog build() {
            return new MProgressBarDialog(this.mContext, this);
        }

        public Builder setBackgroundWindowColor(@Nullable int backgroundWindowColor) {
            this.backgroundWindowColor = backgroundWindowColor;
            return this;
        }

        public Builder setBackgroundViewColor(@Nullable int backgroundViewColor) {
            this.backgroundViewColor = backgroundViewColor;
            return this;
        }

        public Builder setStrokeColor(@Nullable int strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public Builder setStrokeWidth(@Nullable float strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public Builder setCornerRadius(@Nullable float cornerRadius) {
            this.cornerRadius = cornerRadius;
            return this;
        }

        public Builder setTextColor(@Nullable int textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder setProgressbarBackgroundColor(@Nullable int progressbarBackgroundColor) {
            this.progressbarBackgroundColor = progressbarBackgroundColor;
            return this;
        }

        public Builder setProgressColor(@Nullable int progressColor) {
            this.progressColor = progressColor;
            return this;
        }

        public Builder setProgressCornerRadius(@Nullable int progressCornerRadius) {
            this.progressCornerRadius = progressCornerRadius;
            return this;
        }

        public Builder setStyle(@Nullable int style2) {
            this.style = style2;
            return this;
        }

        public Builder setCircleProgressBarWidth(@Nullable int circleProgressBarWidth) {
            this.circleProgressBarWidth = circleProgressBarWidth;
            return this;
        }

        public Builder setCircleProgressBarBackgroundWidth(@Nullable int circleProgressBarBackgroundWidth) {
            this.circleProgressBarBackgroundWidth = circleProgressBarBackgroundWidth;
            return this;
        }

        public Builder setHorizontalProgressBarHeight(@Nullable int horizontalProgressBarHeight) {
            this.horizontalProgressBarHeight = horizontalProgressBarHeight;
            return this;
        }

        public Builder setAnimationID(@StyleRes int resId) {
            this.animationID = resId;
            return this;
        }
    }
}

