/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary.config;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;

public class MToastConfig {
    public float ToastTextSize = 13.0f;
    public int ToastTextColor = Color.parseColor((String)"#FFFFFFFF");
    public int ToastBackgroundColor = Color.parseColor((String)"#b2000000");
    public float ToastBackgroundCornerRadius = 6.0f;
    public float ToastBackgroundStrokeWidth = 0.0f;
    public int ToastBackgroundStrokeColor = Color.parseColor((String)"#00000000");
    public MToastGravity ToastGravity = MToastGravity.BOTTOM;
    public Drawable ToastIcon = null;
    public int paddingLeft = 20;
    public int paddingTop = 12;
    public int paddingRight = 20;
    public int paddingBottom = 12;
    public int imgWidth = 20;
    public int imgHeight = 20;

    private MToastConfig() {
    }

    public static class Builder {
        private MToastConfig mToastConfig = new MToastConfig();

        public MToastConfig build() {
            return this.mToastConfig;
        }

        public Builder setTextColor(@ColorInt int textColor) {
            this.mToastConfig.ToastTextColor = textColor;
            return this;
        }

        public Builder setTextSize(float textSize) {
            this.mToastConfig.ToastTextSize = textSize;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int backgroundColor) {
            this.mToastConfig.ToastBackgroundColor = backgroundColor;
            return this;
        }

        public Builder setBackgroundCornerRadius(float radius) {
            this.mToastConfig.ToastBackgroundCornerRadius = radius;
            return this;
        }

        public Builder setGravity(MToastGravity toastGravity) {
            this.mToastConfig.ToastGravity = toastGravity;
            return this;
        }

        public Builder setToastIcon(Drawable ToastIcon) {
            this.mToastConfig.ToastIcon = ToastIcon;
            return this;
        }

        public Builder setBackgroundStrokeWidth(float width) {
            this.mToastConfig.ToastBackgroundStrokeWidth = width;
            return this;
        }

        public Builder setBackgroundStrokeColor(@ColorInt int strokeColor) {
            this.mToastConfig.ToastBackgroundStrokeColor = strokeColor;
            return this;
        }

        public Builder setImgWidthAndHeight(int imgWidth, int imgHeight) {
            this.mToastConfig.imgWidth = imgWidth;
            this.mToastConfig.imgHeight = imgHeight;
            return this;
        }

        public Builder setPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
            this.mToastConfig.paddingLeft = paddingLeft;
            this.mToastConfig.paddingTop = paddingTop;
            this.mToastConfig.paddingRight = paddingRight;
            this.mToastConfig.paddingBottom = paddingBottom;
            return this;
        }
    }

    public static enum MToastGravity {
        CENTRE,
        BOTTOM;

    }
}

