/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary.config;

import android.graphics.Color;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import com.maning.mndialoglibrary.listeners.OnDialogDismissListener;

public class MDialogConfig {
    public boolean canceledOnTouchOutside = false;
    public int backgroundWindowColor = 0;
    public int backgroundViewColor = Color.parseColor((String)"#b2000000");
    public int strokeColor = 0;
    public float cornerRadius = 8.0f;
    public float strokeWidth = 0.0f;
    public int progressColor = -1;
    public float progressWidth = 2.0f;
    public int progressRimColor = 0;
    public int progressRimWidth = 0;
    public int textColor = -1;
    public OnDialogDismissListener onDialogDismissListener;
    public int animationID;

    private MDialogConfig() {
    }

    public static class Builder {
        private MDialogConfig mToastConfig = new MDialogConfig();

        public MDialogConfig build() {
            return this.mToastConfig;
        }

        public Builder isCanceledOnTouchOutside(@Nullable boolean canceledOnTouchOutside) {
            this.mToastConfig.canceledOnTouchOutside = canceledOnTouchOutside;
            return this;
        }

        public Builder setBackgroundWindowColor(@Nullable int backgroundWindowColor) {
            this.mToastConfig.backgroundWindowColor = backgroundWindowColor;
            return this;
        }

        public Builder setBackgroundViewColor(@Nullable int backgroundViewColor) {
            this.mToastConfig.backgroundViewColor = backgroundViewColor;
            return this;
        }

        public Builder setStrokeColor(@Nullable int strokeColor) {
            this.mToastConfig.strokeColor = strokeColor;
            return this;
        }

        public Builder setStrokeWidth(@Nullable float strokeWidth) {
            this.mToastConfig.strokeWidth = strokeWidth;
            return this;
        }

        public Builder setCornerRadius(@Nullable float cornerRadius) {
            this.mToastConfig.cornerRadius = cornerRadius;
            return this;
        }

        public Builder setProgressColor(@Nullable int progressColor) {
            this.mToastConfig.progressColor = progressColor;
            return this;
        }

        public Builder setProgressWidth(@Nullable float progressWidth) {
            this.mToastConfig.progressWidth = progressWidth;
            return this;
        }

        public Builder setProgressRimColor(int progressRimColor) {
            this.mToastConfig.progressRimColor = progressRimColor;
            return this;
        }

        public Builder setProgressRimWidth(int progressRimWidth) {
            this.mToastConfig.progressRimWidth = progressRimWidth;
            return this;
        }

        public Builder setTextColor(@Nullable int textColor) {
            this.mToastConfig.textColor = textColor;
            return this;
        }

        public Builder setOnDialogDismissListener(OnDialogDismissListener onDialogDismissListener) {
            this.mToastConfig.onDialogDismissListener = onDialogDismissListener;
            return this;
        }

        public Builder setAnimationID(@StyleRes int resId) {
            this.mToastConfig.animationID = resId;
            return this;
        }
    }
}

