/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.maning.mndialoglibrary.MProgressWheel;
import com.maning.mndialoglibrary.R;

public class MProgressDialog
implements View.OnClickListener {
    private static final String defaultTextShow = "\u52a0\u8f7d\u4e2d...";
    private Dialog mDialog;
    private Context mContext;
    private Builder mBuilder;
    private RelativeLayout dialog_window_background;
    private RelativeLayout dialog_view_bg;
    private MProgressWheel progress_wheel;
    private TextView tv_show;

    public MProgressDialog(Context context) {
        this(context, new Builder(context));
    }

    public MProgressDialog(Context context, Builder builder) {
        this.mContext = context;
        this.mBuilder = builder;
        this.initDialog();
    }

    private void initDialog() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        View mProgressDialogView = inflater.inflate(R.layout.mn_progress_dialog_layout, null);
        this.mDialog = new Dialog(this.mContext, R.style.MNCustomProgressDialog);
        this.mDialog.setCancelable(false);
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setContentView(mProgressDialogView);
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = ((Activity)this.mContext).getWindowManager();
        windowManager.getDefaultDisplay().getMetrics(dm);
        int screenW = dm.widthPixels;
        int screenH = dm.heightPixels;
        WindowManager.LayoutParams layoutParams = this.mDialog.getWindow().getAttributes();
        layoutParams.width = screenW;
        layoutParams.height = screenH;
        this.mDialog.getWindow().setAttributes(layoutParams);
        this.dialog_window_background = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_window_background);
        this.dialog_view_bg = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_view_bg);
        this.progress_wheel = (MProgressWheel)mProgressDialogView.findViewById(R.id.progress_wheel);
        this.tv_show = (TextView)mProgressDialogView.findViewById(R.id.tv_show);
        this.dialog_window_background.setOnClickListener((View.OnClickListener)this);
        this.progress_wheel.stopSpinning();
        this.tv_show.setText((CharSequence)defaultTextShow);
        this.configView();
    }

    private void configView() {
        this.mDialog.setCanceledOnTouchOutside(this.mBuilder.canceledOnTouchOutside);
        this.dialog_window_background.setBackgroundColor(this.mBuilder.backgroundWindowColor);
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setColor(this.mBuilder.backgroundViewColor);
        myGrad.setStroke(MProgressDialog.dip2px(this.mContext, this.mBuilder.strokeWidth), this.mBuilder.strokeColor);
        myGrad.setCornerRadius((float)MProgressDialog.dip2px(this.mContext, this.mBuilder.cornerRadius));
        this.dialog_view_bg.setBackground((Drawable)myGrad);
        this.progress_wheel.setBarColor(this.mBuilder.progressColor);
        this.progress_wheel.setBarWidth(MProgressDialog.dip2px(this.mContext, this.mBuilder.progressWidth));
        this.progress_wheel.setRimColor(this.mBuilder.progressRimColor);
        this.progress_wheel.setRimWidth(this.mBuilder.progressRimWidth);
        this.tv_show.setTextColor(this.mBuilder.textColor);
    }

    public void refreshBuilder(Builder builder) {
        this.mBuilder = builder;
        this.configView();
    }

    public void show() {
        this.dismiss();
        this.tv_show.setVisibility(0);
        this.tv_show.setText((CharSequence)defaultTextShow);
        if (this.mDialog != null) {
            this.progress_wheel.spin();
            this.mDialog.show();
        }
    }

    public void showNoText() {
        this.dismiss();
        this.tv_show.setVisibility(8);
        if (this.mDialog != null) {
            this.progress_wheel.spin();
            this.mDialog.show();
        }
    }

    public void show(String msg) {
        this.dismiss();
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = defaultTextShow;
        }
        this.tv_show.setVisibility(0);
        this.tv_show.setText((CharSequence)msg);
        if (this.mDialog != null) {
            this.progress_wheel.spin();
            this.mDialog.show();
        }
    }

    public void dismiss() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.progress_wheel.stopSpinning();
            this.mDialog.dismiss();
            if (this.mBuilder.dialogDismissListener != null) {
                this.mBuilder.dialogDismissListener.dismiss();
            }
        }
    }

    public void showWithProgress() {
        this.dismiss();
        this.progress_wheel.stopSpinning();
        this.progress_wheel.setLinearProgress(true);
        this.progress_wheel.setProgress(0.0f);
        this.tv_show.setVisibility(0);
        this.tv_show.setText((CharSequence)defaultTextShow);
        if (this.mDialog != null) {
            this.mDialog.show();
        }
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.dialog_window_background && this.mBuilder.canceledOnTouchOutside) {
            this.dismiss();
        }
    }

    public void setOnDialogDismissListener(OnDialogDismissListener dialogDismissListener) {
        this.mBuilder.dialogDismissListener = dialogDismissListener;
    }

    public void setDialogProgress(float progress, String dialogText) {
        this.progress_wheel.setProgress(progress);
        this.tv_show.setText((CharSequence)dialogText);
    }

    public static final class Builder {
        private Context mContext;
        boolean canceledOnTouchOutside;
        int backgroundWindowColor;
        int backgroundViewColor;
        int strokeColor;
        float cornerRadius;
        float strokeWidth;
        int progressColor;
        float progressWidth;
        int progressRimColor;
        int progressRimWidth;
        int textColor;
        OnDialogDismissListener dialogDismissListener;

        public Builder(Context context) {
            this.mContext = context;
            this.canceledOnTouchOutside = false;
            this.backgroundWindowColor = this.mContext.getResources().getColor(R.color.mn_colorDialogWindowBg);
            this.backgroundViewColor = this.mContext.getResources().getColor(R.color.mn_colorDialogViewBg);
            this.strokeColor = this.mContext.getResources().getColor(R.color.mn_colorDialogTrans);
            this.cornerRadius = 6.0f;
            this.strokeWidth = 0.0f;
            this.progressColor = this.mContext.getResources().getColor(R.color.mn_colorDialogProgressBarColor);
            this.progressRimColor = this.mContext.getResources().getColor(R.color.mn_colorDialogTrans);
            this.progressWidth = 2.0f;
            this.progressRimWidth = 0;
            this.textColor = this.mContext.getResources().getColor(R.color.mn_colorDialogTextColor);
            this.dialogDismissListener = null;
        }

        public MProgressDialog build() {
            return new MProgressDialog(this.mContext, this);
        }

        public Builder isCanceledOnTouchOutside(@Nullable boolean canceledOnTouchOutside) {
            this.canceledOnTouchOutside = canceledOnTouchOutside;
            return this;
        }

        public Builder setBackgroundWindowColor(@Nullable int backgroundWindowColor) {
            this.backgroundWindowColor = backgroundWindowColor;
            return this;
        }

        public Builder setBackgroundViewColor(@Nullable int backgroundViewColor) {
            this.backgroundViewColor = backgroundViewColor;
            return this;
        }

        public Builder setStrokeColor(@Nullable int strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public Builder setStrokeWidth(@Nullable float strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public Builder setCornerRadius(@Nullable float cornerRadius) {
            this.cornerRadius = cornerRadius;
            return this;
        }

        public Builder setProgressColor(@Nullable int progressColor) {
            this.progressColor = progressColor;
            return this;
        }

        public Builder setProgressWidth(@Nullable float progressWidth) {
            this.progressWidth = progressWidth;
            return this;
        }

        public Builder setProgressRimColor(int progressRimColor) {
            this.progressRimColor = progressRimColor;
            return this;
        }

        public Builder setProgressRimWidth(int progressRimWidth) {
            this.progressRimWidth = progressRimWidth;
            return this;
        }

        public Builder setTextColor(@Nullable int textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder setOnDialogDismissListener(OnDialogDismissListener dialogDismissListener) {
            this.dialogDismissListener = dialogDismissListener;
            return this;
        }
    }

    public static interface OnDialogDismissListener {
        public void dismiss();
    }
}

