/*
 * Decompiled with CFR 0.152.
 */
package com.maning.pswedittextlibrary;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import com.maning.pswedittextlibrary.R;
import java.lang.reflect.Field;

public class MNPasswordEditText
extends EditText {
    private static final String TAG = "MNPasswordEditText";
    private Context mContext;
    private String defaultColor = "#FF0000";
    private int maxLength;
    private int textColor;
    private Paint mPaintText;
    private Paint mPaintLine;
    private int backgroundColor;
    private int borderColor;
    private int borderSelectedColor;
    private float borderRadius;
    private float borderWidth;
    private float itemMargin;
    private int inputMode;
    private int editTextStyle;
    private String coverText;
    private int coverBitmapID;
    private float coverBitmapWidth;
    private int coverCirclrColor;
    private float coverCirclrRadius;
    private GradientDrawable gradientDrawable = new GradientDrawable();
    private Bitmap coverBitmap;
    private Paint mPaintCursor;
    private GradientDrawable cursorDrawable = new GradientDrawable();
    private int cursorColor;
    private float cursorWidth;
    private float cursorHeight;
    private float cursorCornerRadius;
    private boolean showCursor = false;
    private boolean mCursorFlag;
    private Blink mBlink;
    private OnTextChangeListener onTextChangeListener;

    public MNPasswordEditText(Context context) {
        this(context, null);
    }

    public MNPasswordEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MNPasswordEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initAttrs(attrs, defStyleAttr);
        this.init();
    }

    private void initAttrs(AttributeSet attrs, int defStyleAttr) {
        TypedArray array = this.mContext.obtainStyledAttributes(attrs, R.styleable.MNPasswordEditText, defStyleAttr, 0);
        this.backgroundColor = array.getColor(R.styleable.MNPasswordEditText_psw_background_color, Color.parseColor((String)"#FFFFFF"));
        this.borderColor = array.getColor(R.styleable.MNPasswordEditText_psw_border_color, Color.parseColor((String)this.defaultColor));
        this.borderSelectedColor = array.getColor(R.styleable.MNPasswordEditText_psw_border_selected_color, Color.parseColor((String)this.defaultColor));
        this.textColor = array.getColor(R.styleable.MNPasswordEditText_psw_text_color, Color.parseColor((String)this.defaultColor));
        this.borderRadius = array.getDimension(R.styleable.MNPasswordEditText_psw_border_radius, (float)this.dip2px(6.0f));
        this.borderWidth = array.getDimension(R.styleable.MNPasswordEditText_psw_border_width, (float)this.dip2px(1.0f));
        this.itemMargin = array.getDimension(R.styleable.MNPasswordEditText_psw_item_margin, (float)this.dip2px(10.0f));
        this.inputMode = array.getInt(R.styleable.MNPasswordEditText_psw_mode, 1);
        this.editTextStyle = array.getInt(R.styleable.MNPasswordEditText_psw_style, 1);
        this.coverBitmapID = array.getResourceId(R.styleable.MNPasswordEditText_psw_cover_bitmap_id, -1);
        this.coverText = array.getString(R.styleable.MNPasswordEditText_psw_cover_text);
        if (TextUtils.isEmpty((CharSequence)this.coverText)) {
            this.coverText = "\u5bc6";
        }
        this.coverCirclrColor = array.getColor(R.styleable.MNPasswordEditText_psw_cover_circle_color, Color.parseColor((String)this.defaultColor));
        this.coverCirclrRadius = array.getDimension(R.styleable.MNPasswordEditText_psw_cover_circle_radius, 0.0f);
        this.coverBitmapWidth = array.getDimension(R.styleable.MNPasswordEditText_psw_cover_bitmap_width, 0.0f);
        this.showCursor = array.getBoolean(R.styleable.MNPasswordEditText_psw_show_cursor, false);
        this.cursorColor = array.getColor(R.styleable.MNPasswordEditText_psw_cursor_color, this.borderSelectedColor);
        this.cursorHeight = array.getDimension(R.styleable.MNPasswordEditText_psw_cursor_height, 0.0f);
        this.cursorWidth = array.getDimension(R.styleable.MNPasswordEditText_psw_cursor_width, 6.0f);
        this.cursorCornerRadius = array.getDimension(R.styleable.MNPasswordEditText_psw_cursor_corner_radius, 0.0f);
        array.recycle();
    }

    private void init() {
        this.maxLength = this.getMaxLength();
        this.setCursorVisible(false);
        this.setTextColor(0);
        this.setFocusableInTouchMode(true);
        this.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return true;
            }
        });
        this.mPaintText = new Paint(1);
        this.mPaintText.setStyle(Paint.Style.FILL);
        this.mPaintText.setColor(this.textColor);
        this.mPaintText.setTextSize(this.getTextSize());
        this.mPaintLine = new Paint(1);
        this.mPaintLine.setStyle(Paint.Style.STROKE);
        this.mPaintLine.setColor(this.borderColor);
        this.mPaintLine.setStrokeWidth(this.borderWidth);
        this.cursorDrawable.setCornerRadius(this.cursorCornerRadius);
        this.cursorDrawable.setColor(this.cursorColor);
        this.mPaintCursor = new Paint(1);
        this.mPaintCursor.setStyle(Paint.Style.FILL);
        this.mPaintCursor.setColor(this.cursorColor);
        if (this.inputMode == 2) {
            if (this.coverBitmapID == -1) {
                throw new NullPointerException("\u906e\u76d6\u56fe\u7247\u4e3a\u7a7a");
            }
            this.coverBitmap = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)this.coverBitmapID);
        }
    }

    protected void onDraw(Canvas canvas) {
        float stopY;
        float stopX;
        super.onDraw(canvas);
        int measuredWidth = this.getMeasuredWidth();
        float itemH = this.getMeasuredHeight();
        float margin = this.itemMargin;
        float itemW = ((float)measuredWidth - margin * (float)(this.maxLength - 1)) / (float)this.maxLength;
        int currentIndex = this.getText().length();
        if (this.editTextStyle == 1) {
            this.gradientDrawable.setStroke((int)this.borderWidth, this.borderColor);
            this.gradientDrawable.setCornerRadius(this.borderRadius);
            this.gradientDrawable.setColor(this.backgroundColor);
            if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground((Drawable)this.gradientDrawable);
            } else {
                this.setBackgroundDrawable((Drawable)this.gradientDrawable);
            }
            margin = 0.0f;
            itemW = measuredWidth / this.maxLength;
            for (int i = 1; i < this.maxLength; ++i) {
                float startX = itemW * (float)i;
                float startY = 0.0f;
                stopX = startX;
                stopY = itemH;
                canvas.drawLine(startX, startY, stopX, stopY, this.mPaintLine);
            }
        } else if (this.editTextStyle == 2) {
            this.gradientDrawable.setStroke((int)this.borderWidth, this.borderColor);
            this.gradientDrawable.setCornerRadius(this.borderRadius);
            this.gradientDrawable.setColor(this.backgroundColor);
            Bitmap bitmap = MNPasswordEditText.drawableToBitmap((Drawable)this.gradientDrawable, (int)itemW, (int)itemH);
            Bitmap bitmapSelected = null;
            if (this.borderSelectedColor != 0) {
                this.gradientDrawable.setStroke((int)this.borderWidth, this.borderSelectedColor);
                bitmapSelected = MNPasswordEditText.drawableToBitmap((Drawable)this.gradientDrawable, (int)itemW, (int)itemH);
            }
            for (int i = 0; i < this.maxLength; ++i) {
                float left = itemW * (float)i + margin * (float)i;
                float top = 0.0f;
                if (bitmapSelected == null) {
                    canvas.drawBitmap(bitmap, left, top, this.mPaintLine);
                    continue;
                }
                if (currentIndex == i) {
                    canvas.drawBitmap(bitmapSelected, left, top, this.mPaintLine);
                    continue;
                }
                canvas.drawBitmap(bitmap, left, top, this.mPaintLine);
            }
        } else if (this.editTextStyle == 3) {
            for (int i = 0; i < this.maxLength; ++i) {
                if (this.borderSelectedColor != 0) {
                    if (currentIndex == i) {
                        this.mPaintLine.setColor(this.borderSelectedColor);
                    } else {
                        this.mPaintLine.setColor(this.borderColor);
                    }
                } else {
                    this.mPaintLine.setColor(this.borderColor);
                }
                float startX = itemW * (float)i + this.itemMargin * (float)i;
                float startY = itemH - this.borderWidth;
                stopX = startX + itemW;
                stopY = startY;
                canvas.drawLine(startX, startY, stopX, stopY, this.mPaintLine);
            }
        }
        String currentText = this.getText().toString();
        for (int i = 0; i < this.maxLength; ++i) {
            float startY;
            float startX;
            if (TextUtils.isEmpty((CharSequence)currentText) || i >= currentText.length()) continue;
            if (this.inputMode == 1) {
                float circleRadius = itemW * 0.5f * 0.5f;
                if (circleRadius > itemH / 2.0f) {
                    circleRadius = itemH * 0.5f * 0.5f;
                }
                if (this.coverCirclrRadius > 0.0f) {
                    circleRadius = this.coverCirclrRadius;
                }
                startX = itemW / 2.0f + itemW * (float)i + margin * (float)i;
                startY = itemH / 2.0f;
                this.mPaintText.setColor(this.coverCirclrColor);
                canvas.drawCircle(startX, startY, circleRadius, this.mPaintText);
                continue;
            }
            if (this.inputMode == 2) {
                float picW = itemW * 0.5f;
                if (this.coverBitmapWidth > 0.0f) {
                    picW = this.coverBitmapWidth;
                }
                startX = (itemW - picW) / 2.0f + itemW * (float)i + margin * (float)i;
                startY = (itemH - picW) / 2.0f;
                Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)this.coverBitmap, (int)((int)picW), (int)((int)picW), (boolean)true);
                canvas.drawBitmap(bitmap, startX, startY, this.mPaintText);
                continue;
            }
            if (this.inputMode == 3) {
                float fontWidth = this.getFontWidth(this.mPaintText, this.coverText);
                float fontHeight = this.getFontHeight(this.mPaintText, this.coverText);
                float startX2 = (itemW - fontWidth) / 2.0f + itemW * (float)i + margin * (float)i;
                float startY2 = (itemH + fontHeight) / 2.0f - 6.0f;
                this.mPaintText.setColor(this.textColor);
                canvas.drawText(this.coverText, startX2, startY2, this.mPaintText);
                continue;
            }
            String StrPosition = String.valueOf(currentText.charAt(i));
            float fontWidth = this.getFontWidth(this.mPaintText, StrPosition);
            float fontHeight = this.getFontHeight(this.mPaintText, StrPosition);
            float startX3 = (itemW - fontWidth) / 2.0f + itemW * (float)i + margin * (float)i;
            float startY3 = (itemH + fontHeight) / 2.0f;
            this.mPaintText.setColor(this.textColor);
            canvas.drawText(StrPosition, startX3, startY3, this.mPaintText);
        }
        if (this.showCursor && this.mCursorFlag) {
            if (this.cursorHeight == 0.0f || this.cursorHeight > itemH) {
                this.cursorHeight = itemH * 50.0f / 100.0f;
            }
            Bitmap bitmap = MNPasswordEditText.drawableToBitmap((Drawable)this.cursorDrawable, (int)this.cursorWidth, (int)this.cursorHeight);
            float cursorLeft = (itemW + margin) * (float)currentIndex + itemW / 2.0f - this.cursorWidth / 2.0f;
            float cursorTop = (itemH - this.cursorHeight) / 2.0f;
            canvas.drawBitmap(bitmap, cursorLeft, cursorTop, this.mPaintCursor);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.resumeBlink();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.suspendBlink();
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            if (this.mBlink != null) {
                this.mBlink.uncancel();
            }
            this.makeBlink();
        } else if (this.mBlink != null) {
            this.mBlink.cancel();
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            if (this.mBlink != null) {
                this.mBlink.uncancel();
            }
            this.makeBlink();
        } else if (this.mBlink != null) {
            this.mBlink.cancel();
        }
    }

    private void resumeBlink() {
        if (this.mBlink != null) {
            this.mBlink.uncancel();
        }
        this.makeBlink();
    }

    private void suspendBlink() {
        if (this.mBlink != null) {
            this.mBlink.cancel();
        }
    }

    private void makeBlink() {
        if (this.mBlink == null) {
            this.mBlink = new Blink();
        }
        this.removeCallbacks(this.mBlink);
        this.postDelayed(this.mBlink, 500L);
    }

    public static Bitmap drawableToBitmap(Drawable drawable, int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, width, height);
        drawable.draw(canvas);
        return bitmap;
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        this.invalidate();
        if (this.onTextChangeListener != null) {
            if (this.getText().toString().length() == this.getMaxLength()) {
                this.onTextChangeListener.onTextChange(this.getText().toString(), true);
            } else {
                this.onTextChangeListener.onTextChange(this.getText().toString(), false);
            }
        }
    }

    public float getFontWidth(Paint paint, String str) {
        Rect rect = new Rect();
        paint.getTextBounds(str, 0, str.length(), rect);
        return rect.width();
    }

    public float getFontHeight(Paint paint, String str) {
        Rect rect = new Rect();
        paint.getTextBounds(str, 0, str.length(), rect);
        return rect.height();
    }

    public int getMaxLength() {
        int length = 0;
        try {
            InputFilter[] inputFilters;
            for (InputFilter filter : inputFilters = this.getFilters()) {
                Field[] f;
                Class<?> c = filter.getClass();
                if (!c.getName().equals("android.text.InputFilter$LengthFilter")) continue;
                for (Field field : f = c.getDeclaredFields()) {
                    if (!field.getName().equals("mMax")) continue;
                    field.setAccessible(true);
                    length = (Integer)field.get(filter);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return length;
    }

    private int dip2px(float dpValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void setOnTextChangeListener(OnTextChangeListener onTextChangeListener) {
        this.onTextChangeListener = onTextChangeListener;
    }

    public static interface OnTextChangeListener {
        public void onTextChange(String var1, boolean var2);
    }

    private class Blink
    implements Runnable {
        private boolean mCancelled = false;

        private Blink() {
        }

        @Override
        public void run() {
            MNPasswordEditText.this.mCursorFlag = !MNPasswordEditText.this.mCursorFlag;
            MNPasswordEditText.this.invalidate();
            if (this.mCancelled) {
                return;
            }
            MNPasswordEditText.this.postDelayed(this, 500L);
        }

        public void cancel() {
            if (!this.mCancelled) {
                MNPasswordEditText.this.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        public void uncancel() {
            this.mCancelled = false;
        }
    }
}

