/*
 * Decompiled with CFR 0.152.
 */
package com.github.mangstadt.vinnie.validate;

import com.github.mangstadt.vinnie.SyntaxStyle;
import com.github.mangstadt.vinnie.validate.AllowedCharacters;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class VObjectValidator {
    private static final Map<SyntaxStyle, Map<Boolean, AllowedCharacters>> propertyName = new EnumMap<SyntaxStyle, Map<Boolean, AllowedCharacters>>(SyntaxStyle.class);
    private static final Map<SyntaxStyle, Map<Boolean, AllowedCharacters>> group;
    private static final Map<SyntaxStyle, Map<Boolean, AllowedCharacters>> parameterName;
    private static final Map<SyntaxStyle, Map<Boolean, Map<Boolean, AllowedCharacters>>> parameterValue;

    public static boolean validatePropertyName(String name, SyntaxStyle syntax, boolean strict) {
        return VObjectValidator.allowedCharactersPropertyName(syntax, strict).check(name);
    }

    public static AllowedCharacters allowedCharactersPropertyName(SyntaxStyle syntax, boolean strict) {
        return propertyName.get((Object)syntax).get(strict);
    }

    public static boolean validateGroupName(String group, SyntaxStyle syntax, boolean strict) {
        return VObjectValidator.allowedCharactersGroup(syntax, strict).check(group);
    }

    public static AllowedCharacters allowedCharactersGroup(SyntaxStyle syntax, boolean strict) {
        return group.get((Object)syntax).get(strict);
    }

    public static boolean validateParameterName(String name, SyntaxStyle syntax, boolean strict) {
        return VObjectValidator.allowedCharactersParameterName(syntax, strict).check(name);
    }

    public static AllowedCharacters allowedCharactersParameterName(SyntaxStyle syntax, boolean strict) {
        return parameterName.get((Object)syntax).get(strict);
    }

    public static boolean validateParameterValue(String value, SyntaxStyle syntax, boolean caretEncoding, boolean strict) {
        return VObjectValidator.allowedCharactersParameterValue(syntax, caretEncoding, strict).check(value);
    }

    public static AllowedCharacters allowedCharactersParameterValue(SyntaxStyle syntax, boolean caretEncoding, boolean strict) {
        return parameterValue.get((Object)syntax).get(caretEncoding).get(strict);
    }

    private VObjectValidator() {
    }

    static {
        SyntaxStyle syntax = SyntaxStyle.OLD;
        HashMap<Boolean, AllowedCharacters> map = new HashMap<Boolean, AllowedCharacters>();
        boolean strict = false;
        map.put(strict, new AllowedCharacters.Builder().allowAll().except("\r\n:.;").build());
        strict = true;
        map.put(strict, new AllowedCharacters.Builder().allowPrintable().except("[]=:.,").except(';').build());
        propertyName.put(syntax, map);
        syntax = SyntaxStyle.NEW;
        map = new HashMap();
        strict = false;
        map.put(strict, propertyName.get((Object)SyntaxStyle.OLD).get(strict));
        strict = true;
        map.put(strict, new AllowedCharacters.Builder().allow(65, 90).allow(97, 122).allow(48, 57).allow('-').build());
        propertyName.put(syntax, map);
        group = propertyName;
        parameterName = new EnumMap<SyntaxStyle, Map<Boolean, AllowedCharacters>>(SyntaxStyle.class);
        syntax = SyntaxStyle.OLD;
        map = new HashMap();
        strict = false;
        map.put(strict, new AllowedCharacters.Builder().allowAll().except("\r\n:;=").build());
        strict = true;
        map.put(strict, propertyName.get((Object)syntax).get(strict));
        parameterName.put(syntax, map);
        syntax = SyntaxStyle.NEW;
        map = new HashMap();
        strict = false;
        map.put(strict, parameterName.get((Object)SyntaxStyle.OLD).get(strict));
        strict = true;
        map.put(strict, propertyName.get((Object)syntax).get(strict));
        parameterName.put(syntax, map);
        parameterValue = new EnumMap<SyntaxStyle, Map<Boolean, Map<Boolean, AllowedCharacters>>>(SyntaxStyle.class);
        SyntaxStyle syntax2 = SyntaxStyle.OLD;
        HashMap map2 = new HashMap();
        boolean caretEncoding = false;
        HashMap<Boolean, AllowedCharacters> map22 = new HashMap<Boolean, AllowedCharacters>();
        strict = false;
        map22.put(strict, new AllowedCharacters.Builder().allowAll().except("\r\n:").build());
        strict = true;
        AllowedCharacters paramName = parameterName.get((Object)syntax2).get(strict);
        map22.put(strict, new AllowedCharacters.Builder(paramName).allow(';').build());
        map2.put(caretEncoding, map22);
        caretEncoding = true;
        map2.put(caretEncoding, map2.get(false));
        parameterValue.put(syntax2, map2);
        syntax2 = SyntaxStyle.NEW;
        map2 = new HashMap();
        caretEncoding = false;
        map22 = new HashMap();
        strict = false;
        map22.put(strict, new AllowedCharacters.Builder().allowAll().except("\r\n\"").build());
        strict = true;
        map22.put(strict, new AllowedCharacters.Builder().allowPrintable().allowNonAscii().allow('\t').except('\"').build());
        map2.put(caretEncoding, map22);
        caretEncoding = true;
        map22 = new HashMap();
        strict = false;
        map22.put(strict, new AllowedCharacters.Builder().allowAll().build());
        strict = true;
        map22.put(strict, new AllowedCharacters.Builder().allowPrintable().allowNonAscii().allow("\r\n\t").build());
        map2.put(caretEncoding, map22);
        parameterValue.put(syntax2, map2);
    }
}

