/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ListMultimap<K, V>
implements Iterable<Map.Entry<K, List<V>>> {
    private final Map<K, List<V>> map;

    public ListMultimap() {
        this(new LinkedHashMap());
    }

    public ListMultimap(int initialCapacity) {
        this(new LinkedHashMap(initialCapacity));
    }

    public ListMultimap(ListMultimap<K, V> orig) {
        this(ListMultimap.copy(orig.map));
    }

    private static <K, V> Map<K, List<V>> copy(Map<K, List<V>> orig) {
        LinkedHashMap map = new LinkedHashMap(orig.size());
        for (Map.Entry<K, List<V>> entry : orig.entrySet()) {
            ArrayList values = new ArrayList(entry.getValue());
            map.put(entry.getKey(), values);
        }
        return map;
    }

    public ListMultimap(Map<K, List<V>> map) {
        this.map = map;
    }

    public void put(K key, V value) {
        List<V> list = this.map.get(key = this.sanitizeKey(key));
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        list.add(value);
    }

    public void putAll(K key, Collection<? extends V> values) {
        if (values.isEmpty()) {
            return;
        }
        List<V> list = this.map.get(key = this.sanitizeKey(key));
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        list.addAll(values);
    }

    public List<V> get(K key) {
        List<V> value = this.map.get(key = this.sanitizeKey(key));
        if (value == null) {
            value = new ArrayList<V>(0);
        }
        return new WrappedList(key, value, null);
    }

    public V first(K key) {
        List<V> values = this.map.get(key = this.sanitizeKey(key));
        return values == null ? null : (V)values.get(0);
    }

    public boolean containsKey(K key) {
        key = this.sanitizeKey(key);
        return this.map.containsKey(key);
    }

    public boolean remove(K key, V value) {
        List<V> values = this.map.get(key = this.sanitizeKey(key));
        if (values == null) {
            return false;
        }
        boolean success = values.remove(value);
        if (values.isEmpty()) {
            this.map.remove(key);
        }
        return success;
    }

    public List<V> removeAll(K key) {
        List<V> removed = this.map.remove(key = this.sanitizeKey(key));
        if (removed == null) {
            return Collections.emptyList();
        }
        List<V> unmodifiableCopy = Collections.unmodifiableList(new ArrayList<V>(removed));
        removed.clear();
        return unmodifiableCopy;
    }

    public List<V> replace(K key, V value) {
        List<V> replaced = this.removeAll(key);
        if (value != null) {
            this.put(key, value);
        }
        return replaced;
    }

    public List<V> replace(K key, Collection<? extends V> values) {
        List<V> replaced = this.removeAll(key);
        this.putAll(key, values);
        return replaced;
    }

    public void clear() {
        for (List<V> value : this.map.values()) {
            value.clear();
        }
        this.map.clear();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public List<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        for (List<V> value : this.map.values()) {
            list.addAll(value);
        }
        return Collections.unmodifiableList(list);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        for (List<V> value : this.map.values()) {
            size += value.size();
        }
        return size;
    }

    public Map<K, List<V>> asMap() {
        LinkedHashMap<K, List<V>> view = new LinkedHashMap<K, List<V>>(this.map.size());
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K key = entry.getKey();
            List<V> value = entry.getValue();
            view.put(key, Collections.unmodifiableList(value));
        }
        return Collections.unmodifiableMap(view);
    }

    public Map<K, List<V>> getMap() {
        return this.map;
    }

    protected K sanitizeKey(K key) {
        return key;
    }

    @Override
    public Iterator<Map.Entry<K, List<V>>> iterator() {
        final Iterator<Map.Entry<K, List<V>>> it = this.map.entrySet().iterator();
        return new Iterator<Map.Entry<K, List<V>>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Map.Entry<K, List<V>> next() {
                final Map.Entry next = (Map.Entry)it.next();
                return new Map.Entry<K, List<V>>(){

                    @Override
                    public K getKey() {
                        return next.getKey();
                    }

                    @Override
                    public List<V> getValue() {
                        return Collections.unmodifiableList((List)next.getValue());
                    }

                    @Override
                    public List<V> setValue(List<V> value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListMultimap other = (ListMultimap)obj;
        return this.map.equals(other.map);
    }

    private class WrappedList
    extends AbstractCollection<V>
    implements List<V> {
        final K key;
        List<V> delegate;
        final WrappedList ancestor;
        final List<V> ancestorDelegate;

        WrappedList(K key, List<V> delegate, WrappedList ancestor) {
            this.key = key;
            this.delegate = delegate;
            this.ancestor = ancestor;
            this.ancestorDelegate = ancestor == null ? null : ancestor.getDelegate();
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.getDelegate().addAll(index, collection);
            if (changed && oldSize == 0) {
                this.addToMap();
            }
            return changed;
        }

        @Override
        public V get(int index) {
            this.refreshIfEmpty();
            return this.getDelegate().get(index);
        }

        @Override
        public V set(int index, V element) {
            this.refreshIfEmpty();
            return this.getDelegate().set(index, element);
        }

        @Override
        public void add(int index, V element) {
            this.refreshIfEmpty();
            boolean wasEmpty = this.getDelegate().isEmpty();
            this.getDelegate().add(index, element);
            if (wasEmpty) {
                this.addToMap();
            }
        }

        @Override
        public V remove(int index) {
            this.refreshIfEmpty();
            Object value = this.getDelegate().remove(index);
            this.removeIfEmpty();
            return value;
        }

        @Override
        public int indexOf(Object o) {
            this.refreshIfEmpty();
            return this.getDelegate().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            this.refreshIfEmpty();
            return this.getDelegate().lastIndexOf(o);
        }

        @Override
        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator();
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            this.refreshIfEmpty();
            return new WrappedListIterator(index);
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            this.refreshIfEmpty();
            return new WrappedList(this.getKey(), this.getDelegate().subList(fromIndex, toIndex), this.getAncestor() == null ? this : this.getAncestor());
        }

        void refreshIfEmpty() {
            List newDelegate;
            if (this.ancestor != null) {
                this.ancestor.refreshIfEmpty();
                if (this.ancestor.getDelegate() != this.ancestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (newDelegate = (List)ListMultimap.this.map.get(this.key)) != null) {
                this.delegate = newDelegate;
            }
        }

        void removeIfEmpty() {
            if (this.ancestor != null) {
                this.ancestor.removeIfEmpty();
            } else if (this.delegate.isEmpty()) {
                ListMultimap.this.map.remove(this.key);
            }
        }

        K getKey() {
            return this.key;
        }

        void addToMap() {
            if (this.ancestor != null) {
                this.ancestor.addToMap();
            } else {
                ListMultimap.this.map.put(this.key, this.delegate);
            }
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            this.refreshIfEmpty();
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        List<V> getDelegate() {
            return this.delegate;
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator();
        }

        @Override
        public boolean add(V value) {
            this.refreshIfEmpty();
            boolean wasEmpty = this.delegate.isEmpty();
            boolean changed = this.delegate.add(value);
            if (changed && wasEmpty) {
                this.addToMap();
            }
            return changed;
        }

        WrappedList getAncestor() {
            return this.ancestor;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.addAll(collection);
            if (changed && oldSize == 0) {
                this.addToMap();
            }
            return changed;
        }

        @Override
        public boolean contains(Object o) {
            this.refreshIfEmpty();
            return this.delegate.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            this.refreshIfEmpty();
            return this.delegate.containsAll(c);
        }

        @Override
        public void clear() {
            int oldSize = this.size();
            if (oldSize == 0) {
                return;
            }
            this.delegate.clear();
            this.removeIfEmpty();
        }

        @Override
        public boolean remove(Object o) {
            this.refreshIfEmpty();
            boolean changed = this.delegate.remove(o);
            if (changed) {
                this.removeIfEmpty();
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            this.refreshIfEmpty();
            boolean changed = this.delegate.removeAll(collection);
            if (changed) {
                this.removeIfEmpty();
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.refreshIfEmpty();
            boolean changed = this.delegate.retainAll(c);
            if (changed) {
                this.removeIfEmpty();
            }
            return changed;
        }

        private class WrappedListIterator
        implements ListIterator<V> {
            final ListIterator<V> delegateIterator;
            final List<V> originalDelegate;

            WrappedListIterator() {
                this.originalDelegate = WrappedList.this.delegate;
                this.delegateIterator = WrappedList.this.delegate.listIterator();
            }

            public WrappedListIterator(int index) {
                this.originalDelegate = WrappedList.this.delegate;
                this.delegateIterator = WrappedList.this.delegate.listIterator(index);
            }

            @Override
            public boolean hasPrevious() {
                return this.getDelegateIterator().hasPrevious();
            }

            @Override
            public V previous() {
                return this.getDelegateIterator().previous();
            }

            @Override
            public int nextIndex() {
                return this.getDelegateIterator().nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.getDelegateIterator().previousIndex();
            }

            @Override
            public void set(V value) {
                this.getDelegateIterator().set(value);
            }

            @Override
            public void add(V value) {
                boolean wasEmpty = WrappedList.this.isEmpty();
                this.getDelegateIterator().add(value);
                if (wasEmpty) {
                    WrappedList.this.addToMap();
                }
            }

            void validateIterator() {
                WrappedList.this.refreshIfEmpty();
                if (WrappedList.this.delegate != this.originalDelegate) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                WrappedList.this.removeIfEmpty();
            }

            ListIterator<V> getDelegateIterator() {
                this.validateIterator();
                return this.delegateIterator;
            }
        }
    }
}

