/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ValuedProperty;
import biweekly.util.XmlUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Xml
extends ValuedProperty<Document> {
    public Xml(String xml) throws SAXException {
        this(xml == null ? null : XmlUtils.toDocument(xml));
    }

    public Xml(Element element) {
        this(element == null ? null : XmlUtils.createDocument());
        if (element != null) {
            Node imported = ((Document)this.value).importNode(element, true);
            ((Document)this.value).appendChild(imported);
        }
    }

    public Xml(Document document) {
        super(document);
    }

    public Xml(Xml original) {
        super(original);
        if (original.value != null) {
            this.value = XmlUtils.createDocument();
            Element root = ((Document)original.value).getDocumentElement();
            if (root != null) {
                Node node = ((Document)this.value).importNode(root, true);
                ((Document)this.value).appendChild(node);
            }
        }
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        if (this.value == null) {
            warnings.add(new ValidationWarning(26, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("value", this.value == null ? "null" : XmlUtils.toString((Node)this.value));
        return values;
    }

    @Override
    public Xml copy() {
        return new Xml(this);
    }

    @Override
    protected int valueHashCode() {
        return XmlUtils.toString((Node)this.value).hashCode();
    }

    @Override
    protected boolean valueEquals(Document otherValue) {
        if (otherValue == null) {
            return false;
        }
        return XmlUtils.toString((Node)this.value).equals(XmlUtils.toString(otherValue));
    }
}

