/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import com.mancj.slideup.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SlideUp<T extends View>
implements View.OnTouchListener,
ValueAnimator.AnimatorUpdateListener,
Animator.AnimatorListener {
    private static final String TAG = "SlideUp";
    private static final String KEY_START_GRAVITY = "SlideUp_start_gravity";
    private static final String KEY_DEBUG = "SlideUp_debug";
    private static final String KEY_TOUCHABLE_AREA = "SlideUp_touchable_area";
    private static final String KEY_STATE = "SlideUp_state";
    private static final String KEY_AUTO_SLIDE_DURATION = "SlideUp_auto_slide_duration";
    private State startState;
    private State currentState;
    private T sliderView;
    private float touchableArea;
    private int autoSlideDuration;
    private List<Listener> listeners;
    private ValueAnimator valueAnimator;
    private float slideAnimationTo;
    private float startPositionY;
    private float startPositionX;
    private float viewStartPositionY;
    private float viewStartPositionX;
    private boolean canSlide = true;
    private float density;
    private float maxSlidePosition;
    private float viewHeight;
    private float viewWidth;
    private boolean gesturesEnabled;
    private boolean isRTL;
    private int startGravity;
    private boolean debug = false;

    private SlideUp(Builder<T> builder) {
        this.startGravity = ((Builder)builder).startGravity;
        this.listeners = ((Builder)builder).listeners;
        this.sliderView = ((Builder)builder).sliderView;
        this.startState = ((Builder)builder).startState;
        this.density = ((Builder)builder).density;
        this.touchableArea = ((Builder)builder).touchableArea;
        this.autoSlideDuration = ((Builder)builder).autoSlideDuration;
        this.debug = ((Builder)builder).debug;
        this.isRTL = ((Builder)builder).isRTL;
        this.gesturesEnabled = ((Builder)builder).gesturesEnabled;
        this.init();
    }

    private void init() {
        this.sliderView.setOnTouchListener((View.OnTouchListener)this);
        this.createAnimation();
        this.sliderView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                SlideUp.this.viewHeight = SlideUp.this.sliderView.getHeight();
                SlideUp.this.viewWidth = SlideUp.this.sliderView.getWidth();
                switch (SlideUp.this.startGravity) {
                    case 48: {
                        SlideUp.this.sliderView.setPivotY(SlideUp.this.viewHeight);
                        break;
                    }
                    case 80: {
                        SlideUp.this.sliderView.setPivotY(0.0f);
                        break;
                    }
                    case 0x800003: {
                        SlideUp.this.sliderView.setPivotX(0.0f);
                        break;
                    }
                    case 0x800005: {
                        SlideUp.this.sliderView.setPivotX(SlideUp.this.viewWidth);
                    }
                }
                SlideUp.this.updateToCurrentState();
                ViewTreeObserver observer = SlideUp.this.sliderView.getViewTreeObserver();
                if (Build.VERSION.SDK_INT <= 16) {
                    observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        this.updateToCurrentState();
    }

    private void updateToCurrentState() {
        switch (this.startState) {
            case HIDDEN: {
                this.hideImmediately();
                break;
            }
            case SHOWED: {
                this.showImmediately();
            }
        }
    }

    public boolean isVisible() {
        return this.sliderView.getVisibility() == 0;
    }

    public void addSlideListener(@NonNull Listener listener) {
        this.listeners.add(listener);
    }

    public void removeSlideListener(@NonNull Listener listener) {
        this.listeners.remove(listener);
    }

    public T getSliderView() {
        return this.sliderView;
    }

    public void setAutoSlideDuration(int autoSlideDuration) {
        this.autoSlideDuration = autoSlideDuration;
    }

    public float getAutoSlideDuration() {
        return this.autoSlideDuration;
    }

    public void setTouchableArea(float touchableArea) {
        this.touchableArea = touchableArea * this.density;
    }

    public float getTouchableArea() {
        return this.touchableArea / this.density;
    }

    public boolean isAnimationRunning() {
        return this.valueAnimator != null && this.valueAnimator.isRunning();
    }

    public void show() {
        this.show(false);
    }

    public void hide() {
        this.hide(false);
    }

    public void hideImmediately() {
        this.hide(true);
    }

    public void showImmediately() {
        this.show(true);
    }

    public void setLoggingEnabled(boolean enabled) {
        this.debug = enabled;
    }

    public boolean isLoggingEnabled() {
        return this.debug;
    }

    public void setGesturesEnabled(boolean enabled) {
        this.gesturesEnabled = this.gesturesEnabled;
    }

    public boolean isGesturesEnabled() {
        return this.gesturesEnabled;
    }

    public Bundle onSaveInstanceState(@Nullable Bundle savedState) {
        if (savedState == null) {
            savedState = Bundle.EMPTY;
        }
        savedState.putInt(KEY_START_GRAVITY, this.startGravity);
        savedState.putBoolean(KEY_DEBUG, this.debug);
        savedState.putFloat(KEY_TOUCHABLE_AREA, this.touchableArea / this.density);
        savedState.putParcelable(KEY_STATE, (Parcelable)this.currentState);
        savedState.putInt(KEY_AUTO_SLIDE_DURATION, this.autoSlideDuration);
        return savedState;
    }

    private void hide(boolean immediately) {
        switch (this.startGravity) {
            case 48: {
                if (immediately) {
                    if (this.sliderView.getHeight() > 0) {
                        this.sliderView.setTranslationY(this.viewHeight);
                        this.sliderView.setVisibility(8);
                        this.notifyVisibilityChanged(8);
                        break;
                    }
                    this.startState = State.HIDDEN;
                    break;
                }
                this.slideAnimationTo = this.sliderView.getHeight();
                this.valueAnimator.setFloatValues(new float[]{this.sliderView.getTranslationY(), this.slideAnimationTo});
                this.valueAnimator.start();
                break;
            }
            case 80: {
                if (immediately) {
                    if (this.sliderView.getHeight() > 0) {
                        this.sliderView.setTranslationY(-this.viewHeight);
                        this.sliderView.setVisibility(8);
                        this.notifyVisibilityChanged(8);
                        break;
                    }
                    this.startState = State.HIDDEN;
                    break;
                }
                this.slideAnimationTo = -this.sliderView.getHeight();
                this.valueAnimator.setFloatValues(new float[]{this.sliderView.getTranslationY(), this.slideAnimationTo});
                this.valueAnimator.start();
                break;
            }
            case 0x800003: {
                if (immediately) {
                    if (this.sliderView.getWidth() > 0) {
                        this.sliderView.setTranslationX(this.viewWidth);
                        this.sliderView.setVisibility(8);
                        this.notifyVisibilityChanged(8);
                        break;
                    }
                    this.startState = State.HIDDEN;
                    break;
                }
                this.slideAnimationTo = this.sliderView.getWidth();
                this.valueAnimator.setFloatValues(new float[]{this.sliderView.getTranslationX(), this.slideAnimationTo});
                this.valueAnimator.start();
                break;
            }
            case 0x800005: {
                if (immediately) {
                    if (this.sliderView.getWidth() > 0) {
                        this.sliderView.setTranslationX(-this.viewWidth);
                        this.sliderView.setVisibility(8);
                        this.notifyVisibilityChanged(8);
                        break;
                    }
                    this.startState = State.HIDDEN;
                    break;
                }
                this.slideAnimationTo = -this.sliderView.getHeight();
                this.valueAnimator.setFloatValues(new float[]{this.sliderView.getTranslationX(), this.slideAnimationTo});
                this.valueAnimator.start();
            }
        }
    }

    private void show(boolean immediately) {
        switch (this.startGravity) {
            case 48: 
            case 80: {
                if (immediately) {
                    if (this.sliderView.getHeight() > 0) {
                        this.sliderView.setTranslationY(0.0f);
                        this.sliderView.setVisibility(0);
                        this.notifyVisibilityChanged(0);
                        break;
                    }
                    this.startState = State.SHOWED;
                    break;
                }
                this.slideAnimationTo = 0.0f;
                this.valueAnimator.setFloatValues(new float[]{this.viewHeight, this.slideAnimationTo});
                this.valueAnimator.start();
                break;
            }
            case 0x800003: 
            case 0x800005: {
                if (immediately) {
                    if (this.sliderView.getWidth() > 0) {
                        this.sliderView.setTranslationX(0.0f);
                        this.sliderView.setVisibility(0);
                        this.notifyVisibilityChanged(0);
                        break;
                    }
                    this.startState = State.SHOWED;
                    break;
                }
                this.slideAnimationTo = 0.0f;
                this.valueAnimator.setFloatValues(new float[]{this.viewWidth, this.slideAnimationTo});
                this.valueAnimator.start();
            }
        }
    }

    private void createAnimation() {
        this.valueAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        this.valueAnimator.setDuration((long)this.autoSlideDuration);
        this.valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.valueAnimator.addListener((Animator.AnimatorListener)this);
    }

    public final boolean onTouch(View v, MotionEvent event) {
        if (!this.gesturesEnabled) {
            return false;
        }
        if (this.isAnimationRunning()) {
            return false;
        }
        switch (this.startGravity) {
            case 48: {
                return this.onTouchUpToDown(event);
            }
            case 80: {
                return this.onTouchDownToUp(event);
            }
            case 0x800003: {
                return this.onTouchStartToEnd(event);
            }
            case 0x800005: {
                return this.onTouchEndToStart(event);
            }
        }
        this.e("onTouchListener", "(onTouch)", "You are using not supportable gravity");
        return false;
    }

    private boolean onTouchEndToStart(MotionEvent event) {
        float touchedArea = event.getRawX() - (float)this.getEnd();
        switch (event.getActionMasked()) {
            case 0: {
                this.viewWidth = this.sliderView.getWidth();
                this.startPositionX = event.getRawX();
                this.viewStartPositionX = this.sliderView.getTranslationX();
                if (!(this.touchableArea < touchedArea)) break;
                this.canSlide = false;
                break;
            }
            case 2: {
                float difference = event.getRawX() - this.startPositionX;
                float moveTo = this.viewStartPositionX + difference;
                float percents = moveTo * 100.0f / (float)this.sliderView.getWidth();
                if (moveTo > 0.0f && this.canSlide) {
                    this.notifyPercentChanged(percents);
                    this.sliderView.setTranslationX(moveTo);
                }
                if (!(event.getRawX() > this.maxSlidePosition)) break;
                this.maxSlidePosition = event.getRawX();
                break;
            }
            case 1: {
                float slideAnimationFrom = this.sliderView.getTranslationX();
                boolean mustShow = this.maxSlidePosition > event.getRawX();
                boolean scrollableAreaConsumed = this.sliderView.getTranslationX() > (float)(this.sliderView.getWidth() / 5);
                this.slideAnimationTo = scrollableAreaConsumed && !mustShow ? (float)this.sliderView.getWidth() : 0.0f;
                this.valueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.slideAnimationTo});
                this.valueAnimator.start();
                this.canSlide = true;
                this.maxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    private boolean onTouchStartToEnd(MotionEvent event) {
        float touchedArea = (float)this.getEnd() - event.getRawX();
        switch (event.getActionMasked()) {
            case 0: {
                this.maxSlidePosition = this.viewWidth;
                this.viewWidth = this.sliderView.getWidth();
                this.startPositionX = event.getRawX();
                this.viewStartPositionX = this.sliderView.getTranslationX();
                if (!(this.touchableArea < touchedArea)) break;
                this.canSlide = false;
                break;
            }
            case 2: {
                float difference = event.getRawX() - this.startPositionX;
                float moveTo = this.viewStartPositionX + difference;
                float percents = moveTo * 100.0f / (float)(-this.sliderView.getWidth());
                if (moveTo < 0.0f && this.canSlide) {
                    this.notifyPercentChanged(percents);
                    this.sliderView.setTranslationX(moveTo);
                }
                if (!(event.getRawX() < this.maxSlidePosition)) break;
                this.maxSlidePosition = event.getRawX();
                break;
            }
            case 1: {
                float slideAnimationFrom = -this.sliderView.getTranslationX();
                boolean mustShow = this.maxSlidePosition < event.getRawX();
                boolean scrollableAreaConsumed = this.sliderView.getTranslationX() < (float)(-this.sliderView.getHeight() / 5);
                this.slideAnimationTo = scrollableAreaConsumed && !mustShow ? (float)this.sliderView.getWidth() : 0.0f;
                this.valueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.slideAnimationTo});
                this.valueAnimator.start();
                this.canSlide = true;
                this.maxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    private boolean onTouchDownToUp(MotionEvent event) {
        float touchedArea = event.getRawY() - (float)this.sliderView.getTop();
        switch (event.getActionMasked()) {
            case 0: {
                this.viewHeight = this.sliderView.getHeight();
                this.startPositionY = event.getRawY();
                this.viewStartPositionY = this.sliderView.getTranslationY();
                if (!(this.touchableArea < touchedArea)) break;
                this.canSlide = false;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.startPositionY;
                float moveTo = this.viewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)this.sliderView.getHeight();
                if (moveTo > 0.0f && this.canSlide) {
                    this.notifyPercentChanged(percents);
                    this.sliderView.setTranslationY(moveTo);
                }
                if (!(event.getRawY() > this.maxSlidePosition)) break;
                this.maxSlidePosition = event.getRawY();
                break;
            }
            case 1: {
                float slideAnimationFrom = this.sliderView.getTranslationY();
                boolean mustShow = this.maxSlidePosition > event.getRawY();
                boolean scrollableAreaConsumed = this.sliderView.getTranslationY() > (float)(this.sliderView.getHeight() / 5);
                this.slideAnimationTo = scrollableAreaConsumed && !mustShow ? (float)this.sliderView.getHeight() : 0.0f;
                this.valueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.slideAnimationTo});
                this.valueAnimator.start();
                this.canSlide = true;
                this.maxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    private boolean onTouchUpToDown(MotionEvent event) {
        float touchedArea = event.getRawY() - (float)this.sliderView.getBottom();
        switch (event.getActionMasked()) {
            case 0: {
                this.viewHeight = this.sliderView.getHeight();
                this.startPositionY = event.getRawY();
                this.viewStartPositionY = this.sliderView.getTranslationY();
                this.maxSlidePosition = this.viewHeight;
                if (!(this.touchableArea < touchedArea)) break;
                this.canSlide = false;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.startPositionY;
                float moveTo = this.viewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)(-this.sliderView.getHeight());
                if (moveTo < 0.0f && this.canSlide) {
                    this.notifyPercentChanged(percents);
                    this.sliderView.setTranslationY(moveTo);
                }
                if (!(event.getRawY() < this.maxSlidePosition)) break;
                this.maxSlidePosition = event.getRawY();
                break;
            }
            case 1: {
                float slideAnimationFrom = -this.sliderView.getTranslationY();
                boolean mustShow = this.maxSlidePosition < event.getRawY();
                boolean scrollableAreaConsumed = this.sliderView.getTranslationY() < (float)(-this.sliderView.getHeight() / 5);
                this.slideAnimationTo = scrollableAreaConsumed && !mustShow ? (float)(this.sliderView.getHeight() + this.sliderView.getTop()) : 0.0f;
                this.valueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.slideAnimationTo});
                this.valueAnimator.start();
                this.canSlide = true;
                this.maxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    public final void onAnimationUpdate(ValueAnimator animation) {
        float value = ((Float)animation.getAnimatedValue()).floatValue();
        switch (this.startGravity) {
            case 48: {
                this.onAnimationUpdateUpToDown(value);
                break;
            }
            case 80: {
                this.onAnimationUpdateDownToUp(value);
                break;
            }
            case 0x800003: {
                this.onAnimationUpdateStartToEnd(value);
                break;
            }
            case 0x800005: {
                this.onAnimationUpdateEndToStart(value);
            }
        }
    }

    private void onAnimationUpdateUpToDown(float value) {
        this.sliderView.setTranslationY(-value);
        float visibleDistance = (float)this.sliderView.getTop() - this.sliderView.getY();
        float percents = visibleDistance * 100.0f / this.viewHeight;
        this.notifyPercentChanged(percents);
    }

    private void onAnimationUpdateDownToUp(float value) {
        this.sliderView.setTranslationY(value);
        float visibleDistance = this.sliderView.getY() - (float)this.sliderView.getTop();
        float percents = visibleDistance * 100.0f / this.viewHeight;
        this.notifyPercentChanged(percents);
    }

    private void onAnimationUpdateStartToEnd(float value) {
        this.sliderView.setTranslationX(-value);
        float visibleDistance = this.sliderView.getX() - (float)this.getStart();
        float percents = visibleDistance * 100.0f / -this.viewWidth;
        this.notifyPercentChanged(percents);
    }

    private void onAnimationUpdateEndToStart(float value) {
        this.sliderView.setTranslationX(value);
        float visibleDistance = this.sliderView.getX() - (float)this.getStart();
        float percents = visibleDistance * 100.0f / this.viewWidth;
        this.notifyPercentChanged(percents);
    }

    private int getStart() {
        if (this.isRTL) {
            return this.sliderView.getRight();
        }
        return this.sliderView.getLeft();
    }

    private int getEnd() {
        if (this.isRTL) {
            return this.sliderView.getLeft();
        }
        return this.sliderView.getRight();
    }

    private void notifyPercentChanged(float percent) {
        percent = percent > 100.0f ? 100.0f : percent;
        float f = percent = percent < 0.0f ? 0.0f : percent;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener l = this.listeners.get(i);
                if (l != null) {
                    l.onSlide(percent);
                    this.d("Listener(" + i + ")", "(onSlide)", "value = " + percent);
                    continue;
                }
                this.e("Listener(" + i + ")", "(onSlide)", "Listener is null, skip notify for him...");
            }
        }
    }

    private void notifyVisibilityChanged(int visibility) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener l = this.listeners.get(i);
                if (l != null) {
                    l.onVisibilityChanged(visibility);
                    this.d("Listener(" + i + ")", "(onVisibilityChanged)", "value = " + (visibility == 0 ? "VISIBLE" : (visibility == 8 ? "GONE" : Integer.valueOf(visibility))));
                    continue;
                }
                this.e("Listener(" + i + ")", "(onVisibilityChanged)", "Listener is null, skip  notify for him...");
            }
        }
        switch (visibility) {
            case 0: {
                this.currentState = State.SHOWED;
                break;
            }
            case 8: {
                this.currentState = State.HIDDEN;
            }
        }
    }

    public final void onAnimationStart(Animator animator) {
        this.sliderView.setVisibility(0);
        this.notifyVisibilityChanged(0);
    }

    public final void onAnimationEnd(Animator animator) {
        if (this.slideAnimationTo != 0.0f) {
            this.sliderView.setVisibility(8);
            this.notifyVisibilityChanged(8);
        }
    }

    public final void onAnimationCancel(Animator animator) {
    }

    public final void onAnimationRepeat(Animator animator) {
    }

    private void e(String listener, String method, String message) {
        if (this.debug) {
            Log.e((String)TAG, (String)String.format("%1$-15s %2$-23s %3$s", listener, method, message));
        }
    }

    private void d(String listener, String method, String value) {
        if (this.debug) {
            Log.d((String)TAG, (String)String.format("%1$-15s %2$-23s %3$s", listener, method, value));
        }
    }

    public static final class Builder<T extends View> {
        private T sliderView;
        private State startState = State.HIDDEN;
        private List<Listener> listeners = new ArrayList<Listener>();
        private boolean debug = false;
        private float touchableArea;
        private int autoSlideDuration = 300;
        private float density;
        private int startGravity = 80;
        private boolean isRTL;
        private boolean gesturesEnabled = true;

        public Builder(@NonNull T sliderView) {
            this.sliderView = sliderView;
            this.density = sliderView.getResources().getDisplayMetrics().density;
            this.isRTL = sliderView.getResources().getBoolean(R.bool.is_right_to_left);
            this.touchableArea = 300.0f * this.density;
        }

        public Builder withStartState(@NonNull State startState) {
            this.startState = startState;
            return this;
        }

        public Builder withStartGravity(int gravity) {
            this.startGravity = gravity;
            return this;
        }

        public Builder withListeners(@NonNull List<Listener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder withListeners(Listener ... listeners) {
            ArrayList<Listener> listeners_list = new ArrayList<Listener>();
            Collections.addAll(listeners_list, listeners);
            return this.withListeners(listeners_list);
        }

        public Builder withLoggingEnabled(boolean enabled) {
            this.debug = enabled;
            return this;
        }

        public Builder withAutoSlideDuration(int duration) {
            this.autoSlideDuration = duration;
            return this;
        }

        public Builder withTouchableArea(float area) {
            this.touchableArea = area * this.density;
            return this;
        }

        public Builder withGesturesEnabled(boolean enabled) {
            this.gesturesEnabled = enabled;
            return this;
        }

        public Builder withSavedState(@Nullable Bundle savedState) {
            this.restoreParams(savedState);
            return this;
        }

        public SlideUp<T> build() {
            return new SlideUp(this);
        }

        private void restoreParams(@Nullable Bundle savedState) {
            if (savedState == null) {
                return;
            }
            if (savedState.getParcelable(SlideUp.KEY_STATE) != null) {
                this.startState = (State)savedState.getParcelable(SlideUp.KEY_STATE);
            }
            this.startGravity = savedState.getInt(SlideUp.KEY_START_GRAVITY, this.startGravity);
            this.debug = savedState.getBoolean(SlideUp.KEY_DEBUG, this.debug);
            this.touchableArea = savedState.getFloat(SlideUp.KEY_TOUCHABLE_AREA, this.touchableArea) * this.density;
            this.autoSlideDuration = savedState.getInt(SlideUp.KEY_AUTO_SLIDE_DURATION, this.autoSlideDuration);
        }
    }

    public static class ListenerAdapter
    implements Listener {
        @Override
        public void onSlide(float percent) {
        }

        @Override
        public void onVisibilityChanged(int visibility) {
        }
    }

    public static interface Listener {
        public void onSlide(float var1);

        public void onVisibilityChanged(int var1);
    }

    public static enum State implements Parcelable
    {
        HIDDEN,
        SHOWED;

        public static final Parcelable.Creator<State> CREATOR;

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        public int describeContents() {
            return 0;
        }

        static {
            CREATOR = new Parcelable.Creator<State>(){

                public State createFromParcel(Parcel in) {
                    return State.values()[in.readInt()];
                }

                public State[] newArray(int size) {
                    return new State[size];
                }
            };
        }
    }
}

