/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.view.MotionEvent;
import android.view.View;
import com.mancj.slideup.AnimationProcessor;
import com.mancj.slideup.Internal;
import com.mancj.slideup.LoggerNotifier;
import com.mancj.slideup.SlideUpBuilder;
import com.mancj.slideup.TouchConsumer;

class VerticalTouchConsumer
extends TouchConsumer {
    private boolean mGoingUp = false;
    private boolean mGoingDown = false;

    VerticalTouchConsumer(SlideUpBuilder builder, LoggerNotifier notifier, AnimationProcessor animationProcessor) {
        super(builder, notifier, animationProcessor);
    }

    boolean consumeBottomToTop(View touchedView, MotionEvent event) {
        float touchedArea = event.getY();
        switch (event.getActionMasked()) {
            case 0: {
                this.mViewHeight = this.mBuilder.mSliderView.getHeight();
                this.mStartPositionY = event.getRawY();
                this.mViewStartPositionY = this.mBuilder.mSliderView.getTranslationY();
                this.mCanSlide = this.touchFromAlsoSlide(touchedView, event);
                this.mCanSlide |= this.mBuilder.mTouchableArea >= touchedArea;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.mStartPositionY;
                float moveTo = this.mViewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)this.mBuilder.mSliderView.getHeight();
                this.calculateDirection(event);
                if (!(moveTo > 0.0f) || !this.mCanSlide) break;
                this.mNotifier.notifyPercentChanged(percents);
                this.mBuilder.mSliderView.setTranslationY(moveTo);
                break;
            }
            case 1: {
                boolean scrollableAreaConsumed;
                float slideAnimationFrom = this.mBuilder.mSliderView.getTranslationY();
                if (slideAnimationFrom == this.mViewStartPositionY) {
                    return !Internal.isUpEventInView(this.mBuilder.mSliderView, event);
                }
                boolean bl = scrollableAreaConsumed = this.mBuilder.mSliderView.getTranslationY() > (float)(this.mBuilder.mSliderView.getHeight() / 5);
                if (scrollableAreaConsumed && this.mGoingDown) {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, this.mBuilder.mSliderView.getHeight());
                } else {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, 0.0f);
                }
                this.mCanSlide = true;
                this.mGoingUp = false;
                this.mGoingDown = false;
            }
        }
        this.mPrevPositionY = event.getRawY();
        this.mPrevPositionX = event.getRawX();
        return true;
    }

    boolean consumeTopToBottom(View touchedView, MotionEvent event) {
        float touchedArea = event.getY();
        switch (event.getActionMasked()) {
            case 0: {
                this.mViewHeight = this.mBuilder.mSliderView.getHeight();
                this.mStartPositionY = event.getRawY();
                this.mViewStartPositionY = this.mBuilder.mSliderView.getTranslationY();
                this.mCanSlide = this.touchFromAlsoSlide(touchedView, event);
                this.mCanSlide |= (float)this.getBottom() - this.mBuilder.mTouchableArea <= touchedArea;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.mStartPositionY;
                float moveTo = this.mViewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)(-this.mBuilder.mSliderView.getHeight());
                this.calculateDirection(event);
                if (!(moveTo < 0.0f) || !this.mCanSlide) break;
                this.mNotifier.notifyPercentChanged(percents);
                this.mBuilder.mSliderView.setTranslationY(moveTo);
                break;
            }
            case 1: {
                boolean scrollableAreaConsumed;
                float slideAnimationFrom = -this.mBuilder.mSliderView.getTranslationY();
                if (slideAnimationFrom == this.mViewStartPositionY) {
                    return !Internal.isUpEventInView(this.mBuilder.mSliderView, event);
                }
                boolean bl = scrollableAreaConsumed = this.mBuilder.mSliderView.getTranslationY() < (float)(-this.mBuilder.mSliderView.getHeight() / 5);
                if (scrollableAreaConsumed && this.mGoingUp) {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, this.mBuilder.mSliderView.getHeight() + this.mBuilder.mSliderView.getTop());
                } else {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, 0.0f);
                }
                this.mCanSlide = true;
            }
        }
        this.mPrevPositionY = event.getRawY();
        this.mPrevPositionX = event.getRawX();
        return true;
    }

    private void calculateDirection(MotionEvent event) {
        this.mGoingUp = this.mPrevPositionY - event.getRawY() > 0.0f;
        this.mGoingDown = this.mPrevPositionY - event.getRawY() < 0.0f;
    }
}

