/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.view.MotionEvent;
import android.view.View;
import com.mancj.slideup.AnimationProcessor;
import com.mancj.slideup.Internal;
import com.mancj.slideup.LoggerNotifier;
import com.mancj.slideup.SlideUpBuilder;
import com.mancj.slideup.TouchConsumer;

class HorizontalTouchConsumer
extends TouchConsumer {
    private boolean mGoingToStart = false;
    private boolean mGoingToEnd = false;

    HorizontalTouchConsumer(SlideUpBuilder builder, LoggerNotifier notifier, AnimationProcessor animationProcessor) {
        super(builder, notifier, animationProcessor);
    }

    boolean consumeEndToStart(View touchedView, MotionEvent event) {
        float touchedArea = event.getX();
        switch (event.getActionMasked()) {
            case 0: {
                this.mViewWidth = this.mBuilder.mSliderView.getWidth();
                this.mStartPositionX = event.getRawX();
                this.mViewStartPositionX = this.mBuilder.mSliderView.getTranslationX();
                this.mCanSlide = this.touchFromAlsoSlide(touchedView, event);
                this.mCanSlide |= (float)this.getStart() + this.mBuilder.mTouchableArea >= touchedArea;
                break;
            }
            case 2: {
                float difference = event.getRawX() - this.mStartPositionX;
                float moveTo = this.mViewStartPositionX + difference;
                float percents = moveTo * 100.0f / (float)this.mBuilder.mSliderView.getWidth();
                this.calculateDirection(event);
                if (!(moveTo > 0.0f) || !this.mCanSlide) break;
                this.mNotifier.notifyPercentChanged(percents);
                this.mBuilder.mSliderView.setTranslationX(moveTo);
                break;
            }
            case 1: {
                boolean scrollableAreaConsumed;
                float slideAnimationFrom = this.mBuilder.mSliderView.getTranslationX();
                if (slideAnimationFrom == this.mViewStartPositionX) {
                    return !Internal.isUpEventInView(this.mBuilder.mSliderView, event);
                }
                boolean bl = scrollableAreaConsumed = this.mBuilder.mSliderView.getTranslationX() > (float)(this.mBuilder.mSliderView.getWidth() / 5);
                if (scrollableAreaConsumed && this.mGoingToEnd) {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, this.mBuilder.mSliderView.getWidth());
                } else {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, 0.0f);
                }
                this.mCanSlide = true;
            }
        }
        this.mPrevPositionY = event.getRawY();
        this.mPrevPositionX = event.getRawX();
        return true;
    }

    boolean consumeStartToEnd(View touchedView, MotionEvent event) {
        float touchedArea = event.getX();
        switch (event.getActionMasked()) {
            case 0: {
                this.mViewWidth = this.mBuilder.mSliderView.getWidth();
                this.mStartPositionX = event.getRawX();
                this.mViewStartPositionX = this.mBuilder.mSliderView.getTranslationX();
                this.mCanSlide = this.touchFromAlsoSlide(touchedView, event);
                this.mCanSlide |= (float)this.getEnd() - this.mBuilder.mTouchableArea >= touchedArea;
                break;
            }
            case 2: {
                float difference = event.getRawX() - this.mStartPositionX;
                float moveTo = this.mViewStartPositionX + difference;
                float percents = moveTo * 100.0f / (float)(-this.mBuilder.mSliderView.getWidth());
                this.calculateDirection(event);
                if (!(moveTo < 0.0f) || !this.mCanSlide) break;
                this.mNotifier.notifyPercentChanged(percents);
                this.mBuilder.mSliderView.setTranslationX(moveTo);
                break;
            }
            case 1: {
                boolean scrollableAreaConsumed;
                float slideAnimationFrom = -this.mBuilder.mSliderView.getTranslationX();
                if (slideAnimationFrom == this.mViewStartPositionX) {
                    return !Internal.isUpEventInView(this.mBuilder.mSliderView, event);
                }
                boolean bl = scrollableAreaConsumed = this.mBuilder.mSliderView.getTranslationX() < (float)(-this.mBuilder.mSliderView.getHeight() / 5);
                if (scrollableAreaConsumed && this.mGoingToStart) {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, this.mBuilder.mSliderView.getWidth());
                } else {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, 0.0f);
                }
                this.mCanSlide = true;
            }
        }
        this.mPrevPositionY = event.getRawY();
        this.mPrevPositionX = event.getRawX();
        return true;
    }

    private void calculateDirection(MotionEvent event) {
        this.mGoingToStart = this.mPrevPositionX - event.getRawX() > 0.0f;
        this.mGoingToEnd = this.mPrevPositionX - event.getRawX() < 0.0f;
    }
}

