/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.animation.Animator;
import android.animation.ValueAnimator;
import com.mancj.slideup.SlideUpBuilder;

class AnimationProcessor {
    private SlideUpBuilder mBuilder;
    private ValueAnimator mValueAnimator;
    private float mSlideAnimationTo;

    AnimationProcessor(SlideUpBuilder builder, ValueAnimator.AnimatorUpdateListener updateListener, Animator.AnimatorListener listener) {
        this.mBuilder = builder;
        this.createAnimation(updateListener, listener);
    }

    void endAnimation() {
        if (this.mValueAnimator != null && this.mValueAnimator.getValues() != null && this.mValueAnimator.isRunning()) {
            this.mValueAnimator.end();
        }
    }

    void paramsChanged() {
        this.mValueAnimator.setDuration((long)this.mBuilder.mAutoSlideDuration);
        this.mValueAnimator.setInterpolator(this.mBuilder.mInterpolator);
    }

    float getSlideAnimationTo() {
        return this.mSlideAnimationTo;
    }

    boolean isAnimationRunning() {
        return this.mValueAnimator != null && this.mValueAnimator.isRunning();
    }

    void setValuesAndStart(float from, float to) {
        this.mSlideAnimationTo = to;
        this.mValueAnimator.setFloatValues(new float[]{from, to});
        this.mValueAnimator.start();
    }

    private void createAnimation(ValueAnimator.AnimatorUpdateListener updateListener, Animator.AnimatorListener listener) {
        this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        this.mValueAnimator.setDuration((long)this.mBuilder.mAutoSlideDuration);
        this.mValueAnimator.setInterpolator(this.mBuilder.mInterpolator);
        this.mValueAnimator.addUpdateListener(updateListener);
        this.mValueAnimator.addListener(listener);
    }
}

