/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.view.MotionEvent;
import com.mancj.slideup.AnimationProcessor;
import com.mancj.slideup.Internal;
import com.mancj.slideup.LoggerNotifier;
import com.mancj.slideup.SlideUpBuilder;
import com.mancj.slideup.TouchConsumer;

class HorizontalTouchConsumer
extends TouchConsumer {
    HorizontalTouchConsumer(SlideUpBuilder builder, LoggerNotifier notifier, AnimationProcessor animationProcessor) {
        super(builder, notifier, animationProcessor);
    }

    boolean consumeEndToStart(MotionEvent event) {
        float touchedArea = event.getX();
        switch (event.getActionMasked()) {
            case 0: {
                this.mViewWidth = this.mBuilder.mSliderView.getWidth();
                this.mStartPositionX = event.getRawX();
                this.mViewStartPositionX = this.mBuilder.mSliderView.getTranslationX();
                this.mCanSlide = (float)this.getStart() + this.mBuilder.mTouchableArea >= touchedArea;
                break;
            }
            case 2: {
                float difference = event.getRawX() - this.mStartPositionX;
                float moveTo = this.mViewStartPositionX + difference;
                float percents = moveTo * 100.0f / (float)this.mBuilder.mSliderView.getWidth();
                if (moveTo > 0.0f && this.mCanSlide) {
                    this.mNotifier.notifyPercentChanged(percents);
                    this.mBuilder.mSliderView.setTranslationX(moveTo);
                }
                if (!(event.getRawX() > this.mMaxSlidePosition)) break;
                this.mMaxSlidePosition = event.getRawX();
                break;
            }
            case 1: {
                boolean scrollableAreaConsumed;
                float slideAnimationFrom = this.mBuilder.mSliderView.getTranslationX();
                if (slideAnimationFrom == this.mViewStartPositionX) {
                    return !Internal.isUpEventInView(this.mBuilder.mSliderView, event);
                }
                boolean mustShow = this.mMaxSlidePosition > event.getRawX();
                boolean bl = scrollableAreaConsumed = this.mBuilder.mSliderView.getTranslationX() > (float)(this.mBuilder.mSliderView.getWidth() / 5);
                if (scrollableAreaConsumed && !mustShow) {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, this.mBuilder.mSliderView.getWidth());
                } else {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, 0.0f);
                }
                this.mCanSlide = true;
                this.mMaxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    boolean consumeStartToEnd(MotionEvent event) {
        float touchedArea = event.getX();
        switch (event.getActionMasked()) {
            case 0: {
                this.mMaxSlidePosition = this.mViewWidth;
                this.mViewWidth = this.mBuilder.mSliderView.getWidth();
                this.mStartPositionX = event.getRawX();
                this.mViewStartPositionX = this.mBuilder.mSliderView.getTranslationX();
                this.mCanSlide = (float)this.getEnd() - this.mBuilder.mTouchableArea >= touchedArea;
                break;
            }
            case 2: {
                float difference = event.getRawX() - this.mStartPositionX;
                float moveTo = this.mViewStartPositionX + difference;
                float percents = moveTo * 100.0f / (float)(-this.mBuilder.mSliderView.getWidth());
                if (moveTo < 0.0f && this.mCanSlide) {
                    this.mNotifier.notifyPercentChanged(percents);
                    this.mBuilder.mSliderView.setTranslationX(moveTo);
                }
                if (!(event.getRawX() < this.mMaxSlidePosition)) break;
                this.mMaxSlidePosition = event.getRawX();
                break;
            }
            case 1: {
                boolean scrollableAreaConsumed;
                float slideAnimationFrom = -this.mBuilder.mSliderView.getTranslationX();
                if (slideAnimationFrom == this.mViewStartPositionX) {
                    return !Internal.isUpEventInView(this.mBuilder.mSliderView, event);
                }
                boolean mustShow = this.mMaxSlidePosition < event.getRawX();
                boolean bl = scrollableAreaConsumed = this.mBuilder.mSliderView.getTranslationX() < (float)(-this.mBuilder.mSliderView.getHeight() / 5);
                if (scrollableAreaConsumed && !mustShow) {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, this.mBuilder.mSliderView.getWidth());
                } else {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, 0.0f);
                }
                this.mCanSlide = true;
                this.mMaxSlidePosition = 0.0f;
            }
        }
        return true;
    }
}

