/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip.views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.os.Build;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Filter;
import android.widget.RelativeLayout;
import butterknife.BindView;
import butterknife.ButterKnife;
import edu.ben.materialchip.ChipsInput;
import edu.ben.materialchip.R;
import edu.ben.materialchip.adapter.FilterableAdapter;
import edu.ben.materialchip.model.ChipInterface;
import edu.ben.materialchip.util.ViewUtil;
import java.util.List;

public class FilterableListView
extends RelativeLayout {
    private static final String TAG = FilterableListView.class.toString();
    private Context mContext;
    @BindView(value=2131427425)
    RecyclerView mRecyclerView;
    private FilterableAdapter mAdapter;
    private List<? extends ChipInterface> mFilterableList;
    private ChipsInput mChipsInput;

    public FilterableListView(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    private void init() {
        View view = FilterableListView.inflate((Context)this.getContext(), (int)R.layout.list_filterable_view, (ViewGroup)this);
        ButterKnife.bind((Object)((Object)this), (View)view);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext, 1, false));
        this.setVisibility(8);
    }

    public void build(List<? extends ChipInterface> filterableList, ChipsInput chipsInput, ColorStateList backgroundColor, ColorStateList textColor) {
        this.mFilterableList = filterableList;
        this.mChipsInput = chipsInput;
        this.mAdapter = new FilterableAdapter(this.mContext, this.mRecyclerView, filterableList, chipsInput, backgroundColor, textColor);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        if (backgroundColor != null) {
            this.mRecyclerView.getBackground().setColorFilter(backgroundColor.getDefaultColor(), PorterDuff.Mode.SRC_ATOP);
        }
        this.mChipsInput.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ViewGroup rootView = (ViewGroup)FilterableListView.this.mChipsInput.getRootView();
                int leftPadding = ViewUtil.getWindowBottomNavBarHeight(FilterableListView.this.mContext);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
                layoutParams.addRule(3, FilterableListView.this.mChipsInput.getId());
                if (Build.VERSION.SDK_INT >= 17) {
                    layoutParams.addRule(20);
                }
                layoutParams.addRule(9);
                if (((FilterableListView)FilterableListView.this).mContext.getResources().getConfiguration().orientation == 1) {
                    layoutParams.bottomMargin = ViewUtil.getNavBarHeight(FilterableListView.this.mContext);
                }
                FilterableListView filterableListView = FilterableListView.this;
                filterableListView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                if (((FilterableListView)FilterableListView.this).mContext.getResources().getConfiguration().orientation == 2) {
                    if (Build.VERSION.SDK_INT >= 17) {
                        filterableListView.setPaddingRelative(leftPadding - ViewUtil.dpToPx(6), 0, 0, 0);
                    }
                    filterableListView.setPadding(0, 0, leftPadding - ViewUtil.dpToPx(6), 0);
                }
                filterableListView.bringToFront();
                rootView.addView((View)filterableListView);
                FilterableListView.this.mChipsInput.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    public void filterList(CharSequence text) {
        this.mAdapter.getFilter().filter(text, new Filter.FilterListener(){

            public void onFilterComplete(int count) {
                if (FilterableListView.this.mAdapter.getItemCount() > 0) {
                    FilterableListView.this.fadeIn();
                } else {
                    FilterableListView.this.fadeOut();
                }
            }
        });
    }

    public void fadeIn() {
        if (this.getVisibility() == 0) {
            return;
        }
        View rootView = this.getRootView();
        Rect r = new Rect();
        rootView.getWindowVisibleDisplayFrame(r);
        int[] coord = new int[2];
        this.mChipsInput.getLocationInWindow(coord);
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        layoutParams.topMargin = coord[1] + this.mChipsInput.getHeight();
        layoutParams.bottomMargin = rootView.getHeight() - r.bottom;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        AlphaAnimation anim2 = new AlphaAnimation(0.0f, 1.0f);
        anim2.setDuration(200L);
        this.startAnimation((Animation)anim2);
        this.setVisibility(0);
    }

    public void fadeOut() {
        if (this.getVisibility() == 8) {
            return;
        }
        AlphaAnimation anim2 = new AlphaAnimation(1.0f, 0.0f);
        anim2.setDuration(200L);
        this.startAnimation((Animation)anim2);
        this.setVisibility(8);
    }
}

