/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip.util;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.view.View;
import java.util.Locale;

public class RTLUtil {
    public static boolean isRTL() {
        return RTLUtil.isRTL(Locale.getDefault());
    }

    private static boolean isRTL(Locale locale) {
        byte directionality = Character.getDirectionality(locale.getDisplayName().charAt(0));
        return directionality == 1 || directionality == 2;
    }

    public static boolean isRTL(View view) {
        return ViewCompat.getLayoutDirection((View)view) == 1;
    }

    @RequiresApi(api=17)
    public static boolean isRTL(Context context) {
        Configuration config = context.getResources().getConfiguration();
        return config.getLayoutDirection() == 1;
    }

    public static boolean checkRTL(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return false;
        }
        char c = text.charAt(0);
        return c >= '\u0590' && c <= '\u06ff';
    }

    public static void changLayoutDirection(View contentLayout, boolean isRTL) {
        if (isRTL) {
            if (Build.VERSION.SDK_INT >= 17) {
                contentLayout.setLayoutDirection(1);
            } else {
                ViewCompat.setLayoutDirection((View)contentLayout, (int)1);
            }
        } else if (Build.VERSION.SDK_INT >= 17) {
            contentLayout.setLayoutDirection(0);
        } else {
            ViewCompat.setLayoutDirection((View)contentLayout, (int)0);
        }
    }
}

