/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.util.TypedValue;
import edu.ben.materialchip.R;

public class ColorUtil {
    public static int lighter(int color2, float factor) {
        int red = (int)(((float)Color.red((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int green = (int)(((float)Color.green((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int blue = (int)(((float)Color.blue((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        return Color.argb((int)Color.alpha((int)color2), (int)red, (int)green, (int)blue);
    }

    public static int lighter(ColorStateList color2, float factor) {
        return ColorUtil.lighter(color2.getDefaultColor(), factor);
    }

    public static int alpha(int color2, int alpha) {
        return Color.argb((int)alpha, (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
    }

    public static boolean isColorDark(int color2) {
        double darkness = 1.0 - (0.2126 * (double)Color.red((int)color2) + 0.7152 * (double)Color.green((int)color2) + 0.0722 * (double)Color.blue((int)color2)) / 255.0;
        return darkness >= 0.5;
    }

    public static int getThemeAccentColor(Context context) {
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorAccent, value, true);
        return value.data;
    }
}

