/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip.adapter;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import de.hdodenhof.circleimageview.CircleImageView;
import edu.ben.materialchip.ChipsInput;
import edu.ben.materialchip.R;
import edu.ben.materialchip.model.ChipInterface;
import edu.ben.materialchip.util.ColorUtil;
import edu.ben.materialchip.util.LetterTileProvider;
import edu.ben.materialchip.util.RTLUtil;
import edu.ben.materialchip.util.ViewUtil;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FilterableAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements Filterable {
    private static final String TAG = FilterableAdapter.class.toString();
    private Context mContext;
    private List<ChipInterface> mOriginalList = new ArrayList<ChipInterface>();
    private List<ChipInterface> mChipList = new ArrayList<ChipInterface>();
    private List<ChipInterface> mFilteredList = new ArrayList<ChipInterface>();
    private ChipFilter mFilter;
    private ChipsInput mChipsInput;
    private LetterTileProvider mLetterTileProvider;
    private ColorStateList mBackgroundColor;
    private ColorStateList mTextColor;
    private RecyclerView mRecyclerView;
    private Comparator<ChipInterface> mComparator;
    private Collator mCollator;

    public FilterableAdapter(Context context, RecyclerView recyclerView, List<? extends ChipInterface> chipList, ChipsInput chipsInput, ColorStateList backgroundColor, ColorStateList textColor) {
        this.mContext = context;
        this.mRecyclerView = recyclerView;
        this.mCollator = Collator.getInstance(Locale.getDefault());
        this.mCollator.setStrength(0);
        this.mComparator = new Comparator<ChipInterface>(){

            @Override
            public int compare(ChipInterface o1, ChipInterface o2) {
                return FilterableAdapter.this.mCollator.compare(o1.getLabel(), o2.getLabel());
            }
        };
        Iterator<? extends ChipInterface> iterator = chipList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getLabel() != null) continue;
            iterator.remove();
        }
        this.sortList(chipList);
        this.mOriginalList.addAll(chipList);
        this.mChipList.addAll(chipList);
        this.mFilteredList.addAll(chipList);
        this.mLetterTileProvider = new LetterTileProvider(this.mContext);
        this.mBackgroundColor = backgroundColor;
        this.mTextColor = textColor;
        this.mChipsInput = chipsInput;
        this.mChipsInput.addChipsListener(new ChipsInput.ChipsListener(){

            @Override
            public void onChipAdded(ChipInterface chip, int newSize) {
                FilterableAdapter.this.removeChip(chip);
            }

            @Override
            public void onChipRemoved(ChipInterface chip, int newSize) {
                FilterableAdapter.this.addChip(chip);
            }

            @Override
            public void onTextChanged(CharSequence text) {
                FilterableAdapter.this.mRecyclerView.scrollToPosition(0);
            }
        });
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_list_filterable, parent, false);
        return new ItemViewHolder(view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        ItemViewHolder itemViewHolder = (ItemViewHolder)holder;
        final ChipInterface chip = this.getItem(position);
        Bitmap letterTile = this.mLetterTileProvider.getLetterTile(chip.getLabel());
        if (RTLUtil.checkRTL(chip.getLabel())) {
            RTLUtil.changLayoutDirection(itemViewHolder.itemView, true);
        } else {
            RTLUtil.changLayoutDirection(itemViewHolder.itemView, false);
        }
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.mChipsInput.getWidth(), ViewUtil.dpToPx(72));
        layoutParams.gravity = 17;
        itemViewHolder.mContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mChipsInput.chipHasAvatarIcon() && chip.getAvatarUri() != null) {
            itemViewHolder.mAvatar.setVisibility(0);
            itemViewHolder.mAvatar.setImageURI(chip.getAvatarUri());
        } else if (this.mChipsInput.chipHasAvatarIcon() && chip.getAvatarUrl() != null && !chip.getAvatarUrl().equals("")) {
            itemViewHolder.mAvatar.setVisibility(0);
            this.setAvatarImageUrl(itemViewHolder, chip.getAvatarUrl(), letterTile);
        } else if (this.mChipsInput.chipHasAvatarIcon() && chip.getAvatarDrawable() != null) {
            itemViewHolder.mAvatar.setVisibility(0);
            itemViewHolder.mAvatar.setImageDrawable(chip.getAvatarDrawable());
        } else if (this.mChipsInput.chipHasAvatarIcon()) {
            itemViewHolder.mAvatar.setVisibility(0);
            itemViewHolder.mAvatar.setImageBitmap(this.mLetterTileProvider.getLetterTile(chip.getLabel()));
        } else {
            itemViewHolder.mAvatar.setVisibility(8);
        }
        itemViewHolder.mLabel.setText((CharSequence)chip.getLabel());
        if (chip.getInfo() != null) {
            itemViewHolder.mInfo.setVisibility(0);
            itemViewHolder.mInfo.setText((CharSequence)chip.getInfo());
        } else {
            itemViewHolder.mInfo.setVisibility(8);
        }
        if (this.mBackgroundColor != null) {
            itemViewHolder.itemView.getBackground().setColorFilter(this.mBackgroundColor.getDefaultColor(), PorterDuff.Mode.SRC_ATOP);
        }
        if (this.mTextColor != null) {
            itemViewHolder.mLabel.setTextColor(this.mTextColor);
            itemViewHolder.mInfo.setTextColor(ColorUtil.alpha(this.mTextColor.getDefaultColor(), 150));
        }
        itemViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FilterableAdapter.this.mChipsInput != null) {
                    FilterableAdapter.this.mChipsInput.addChip(chip);
                }
            }
        });
    }

    private void setAvatarImageUrl(final ItemViewHolder itemViewHolder, String imageUrl, final Bitmap letterTile) {
        Picasso.with((Context)this.mContext).load(imageUrl).centerCrop().resize(50, 50).error(R.drawable.ic_cancel_grey_24dp).into((ImageView)itemViewHolder.mAvatar, new Callback(){

            public void onSuccess() {
            }

            public void onError() {
                itemViewHolder.mAvatar.setImageBitmap(letterTile);
            }
        });
    }

    public int getItemCount() {
        return this.mFilteredList.size();
    }

    private ChipInterface getItem(int position) {
        return this.mFilteredList.get(position);
    }

    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new ChipFilter(this, this.mChipList);
        }
        return this.mFilter;
    }

    private void removeChip(ChipInterface chip) {
        int position = this.mFilteredList.indexOf(chip);
        if (position >= 0) {
            this.mFilteredList.remove(position);
        }
        if ((position = this.mChipList.indexOf(chip)) >= 0) {
            this.mChipList.remove(position);
        }
        this.notifyDataSetChanged();
    }

    private void addChip(ChipInterface chip) {
        if (this.contains(chip)) {
            this.mChipList.add(chip);
            this.mFilteredList.add(chip);
            this.sortList(this.mChipList);
            this.sortList(this.mFilteredList);
            this.notifyDataSetChanged();
        }
    }

    private boolean contains(ChipInterface chip) {
        for (ChipInterface item : this.mOriginalList) {
            if (!item.equals(chip)) continue;
            return true;
        }
        return false;
    }

    private void sortList(List<? extends ChipInterface> list) {
        Collections.sort(list, this.mComparator);
    }

    private class ChipFilter
    extends Filter {
        private FilterableAdapter adapter;
        private List<ChipInterface> originalList;
        private List<ChipInterface> filteredList;

        public ChipFilter(FilterableAdapter adapter, List<ChipInterface> originalList) {
            this.adapter = adapter;
            this.originalList = originalList;
            this.filteredList = new ArrayList<ChipInterface>();
        }

        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            this.filteredList.clear();
            Filter.FilterResults results = new Filter.FilterResults();
            if (constraint.length() == 0) {
                this.filteredList.addAll(this.originalList);
            } else {
                String filterPattern = constraint.toString().toLowerCase().trim();
                for (ChipInterface chip : this.originalList) {
                    if (chip.getLabel().toLowerCase().contains(filterPattern)) {
                        this.filteredList.add(chip);
                        continue;
                    }
                    if (chip.getInfo() == null || !chip.getInfo().toLowerCase().replaceAll("\\s", "").contains(filterPattern)) continue;
                    this.filteredList.add(chip);
                }
            }
            results.values = this.filteredList;
            results.count = this.filteredList.size();
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            FilterableAdapter.this.mFilteredList.clear();
            FilterableAdapter.this.mFilteredList.addAll((ArrayList)results.values);
            FilterableAdapter.this.notifyDataSetChanged();
        }
    }

    private class ItemViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout mContainer;
        private CircleImageView mAvatar;
        private TextView mLabel;
        private TextView mInfo;

        ItemViewHolder(View view) {
            super(view);
            this.mContainer = (LinearLayout)view.findViewById(R.id.container);
            this.mAvatar = (CircleImageView)view.findViewById(R.id.avatar);
            this.mLabel = (TextView)view.findViewById(R.id.label);
            this.mInfo = (TextView)view.findViewById(R.id.info);
        }
    }
}

