/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip.adapter;

import android.content.Context;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import edu.ben.materialchip.ChipView;
import edu.ben.materialchip.ChipsInput;
import edu.ben.materialchip.model.ChipInterface;
import edu.ben.materialchip.util.RTLUtil;
import edu.ben.materialchip.util.ViewUtil;
import edu.ben.materialchip.views.ChipsInputEditText;
import edu.ben.materialchip.views.DetailedChipView;
import edu.ben.materialchip.views.FilterableListView;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ChipsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = ChipsAdapter.class.toString();
    private static final int TYPE_EDIT_TEXT = 0;
    private static final int TYPE_ITEM = 1;
    private Context mContext;
    private ChipsInput mChipsInput;
    private List<ChipInterface> mChipList = new ArrayList<ChipInterface>();
    private String mHintLabel;
    private ChipsInputEditText mEditText;
    private RecyclerView mRecycler;
    private boolean mIsRTL;
    private int[] mFirstItemCoord;
    private int mFirstChipWidth;

    public ChipsAdapter(Context context, ChipsInput chipsInput, RecyclerView recycler) {
        this.mContext = context;
        this.mChipsInput = chipsInput;
        this.mRecycler = recycler;
        this.mHintLabel = this.mChipsInput.getHint();
        this.mEditText = this.mChipsInput.getEditText();
        this.isRtl();
        this.initEditText();
    }

    private void isRtl() {
        this.mIsRTL = RTLUtil.isRTL();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return new EditTextViewHolder((View)this.mEditText);
        }
        return new ItemViewHolder((View)this.mChipsInput.getChipView());
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (position == this.mChipList.size()) {
            if (this.mChipList.size() == 0) {
                this.mEditText.setHint(this.mHintLabel);
            }
            this.autofitEditText();
        } else if (this.getItemCount() > 1) {
            ItemViewHolder itemViewHolder = (ItemViewHolder)holder;
            itemViewHolder.chipView.inflate(this.getItem(position));
            if (position == 0) {
                this.mFirstItemCoord = this.getItemLocationInWindow(itemViewHolder.chipView);
                this.getItemWidth(itemViewHolder.chipView);
            }
            this.handleClickOnEditText(itemViewHolder.chipView, position);
        }
    }

    private void getItemWidth(final ChipView chipView) {
        chipView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ChipsAdapter.this.mFirstChipWidth = chipView.getWidth();
                chipView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private int[] getItemLocationInWindow(final ChipView chipView) {
        final int[] coord = new int[2];
        chipView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                chipView.getLocationInWindow(coord);
                chipView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        return coord;
    }

    public int getItemCount() {
        return this.mChipList.size() + 1;
    }

    private ChipInterface getItem(int position) {
        return this.mChipList.get(position);
    }

    public int getItemViewType(int position) {
        if (position == this.mChipList.size()) {
            return 0;
        }
        return 1;
    }

    public long getItemId(int position) {
        return this.mChipList.get(position).hashCode();
    }

    private void initEditText() {
        int paddingLeftRight = ViewUtil.dpToPx(4);
        int paddingTopBottom = ViewUtil.dpToPx(5);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
        this.mEditText.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mEditText.setHint(this.mHintLabel);
        this.mEditText.setBackgroundResource(17170445);
        this.mEditText.setImeOptions(0x10000000);
        this.mEditText.setPrivateImeOptions("nm");
        this.mEditText.setInputType(524464);
        if (this.mIsRTL) {
            this.mEditText.setGravity(0x800005);
            this.mEditText.setPaddingRelative(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
            if (Build.VERSION.SDK_INT >= 17) {
                this.mEditText.setTextAlignment(6);
                this.mRecycler.setPaddingRelative(12, 24, 0, 24);
            }
        } else {
            this.mEditText.setGravity(0x800003);
            this.mEditText.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
            if (Build.VERSION.SDK_INT >= 17) {
                this.mEditText.setTextAlignment(5);
                this.mRecycler.setPadding(12, 24, 0, 24);
            }
        }
        this.mEditText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && event.getKeyCode() == 67 && ChipsAdapter.this.mChipList.size() > 0 && ChipsAdapter.this.mEditText.getText().toString().length() == 0) {
                    ChipsAdapter.this.removeChip(ChipsAdapter.this.mChipList.size() - 1);
                }
                return false;
            }
        });
        this.mEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                ChipsAdapter.this.mChipsInput.onTextChanged(s);
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    private void autofitEditText() {
        ViewGroup.LayoutParams params = this.mEditText.getLayoutParams();
        params.width = ViewUtil.dpToPx(50);
        this.mEditText.setLayoutParams(params);
        this.mEditText.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int recyclerRight = ChipsAdapter.this.mRecycler.getRight();
                int editLeft = ChipsAdapter.this.mEditText.getLeft();
                int editRight = ChipsAdapter.this.mEditText.getRight();
                ViewGroup.LayoutParams params = ChipsAdapter.this.mEditText.getLayoutParams();
                params.width = !ChipsAdapter.this.mIsRTL ? recyclerRight - editLeft - ViewUtil.dpToPx(4) : editRight - editLeft + editLeft - ViewUtil.dpToPx(4);
                ChipsAdapter.this.mEditText.setLayoutParams(params);
                ChipsAdapter.this.mEditText.requestFocus();
                ChipsAdapter.this.mEditText.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private void handleClickOnEditText(ChipView chipView, final int position) {
        chipView.setOnDeleteClicked(new View.OnClickListener(){

            public void onClick(View v) {
                ChipsAdapter.this.removeChip(position);
            }
        });
        if (this.mChipsInput.isShowChipDetailed()) {
            chipView.setOnChipClicked(new View.OnClickListener(){

                public void onClick(View v) {
                    int[] coord = new int[2];
                    v.getLocationInWindow(coord);
                    final DetailedChipView detailedChipView = ChipsAdapter.this.mChipsInput.getDetailedChipView(ChipsAdapter.this.getItem(position));
                    ChipsAdapter.this.setDetailedChipViewPosition(detailedChipView, coord);
                    detailedChipView.setOnDeleteClicked(new View.OnClickListener(){

                        public void onClick(View v) {
                            ChipsAdapter.this.removeChip(position);
                            detailedChipView.fadeOut();
                        }
                    });
                }
            });
        }
    }

    private void setDetailedChipViewPosition(DetailedChipView detailedChipView, int[] coord) {
        ViewGroup rootView = (ViewGroup)this.mRecycler.getRootView();
        int windowWidth = ViewUtil.getWindowWidth(this.mContext);
        int width = this.mRecycler.getWidth();
        int layoutHeight = ((View)this.mRecycler.getParent()).getHeight();
        int layoutWidth = ((View)this.mRecycler.getParent()).getWidth();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(ViewUtil.dpToPx(300), ViewUtil.dpToPx(100));
        if (ViewUtil.getScreenOrientation(this.mContext) == 1) {
            if (!this.mIsRTL) {
                if (coord[0] >= 0 && coord[0] < windowWidth) {
                    layoutParams.leftMargin = this.mFirstItemCoord[0] - ViewUtil.dpToPx(8);
                    layoutParams.topMargin = coord[1] - ViewUtil.dpToPx(14);
                }
            } else if (coord[0] >= 0 && coord[0] < windowWidth) {
                layoutParams.rightMargin = windowWidth - this.mFirstItemCoord[0] - this.mFirstChipWidth - ViewUtil.dpToPx(9);
                layoutParams.topMargin = coord[1] - ViewUtil.dpToPx(14);
            }
        } else if (!this.mIsRTL) {
            if (coord[0] >= 0 && coord[0] < windowWidth) {
                layoutParams.leftMargin = this.mFirstItemCoord[0] - ViewUtil.dpToPx(8);
                layoutParams.topMargin = coord[1] - ViewUtil.dpToPx(14);
            }
        } else if (coord[0] >= 0 && coord[0] < windowWidth) {
            layoutParams.rightMargin = windowWidth - this.mFirstItemCoord[0] - this.mFirstChipWidth + ViewUtil.dpToPx(34);
            layoutParams.topMargin = coord[1] - ViewUtil.dpToPx(14);
        }
        rootView.addView((View)detailedChipView, (ViewGroup.LayoutParams)layoutParams);
        detailedChipView.fadeIn();
    }

    public void setFilterableListView(FilterableListView filterableListView) {
        if (this.mEditText != null) {
            this.mEditText.setFilterableListView(filterableListView);
        }
    }

    public void addChip(ChipInterface chip) {
        if (!this.listContains(this.mChipList, chip)) {
            this.mChipList.add(chip);
            this.mChipsInput.onChipAdded(chip, this.mChipList.size());
            this.mEditText.setHint(null);
            this.mEditText.setText(null);
            this.notifyItemInserted(this.mChipList.size());
        }
    }

    public void removeChip(ChipInterface chip) {
        int position = this.mChipList.indexOf(chip);
        this.mChipList.remove(position);
        this.notifyItemRangeChanged(position, this.getItemCount());
        if (this.mChipList.size() == 0) {
            this.mEditText.setHint(this.mHintLabel);
        }
        this.notifyDataSetChanged();
    }

    public void removeChip(int position) {
        ChipInterface chip = this.mChipList.get(position);
        this.mChipList.remove(position);
        this.mChipsInput.onChipRemoved(chip, this.mChipList.size());
        if (this.mChipList.size() == 0) {
            this.mEditText.setHint(this.mHintLabel);
        }
        this.notifyDataSetChanged();
    }

    public void removeChipById(Object id2) {
        ListIterator<ChipInterface> iter = this.mChipList.listIterator();
        while (iter.hasNext()) {
            ChipInterface chip = (ChipInterface)iter.next();
            if (chip.getId() == null || !chip.getId().equals(id2)) continue;
            iter.remove();
            this.mChipsInput.onChipRemoved(chip, this.mChipList.size());
        }
        if (this.mChipList.size() == 0) {
            this.mEditText.setHint(this.mHintLabel);
        }
        this.notifyDataSetChanged();
    }

    public void removeChipByLabel(String label) {
        ListIterator<ChipInterface> iter = this.mChipList.listIterator();
        while (iter.hasNext()) {
            ChipInterface chip = (ChipInterface)iter.next();
            if (!chip.getLabel().equals(label)) continue;
            iter.remove();
            this.mChipsInput.onChipRemoved(chip, this.mChipList.size());
        }
        if (this.mChipList.size() == 0) {
            this.mEditText.setHint(this.mHintLabel);
        }
        this.notifyDataSetChanged();
    }

    public void removeChipByInfo(String info) {
        ListIterator<ChipInterface> iter = this.mChipList.listIterator();
        while (iter.hasNext()) {
            ChipInterface chip = (ChipInterface)iter.next();
            if (chip.getInfo() == null || !chip.getInfo().equals(info)) continue;
            iter.remove();
            this.mChipsInput.onChipRemoved(chip, this.mChipList.size());
        }
        if (this.mChipList.size() == 0) {
            this.mEditText.setHint(this.mHintLabel);
        }
        this.notifyDataSetChanged();
    }

    public List<ChipInterface> getChipList() {
        return this.mChipList;
    }

    private boolean listContains(List<ChipInterface> contactList, ChipInterface chip) {
        if (this.mChipsInput.getChipValidator() != null) {
            for (ChipInterface item : contactList) {
                if (!this.mChipsInput.getChipValidator().areEquals(item, chip)) continue;
                return true;
            }
        } else {
            for (ChipInterface item : contactList) {
                if (chip.getId() != null && chip.getId().equals(item.getId())) {
                    return true;
                }
                if (!chip.getLabel().equals(item.getLabel())) continue;
                return true;
            }
        }
        return false;
    }

    private class EditTextViewHolder
    extends RecyclerView.ViewHolder {
        private final EditText editText;

        EditTextViewHolder(View view) {
            super(view);
            this.editText = (EditText)view;
        }
    }

    private class ItemViewHolder
    extends RecyclerView.ViewHolder {
        private final ChipView chipView;

        ItemViewHolder(View view) {
            super(view);
            this.chipView = (ChipView)view;
        }
    }
}

