/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import butterknife.BindView;
import butterknife.ButterKnife;
import com.beloo.widget.chipslayoutmanager.ChipsLayoutManager;
import edu.ben.materialchip.ChipView;
import edu.ben.materialchip.R;
import edu.ben.materialchip.adapter.ChipsAdapter;
import edu.ben.materialchip.model.Chip;
import edu.ben.materialchip.model.ChipInterface;
import edu.ben.materialchip.util.ActivityUtil;
import edu.ben.materialchip.util.MyWindowCallback;
import edu.ben.materialchip.util.ViewUtil;
import edu.ben.materialchip.views.ChipsInputEditText;
import edu.ben.materialchip.views.DetailedChipView;
import edu.ben.materialchip.views.FilterableListView;
import edu.ben.materialchip.views.ScrollViewMaxHeight;
import java.util.ArrayList;
import java.util.List;

public class ChipsInput
extends ScrollViewMaxHeight {
    private static final String TAG = ChipsInput.class.toString();
    private Context mContext;
    @BindView(value=2131427419)
    RecyclerView mRecyclerView;
    private ChipsAdapter mChipsAdapter;
    private static final int NONE = -1;
    private String mHint;
    private int mHintTextSize;
    private ColorStateList mHintColor;
    private ColorStateList mTextColor;
    private int mMaxRows = 2;
    private ColorStateList mChipLabelColor;
    private boolean mChipHasAvatarIcon = true;
    private boolean mChipDeletable = false;
    private Drawable mChipDeleteIcon;
    private ColorStateList mChipDeleteIconColor;
    private ColorStateList mChipBackgroundColor;
    private boolean mShowChipDetailed = true;
    private ColorStateList mChipDetailedTextColor;
    private ColorStateList mChipDetailedDeleteIconColor;
    private ColorStateList mChipDetailedBackgroundColor;
    private ColorStateList mFilterableListBackgroundColor;
    private ColorStateList mFilterableListTextColor;
    private List<ChipsListener> mChipsListenerList = new ArrayList<ChipsListener>();
    private ChipsListener mChipsListener;
    private List<? extends ChipInterface> mChipList;
    private FilterableListView mFilterableListView;
    private ChipValidator mChipValidator;

    public ChipsInput(Context context) {
        super(context);
        this.mContext = context;
        this.init(null);
    }

    public ChipsInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs) {
        View rootView = ChipsInput.inflate((Context)this.getContext(), (int)R.layout.chips_input, (ViewGroup)this);
        ButterKnife.bind((Object)((Object)this), (View)rootView);
        if (attrs != null) {
            TypedArray a = this.mContext.getTheme().obtainStyledAttributes(attrs, R.styleable.ChipsInput, 0, 0);
            try {
                this.mHint = a.getString(R.styleable.ChipsInput_hint);
                this.mHintTextSize = a.getDimensionPixelSize(R.styleable.ChipsInput_hintSize, 0);
                this.mHintColor = a.getColorStateList(R.styleable.ChipsInput_hintColor);
                this.mTextColor = a.getColorStateList(R.styleable.ChipsInput_textColor);
                this.mMaxRows = a.getInteger(R.styleable.ChipsInput_maxRows, 2);
                this.setMaxHeight(ViewUtil.dpToPx(40 * this.mMaxRows + 8));
                this.mChipLabelColor = a.getColorStateList(R.styleable.ChipsInput_chip_labelColor);
                this.mChipHasAvatarIcon = a.getBoolean(R.styleable.ChipsInput_chip_hasAvatarIcon, true);
                this.mChipDeletable = a.getBoolean(R.styleable.ChipsInput_chip_deletable, false);
                this.mChipDeleteIconColor = a.getColorStateList(R.styleable.ChipsInput_chip_deleteIconColor);
                int deleteIconId = a.getResourceId(R.styleable.ChipsInput_chip_deleteIcon, -1);
                if (deleteIconId != -1) {
                    this.mChipDeleteIcon = ContextCompat.getDrawable((Context)this.mContext, (int)deleteIconId);
                }
                this.mChipBackgroundColor = a.getColorStateList(R.styleable.ChipsInput_chip_backgroundColor);
                this.mShowChipDetailed = a.getBoolean(R.styleable.ChipsInput_showChipDetailed, true);
                this.mChipDetailedTextColor = a.getColorStateList(R.styleable.ChipsInput_chip_detailed_textColor);
                this.mChipDetailedBackgroundColor = a.getColorStateList(R.styleable.ChipsInput_chip_detailed_backgroundColor);
                this.mChipDetailedDeleteIconColor = a.getColorStateList(R.styleable.ChipsInput_chip_detailed_deleteIconColor);
                this.mFilterableListBackgroundColor = a.getColorStateList(R.styleable.ChipsInput_filterable_list_backgroundColor);
                this.mFilterableListTextColor = a.getColorStateList(R.styleable.ChipsInput_filterable_list_textColor);
            }
            finally {
                a.recycle();
            }
        }
        this.mChipsAdapter = new ChipsAdapter(this.mContext, this, this.mRecyclerView);
        ChipsLayoutManager chipsLayoutManager = ChipsLayoutManager.newBuilder((Context)this.mContext).setOrientation(1).build();
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)chipsLayoutManager);
        this.mRecyclerView.setNestedScrollingEnabled(false);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mChipsAdapter);
        Activity activity = ActivityUtil.scanForActivity(this.mContext);
        if (activity == null) {
            throw new ClassCastException("android.view.Context cannot be cast to android.app.Activity");
        }
        Window.Callback mCallBack = activity.getWindow().getCallback();
        activity.getWindow().setCallback((Window.Callback)new MyWindowCallback(mCallBack, activity));
    }

    public void addChip(ChipInterface chip) {
        this.mChipsAdapter.addChip(chip);
    }

    public void addChip(Object id2, Drawable icon, String label, String info) {
        Chip chip = new Chip(id2, icon, label, info);
        this.mChipsAdapter.addChip(chip);
    }

    public void addChip(Drawable icon, String label, String info) {
        Chip chip = new Chip(icon, label, info);
        this.mChipsAdapter.addChip(chip);
    }

    public void addChip(Object id2, Uri iconUri, String label, String info) {
        Chip chip = new Chip(id2, iconUri, label, info);
        this.mChipsAdapter.addChip(chip);
    }

    public void addChip(Uri iconUri, String label, String info) {
        Chip chip = new Chip(iconUri, label, info);
        this.mChipsAdapter.addChip(chip);
    }

    public void addChip(Object id2, String iconUrl, String label, String info) {
        Chip chip = new Chip(id2, iconUrl, label, info);
        this.mChipsAdapter.addChip(chip);
    }

    public void addChip(String iconUrl, String label, String info) {
        Chip chip = new Chip(iconUrl, label, info);
        this.mChipsAdapter.addChip(chip);
    }

    public void addChip(String label, String info) {
        Chip chip = new Chip(label, info);
        this.mChipsAdapter.addChip(chip);
    }

    public void removeChip(ChipInterface chip) {
        this.mChipsAdapter.removeChip(chip);
    }

    public void removeChipById(Object id2) {
        this.mChipsAdapter.removeChipById(id2);
    }

    public void removeChipByLabel(String label) {
        this.mChipsAdapter.removeChipByLabel(label);
    }

    public void removeChipByInfo(String info) {
        this.mChipsAdapter.removeChipByInfo(info);
    }

    public ChipView getChipView() {
        int padding = ViewUtil.dpToPx(4);
        ChipView chipView = new ChipView.Builder(this.mContext).labelColor(this.mChipLabelColor).hasAvatarIcon(this.mChipHasAvatarIcon).deletable(this.mChipDeletable).deleteIcon(this.mChipDeleteIcon).deleteIconColor(this.mChipDeleteIconColor).backgroundColor(this.mChipBackgroundColor).build();
        chipView.setPadding(padding, padding, padding, padding);
        if (Build.VERSION.SDK_INT >= 17) {
            chipView.setPaddingRelative(padding, padding, padding, padding);
        }
        return chipView;
    }

    public ChipsInputEditText getEditText() {
        ChipsInputEditText editText = new ChipsInputEditText(this.mContext);
        if (this.mHintTextSize >= 0) {
            editText.setTextSize(0, this.mHintTextSize);
        }
        if (this.mHintColor != null) {
            editText.setHintTextColor(this.mHintColor);
        }
        if (this.mTextColor != null) {
            editText.setTextColor(this.mTextColor);
        }
        return editText;
    }

    public DetailedChipView getDetailedChipView(ChipInterface chip) {
        return new DetailedChipView.Builder(this.mContext).chip(chip).textColor(this.mChipDetailedTextColor).backgroundColor(this.mChipDetailedBackgroundColor).deleteIconColor(this.mChipDetailedDeleteIconColor).build();
    }

    public void addChipsListener(ChipsListener chipsListener) {
        this.mChipsListenerList.add(chipsListener);
        this.mChipsListener = chipsListener;
    }

    public void onChipAdded(ChipInterface chip, int size) {
        for (ChipsListener chipsListener : this.mChipsListenerList) {
            chipsListener.onChipAdded(chip, size);
        }
    }

    public void onChipRemoved(ChipInterface chip, int size) {
        for (ChipsListener chipsListener : this.mChipsListenerList) {
            chipsListener.onChipRemoved(chip, size);
        }
    }

    public void onTextChanged(CharSequence text) {
        if (this.mChipsListener != null) {
            for (ChipsListener chipsListener : this.mChipsListenerList) {
                chipsListener.onTextChanged(text);
            }
            if (this.mFilterableListView != null) {
                if (text.length() > 0) {
                    this.mFilterableListView.filterList(text);
                } else {
                    this.mFilterableListView.fadeOut();
                }
            }
        }
    }

    public List<? extends ChipInterface> getSelectedChipList() {
        return this.mChipsAdapter.getChipList();
    }

    public String getHint() {
        return this.mHint;
    }

    public void setHint(String mHint) {
        this.mHint = mHint;
    }

    public void setHintColor(ColorStateList mHintColor) {
        this.mHintColor = mHintColor;
    }

    public void setTextColor(ColorStateList mTextColor) {
        this.mTextColor = mTextColor;
    }

    public ChipsInput setMaxRows(int mMaxRows) {
        this.mMaxRows = mMaxRows;
        return this;
    }

    public void setChipLabelColor(ColorStateList mLabelColor) {
        this.mChipLabelColor = mLabelColor;
    }

    public void setChipHasAvatarIcon(boolean mHasAvatarIcon) {
        this.mChipHasAvatarIcon = mHasAvatarIcon;
    }

    public boolean chipHasAvatarIcon() {
        return this.mChipHasAvatarIcon;
    }

    public void setChipDeletable(boolean mDeletable) {
        this.mChipDeletable = mDeletable;
    }

    public void setChipDeleteIcon(Drawable mDeleteIcon) {
        this.mChipDeleteIcon = mDeleteIcon;
    }

    public void setChipDeleteIconColor(ColorStateList mDeleteIconColor) {
        this.mChipDeleteIconColor = mDeleteIconColor;
    }

    public void setChipBackgroundColor(ColorStateList mBackgroundColor) {
        this.mChipBackgroundColor = mBackgroundColor;
    }

    public ChipsInput setShowChipDetailed(boolean mShowChipDetailed) {
        this.mShowChipDetailed = mShowChipDetailed;
        return this;
    }

    public boolean isShowChipDetailed() {
        return this.mShowChipDetailed;
    }

    public void setChipDetailedTextColor(ColorStateList mChipDetailedTextColor) {
        this.mChipDetailedTextColor = mChipDetailedTextColor;
    }

    public void setChipDetailedDeleteIconColor(ColorStateList mChipDetailedDeleteIconColor) {
        this.mChipDetailedDeleteIconColor = mChipDetailedDeleteIconColor;
    }

    public void setChipDetailedBackgroundColor(ColorStateList mChipDetailedBackgroundColor) {
        this.mChipDetailedBackgroundColor = mChipDetailedBackgroundColor;
    }

    public void setFilterableList(List<? extends ChipInterface> list) {
        this.mChipList = list;
        this.mFilterableListView = new FilterableListView(this.mContext);
        this.mFilterableListView.build(this.mChipList, this, this.mFilterableListBackgroundColor, this.mFilterableListTextColor);
        this.mChipsAdapter.setFilterableListView(this.mFilterableListView);
    }

    public List<? extends ChipInterface> getFilterableList() {
        return this.mChipList;
    }

    public ChipValidator getChipValidator() {
        return this.mChipValidator;
    }

    public void setChipValidator(ChipValidator mChipValidator) {
        this.mChipValidator = mChipValidator;
    }

    public static interface ChipValidator {
        public boolean areEquals(ChipInterface var1, ChipInterface var2);
    }

    public static interface ChipsListener {
        public void onChipAdded(ChipInterface var1, int var2);

        public void onChipRemoved(ChipInterface var1, int var2);

        public void onTextChanged(CharSequence var1);
    }
}

