/*
 * Decompiled with CFR 0.152.
 */
package in.mayanknagwanshi.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import androidx.appcompat.app.AppCompatActivity;
import in.mayanknagwanshi.imagepicker.R;
import in.mayanknagwanshi.imagepicker.view.ImageCropView;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ImageCropActivity
extends AppCompatActivity {
    private ImageCropView imageCropView;
    public static final String EXTRA_FILE_PATH = "extra_file_path";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_crop);
        this.imageCropView = (ImageCropView)this.findViewById(R.id.imageCropView);
        Button buttonContinue = (Button)this.findViewById(R.id.buttonContinue);
        if (this.getIntent() != null && this.getIntent().getStringExtra(EXTRA_FILE_PATH) != null) {
            Bitmap selectedImage = BitmapFactory.decodeFile((String)this.getIntent().getStringExtra(EXTRA_FILE_PATH));
            this.imageCropView.setImageBitmap(selectedImage);
            buttonContinue.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent();
                    intent.putExtra("result_file_path", ImageCropActivity.this.getCroppedPath(ImageCropActivity.this.getIntent().getStringExtra(ImageCropActivity.EXTRA_FILE_PATH), ImageCropActivity.this.imageCropView.getCroppedGrid()));
                    ImageCropActivity.this.setResult(-1, intent);
                    ImageCropActivity.this.finish();
                }
            });
        }
    }

    private String getCroppedPath(String filePath, ImageCropView.CroppedCoordinate croppedCoordinate) {
        Bitmap selectedImage = BitmapFactory.decodeFile((String)filePath);
        Bitmap scaledBitmap = Bitmap.createBitmap((Bitmap)selectedImage, (int)croppedCoordinate.getX(), (int)croppedCoordinate.getY(), (int)croppedCoordinate.getSide(), (int)croppedCoordinate.getSide());
        try {
            FileOutputStream out = new FileOutputStream(filePath);
            scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return filePath;
    }

    public static void startActivity(Activity activity, String filePath) {
        Intent intent = new Intent((Context)activity, ImageCropActivity.class);
        intent.putExtra(EXTRA_FILE_PATH, filePath);
        intent.addFlags(0x2000000);
        activity.startActivity(intent);
        activity.finish();
    }
}

