/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.components.note;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.tools.speedlib.views.components.note.Note;

public class TextNote
extends Note<TextNote> {
    private CharSequence noteText;
    private TextPaint notePaint = new TextPaint(1);
    private float textSize = this.notePaint.getTextSize();
    private StaticLayout textLayout;

    public TextNote(Context context, CharSequence noteText) {
        super(context);
        if (noteText == null) {
            throw new IllegalArgumentException("noteText cannot be null.");
        }
        this.noteText = noteText;
        this.notePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    public void build(int viewWidth) {
        this.textLayout = new StaticLayout(this.noteText, this.notePaint, viewWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        int w = 0;
        for (int i = 0; i < this.textLayout.getLineCount(); ++i) {
            w = (int)Math.max((float)w, this.textLayout.getLineWidth(i));
        }
        this.noticeContainsSizeChange(w, this.textLayout.getHeight());
    }

    @Override
    protected void drawContains(Canvas canvas, float leftX, float topY) {
        canvas.save();
        canvas.translate(leftX, topY);
        this.textLayout.draw(canvas);
        canvas.restore();
    }

    public float getTextSize() {
        return this.textSize;
    }

    public TextNote setTextSize(float textSize) {
        this.textSize = textSize;
        this.notePaint.setTextSize(textSize);
        return this;
    }

    public TextNote setTextTypeFace(Typeface typeface) {
        this.notePaint.setTypeface(typeface);
        return this;
    }

    public int getTextColor() {
        return this.notePaint.getColor();
    }

    public TextNote setTextColor(int textColor) {
        this.notePaint.setColor(textColor);
        return this;
    }
}

