/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.components.Indicators;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.RectF;
import com.tools.speedlib.views.components.Indicators.Indicator;

public class NormalIndicator
extends Indicator<NormalIndicator> {
    private Path indicatorPath = new Path();

    public NormalIndicator(Context context) {
        super(context);
        this.updateIndicator();
    }

    @Override
    protected float getDefaultIndicatorWidth() {
        return this.dpTOpx(12.0f);
    }

    @Override
    public void draw(Canvas canvas, float degree) {
        canvas.save();
        canvas.rotate(90.0f + degree, this.getCenterX(), this.getCenterY());
        canvas.drawPath(this.indicatorPath, this.indicatorPaint);
        canvas.restore();
    }

    @Override
    protected void updateIndicator() {
        this.indicatorPath.reset();
        this.indicatorPath.moveTo(this.getCenterX(), (float)this.getPadding());
        float indicatorBottom = this.getViewSize() * 2.0f / 3.0f + (float)this.getPadding();
        this.indicatorPath.lineTo(this.getCenterX() - this.getIndicatorWidth(), indicatorBottom);
        this.indicatorPath.lineTo(this.getCenterX() + this.getIndicatorWidth(), indicatorBottom);
        RectF rectF = new RectF(this.getCenterX() - this.getIndicatorWidth(), indicatorBottom - this.getIndicatorWidth(), this.getCenterX() + this.getIndicatorWidth(), indicatorBottom + this.getIndicatorWidth());
        this.indicatorPath.addArc(rectF, 0.0f, 180.0f);
        this.indicatorPaint.setColor(this.getIndicatorColor());
    }

    @Override
    protected void setWithEffects(boolean withEffects) {
        if (withEffects && !this.isInEditMode()) {
            this.indicatorPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(15.0f, BlurMaskFilter.Blur.SOLID));
        } else {
            this.indicatorPaint.setMaskFilter(null);
        }
    }
}

