/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.components.Indicators;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import com.tools.speedlib.views.base.Speedometer;
import com.tools.speedlib.views.components.Indicators.LineIndicator;
import com.tools.speedlib.views.components.Indicators.NoIndicator;
import com.tools.speedlib.views.components.Indicators.NormalIndicator;
import com.tools.speedlib.views.components.Indicators.NormalSmallIndicator;
import com.tools.speedlib.views.components.Indicators.SpindleIndicator;
import com.tools.speedlib.views.components.Indicators.TriangleIndicator;

public abstract class Indicator<I extends Indicator> {
    protected Paint indicatorPaint = new Paint(1);
    private float density;
    private float indicatorWidth;
    private float viewSize;
    private float speedometerWidth;
    private int indicatorColor = Color.parseColor((String)"#2196F3");
    private int padding;
    private boolean inEditMode;

    protected Indicator(Context context) {
        this.density = context.getResources().getDisplayMetrics().density;
        this.init();
    }

    private void init() {
        this.indicatorPaint.setColor(this.indicatorColor);
        this.indicatorWidth = this.getDefaultIndicatorWidth();
    }

    public abstract void draw(Canvas var1, float var2);

    protected abstract void updateIndicator();

    protected abstract void setWithEffects(boolean var1);

    protected abstract float getDefaultIndicatorWidth();

    public void onSizeChange(Speedometer speedometer) {
        this.setTargetSpeedometer(speedometer);
    }

    public void setTargetSpeedometer(Speedometer speedometer) {
        this.updateData(speedometer);
        this.updateIndicator();
    }

    private void updateData(Speedometer speedometer) {
        this.viewSize = speedometer.getSize();
        this.speedometerWidth = speedometer.getSpeedometerWidth();
        this.padding = speedometer.getPadding();
        this.inEditMode = speedometer.isInEditMode();
    }

    public float dpTOpx(float dp) {
        return dp * this.density;
    }

    public float getIndicatorWidth() {
        return this.indicatorWidth;
    }

    public I setIndicatorWidth(float indicatorWidth) {
        this.indicatorWidth = indicatorWidth;
        return (I)this;
    }

    public float getViewSize() {
        return this.viewSize - (float)this.padding * 2.0f;
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public I setIndicatorColor(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        return (I)this;
    }

    public float getCenterX() {
        return this.viewSize / 2.0f;
    }

    public float getCenterY() {
        return this.viewSize / 2.0f;
    }

    public int getPadding() {
        return this.padding;
    }

    public float getSpeedometerWidth() {
        return this.speedometerWidth;
    }

    public void noticeIndicatorWidthChange(float indicatorWidth) {
        this.indicatorWidth = indicatorWidth;
        this.updateIndicator();
    }

    public void noticeIndicatorColorChange(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        this.updateIndicator();
    }

    public void noticeSpeedometerWidthChange(float speedometerWidth) {
        this.speedometerWidth = speedometerWidth;
        this.updateIndicator();
    }

    public void noticePaddingChange(int newPadding) {
        this.padding = newPadding;
        this.updateIndicator();
    }

    public void withEffects(boolean withEffects) {
        this.setWithEffects(withEffects);
        this.updateIndicator();
    }

    public boolean isInEditMode() {
        return this.inEditMode;
    }

    public static Indicator createIndicator(Context context, Indicators indicator) {
        switch (indicator) {
            case NoIndicator: {
                return new NoIndicator(context);
            }
            case NormalIndicator: {
                return new NormalIndicator(context);
            }
            case NormalSmallIndicator: {
                return new NormalSmallIndicator(context);
            }
            case TriangleIndicator: {
                return new TriangleIndicator(context);
            }
            case SpindleIndicator: {
                return new SpindleIndicator(context);
            }
            case LineIndicator: {
                return new LineIndicator(context, 1.0f);
            }
            case HalfLineIndicator: {
                return new LineIndicator(context, 0.5f);
            }
            case QuarterLineIndicator: {
                return new LineIndicator(context, 0.25f);
            }
        }
        return new NormalIndicator(context);
    }

    public static enum Indicators {
        NoIndicator,
        NormalIndicator,
        NormalSmallIndicator,
        TriangleIndicator,
        SpindleIndicator,
        LineIndicator,
        HalfLineIndicator,
        QuarterLineIndicator;

    }
}

