/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import com.tools.speedlib.R;
import com.tools.speedlib.views.base.Gauge;

public abstract class LinearGauge
extends Gauge {
    private Paint paint = new Paint(1);
    private Rect rect = new Rect();
    private Bitmap foregroundBitmap;
    private Orientation orientation = Orientation.HORIZONTAL;

    public LinearGauge(Context context) {
        this(context, null);
    }

    public LinearGauge(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LinearGauge(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttributeSet(context, attrs);
    }

    protected abstract void updateFrontAndBackBitmaps();

    private void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.LinearGauge, 0, 0);
        int orientation = a.getInt(R.styleable.LinearGauge_sv_orientation, -1);
        if (orientation != -1) {
            this.setOrientation(Orientation.values()[orientation]);
        }
        a.recycle();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.updateBackgroundBitmap();
    }

    @Override
    protected void updateBackgroundBitmap() {
        this.updateFrontAndBackBitmaps();
    }

    protected final Canvas createForegroundBitmapCanvas() {
        if (this.getWidthPa() == 0 || this.getHeightPa() == 0) {
            return new Canvas();
        }
        this.foregroundBitmap = Bitmap.createBitmap((int)this.getWidthPa(), (int)this.getHeightPa(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return new Canvas(this.foregroundBitmap);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.orientation == Orientation.HORIZONTAL) {
            this.rect.set(0, 0, (int)((float)this.getWidthPa() * this.getOffsetSpeed()), this.getHeightPa());
        } else {
            this.rect.set(0, this.getHeightPa() - (int)((float)this.getHeightPa() * this.getOffsetSpeed()), this.getWidthPa(), this.getHeightPa());
        }
        canvas.translate((float)this.getPadding(), (float)this.getPadding());
        canvas.drawBitmap(this.foregroundBitmap, this.rect, this.rect, this.paint);
        canvas.translate((float)(-this.getPadding()), (float)(-this.getPadding()));
        this.drawSpeedUnitText(canvas);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.requestLayout();
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

