/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.base;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.tools.speedlib.R;
import com.tools.speedlib.views.util.OnSectionChangeListener;
import com.tools.speedlib.views.util.OnSpeedChangeListener;
import java.util.Locale;
import java.util.Random;

public abstract class Gauge
extends View {
    private Paint speedUnitTextBitmapPaint = new Paint(1);
    protected TextPaint textPaint = new TextPaint(1);
    private TextPaint speedTextPaint = new TextPaint(1);
    private TextPaint unitTextPaint = new TextPaint(1);
    private String unit = "KB/S";
    private boolean withTremble = true;
    private String currentSpeed = "0.00";
    private int maxSpeed = 100;
    private int minSpeed = 0;
    private float speed = this.minSpeed;
    private int correctIntSpeed = 0;
    private float correctSpeed = 0.0f;
    private float trembleDegree = 4.0f;
    private int trembleDuration = 1000;
    private ValueAnimator speedAnimator;
    private ValueAnimator trembleAnimator;
    private ValueAnimator realSpeedAnimator;
    private boolean canceled = false;
    private OnSpeedChangeListener onSpeedChangeListener;
    private OnSectionChangeListener onSectionChangeListener;
    private Animator.AnimatorListener animatorListener;
    protected Bitmap backgroundBitmap;
    private Paint backgroundBitmapPaint = new Paint(1);
    private int padding = 0;
    private int widthPa = 0;
    private int heightPa = 0;
    private int lowSpeedPercent = 60;
    private int mediumSpeedPercent = 87;
    public static final byte LOW_SECTION = 1;
    public static final byte MEDIUM_SECTION = 2;
    public static final byte HIGH_SECTION = 3;
    private byte section = 1;
    private boolean speedometerTextRightToLeft = false;
    private boolean attachedToWindow = false;
    protected float translatedDx = 0.0f;
    protected float translatedDy = 0.0f;
    private Locale locale = Locale.getDefault();
    private float accelerate = 0.1f;
    private float decelerate = 0.1f;
    private Position speedTextPosition = Position.BOTTOM_CENTER;
    private float unitSpeedInterval = this.dpTOpx(1.0f);
    private float speedTextPadding = this.dpTOpx(20.0f);
    private boolean unitUnderSpeedText = true;
    private Bitmap speedUnitTextBitmap;
    public static final byte INTEGER_FORMAT = 0;
    public static final byte FLOAT_FORMAT = 1;
    private byte speedTextFormat = 1;

    public Gauge(Context context) {
        this(context, null);
    }

    public Gauge(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Gauge(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.initAttributeSet(context, attrs);
        this.initAttributeValue();
    }

    private void init() {
        this.textPaint.setColor(-16777216);
        this.textPaint.setTextSize(this.dpTOpx(10.0f));
        this.speedTextPaint.setColor(-16777216);
        this.speedTextPaint.setTextSize(this.dpTOpx(18.0f));
        this.unitTextPaint.setColor(-16777216);
        this.unitTextPaint.setTextSize(this.dpTOpx(15.0f));
        if (Build.VERSION.SDK_INT >= 11) {
            this.speedAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.trembleAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.realSpeedAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.animatorListener = new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            };
        }
        this.defaultValues();
    }

    private void initAttributeSet(Context context, AttributeSet attrs) {
        byte format;
        int position;
        String typefacePath;
        if (attrs == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Gauge, 0, 0);
        this.maxSpeed = a.getInt(R.styleable.Gauge_sv_maxSpeed, this.maxSpeed);
        this.minSpeed = a.getInt(R.styleable.Gauge_sv_minSpeed, this.minSpeed);
        this.withTremble = a.getBoolean(R.styleable.Gauge_sv_withTremble, this.withTremble);
        this.textPaint.setColor(a.getColor(R.styleable.Gauge_sv_textColor, this.textPaint.getColor()));
        this.textPaint.setTextSize(a.getDimension(R.styleable.Gauge_sv_textSize, this.textPaint.getTextSize()));
        this.speedTextPaint.setColor(a.getColor(R.styleable.Gauge_sv_speedTextColor, this.speedTextPaint.getColor()));
        this.speedTextPaint.setTextSize(a.getDimension(R.styleable.Gauge_sv_speedTextSize, this.speedTextPaint.getTextSize()));
        this.unitTextPaint.setColor(a.getColor(R.styleable.Gauge_sv_unitTextColor, this.unitTextPaint.getColor()));
        this.unitTextPaint.setTextSize(a.getDimension(R.styleable.Gauge_sv_unitTextSize, this.unitTextPaint.getTextSize()));
        String unit = a.getString(R.styleable.Gauge_sv_unit);
        this.unit = unit != null ? unit : this.unit;
        this.trembleDegree = a.getFloat(R.styleable.Gauge_sv_trembleDegree, this.trembleDegree);
        this.trembleDuration = a.getInt(R.styleable.Gauge_sv_trembleDuration, this.trembleDuration);
        this.lowSpeedPercent = a.getInt(R.styleable.Gauge_sv_lowSpeedPercent, this.lowSpeedPercent);
        this.mediumSpeedPercent = a.getInt(R.styleable.Gauge_sv_mediumSpeedPercent, this.mediumSpeedPercent);
        this.speedometerTextRightToLeft = a.getBoolean(R.styleable.Gauge_sv_textRightToLeft, this.speedometerTextRightToLeft);
        this.accelerate = a.getFloat(R.styleable.Gauge_sv_accelerate, this.accelerate);
        this.decelerate = a.getFloat(R.styleable.Gauge_sv_decelerate, this.decelerate);
        this.unitUnderSpeedText = a.getBoolean(R.styleable.Gauge_sv_unitUnderSpeedText, this.unitUnderSpeedText);
        this.unitSpeedInterval = a.getDimension(R.styleable.Gauge_sv_unitSpeedInterval, this.unitSpeedInterval);
        this.speedTextPadding = a.getDimension(R.styleable.Gauge_sv_speedTextPadding, this.speedTextPadding);
        String speedTypefacePath = a.getString(R.styleable.Gauge_sv_speedTextTypeface);
        if (speedTypefacePath != null) {
            this.setSpeedTextTypeface(Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)speedTypefacePath));
        }
        if ((typefacePath = a.getString(R.styleable.Gauge_sv_textTypeface)) != null) {
            this.setTextTypeface(Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)typefacePath));
        }
        if ((position = a.getInt(R.styleable.Gauge_sv_speedTextPosition, -1)) != -1) {
            this.setSpeedTextPosition(Position.values()[position]);
        }
        if ((format = (byte)a.getInt(R.styleable.Gauge_sv_speedTextFormat, -1)) != -1) {
            this.setSpeedTextFormat(format);
        }
        a.recycle();
        this.checkSpeedometerPercent();
        this.checkAccelerate();
        this.checkDecelerate();
        this.checkTrembleData();
    }

    private void initAttributeValue() {
        if (this.unitUnderSpeedText) {
            this.speedTextPaint.setTextAlign(Paint.Align.CENTER);
            this.unitTextPaint.setTextAlign(Paint.Align.CENTER);
        } else {
            this.speedTextPaint.setTextAlign(Paint.Align.LEFT);
            this.unitTextPaint.setTextAlign(Paint.Align.LEFT);
        }
        this.recreateSpeedUnitTextBitmap();
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.updatePadding();
    }

    private void checkSpeedometerPercent() {
        if (this.lowSpeedPercent > this.mediumSpeedPercent) {
            throw new IllegalArgumentException("lowSpeedPercent must be smaller than mediumSpeedPercent");
        }
        if (this.lowSpeedPercent > 100 || this.lowSpeedPercent < 0) {
            throw new IllegalArgumentException("lowSpeedPercent must be between [0, 100]");
        }
        if (this.mediumSpeedPercent > 100 || this.mediumSpeedPercent < 0) {
            throw new IllegalArgumentException("mediumSpeedPercent must be between [0, 100]");
        }
    }

    private void checkAccelerate() {
        if (this.accelerate > 1.0f || this.accelerate <= 0.0f) {
            throw new IllegalArgumentException("accelerate must be between (0, 1]");
        }
    }

    private void checkDecelerate() {
        if (this.decelerate > 1.0f || this.decelerate <= 0.0f) {
            throw new IllegalArgumentException("decelerate must be between (0, 1]");
        }
    }

    private void checkTrembleData() {
        if (this.trembleDegree < 0.0f) {
            throw new IllegalArgumentException("trembleDegree  can't be Negative");
        }
        if (this.trembleDuration < 0) {
            throw new IllegalArgumentException("trembleDuration  can't be Negative");
        }
    }

    public float dpTOpx(float dp) {
        return dp * this.getContext().getResources().getDisplayMetrics().density;
    }

    public float pxTOdp(float px) {
        return px / this.getContext().getResources().getDisplayMetrics().density;
    }

    protected abstract void defaultValues();

    protected abstract void updateBackgroundBitmap();

    private void updatePadding() {
        this.padding = Math.max(Math.max(this.getPaddingLeft(), this.getPaddingRight()), Math.max(this.getPaddingTop(), this.getPaddingBottom()));
        this.widthPa = this.getWidth() - this.padding * 2;
        this.heightPa = this.getHeight() - this.padding * 2;
        super.setPadding(this.padding, this.padding, this.padding, this.padding);
        if (Build.VERSION.SDK_INT >= 17) {
            super.setPaddingRelative(this.padding, this.padding, this.padding, this.padding);
        }
    }

    protected void onDraw(Canvas canvas) {
        byte newSection;
        int newSpeed;
        canvas.translate(this.translatedDx, this.translatedDy);
        if (this.backgroundBitmap != null) {
            canvas.drawBitmap(this.backgroundBitmap, 0.0f, 0.0f, this.backgroundBitmapPaint);
        }
        if ((newSpeed = (int)this.correctSpeed) != this.correctIntSpeed) {
            if (this.onSpeedChangeListener != null) {
                int update;
                boolean isSpeedUp = newSpeed > this.correctIntSpeed;
                int n = update = isSpeedUp ? 1 : -1;
                while (this.correctIntSpeed != newSpeed) {
                    this.correctIntSpeed += update;
                    boolean byTremble = false;
                    if (Build.VERSION.SDK_INT >= 11) {
                        byTremble = this.trembleAnimator.isRunning();
                    }
                    this.onSpeedChangeListener.onSpeedChange(this, isSpeedUp, byTremble);
                }
            } else {
                this.correctIntSpeed = newSpeed;
            }
        }
        if (this.section != (newSection = this.getSection())) {
            this.onSectionChangeEvent(this.section, newSection);
            this.section = newSection;
        }
    }

    protected void drawSpeedUnitText(Canvas canvas) {
        RectF r = this.getSpeedUnitTextBounds();
        canvas.drawBitmap(this.updateSpeedUnitTextBitmap(), r.left, r.top, this.speedUnitTextBitmapPaint);
    }

    private void recreateSpeedUnitTextBitmap() {
        this.speedUnitTextBitmap = Bitmap.createBitmap((int)((int)this.getMaxWidthForSpeedUnitText()), (int)((int)this.getSpeedUnitTextHeight()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    private Bitmap updateSpeedUnitTextBitmap() {
        this.speedUnitTextBitmap.eraseColor(0);
        Canvas c = new Canvas(this.speedUnitTextBitmap);
        if (this.unitUnderSpeedText) {
            c.drawText(this.getSpeedText(), (float)this.speedUnitTextBitmap.getWidth() * 0.5f, this.speedTextPaint.getTextSize(), (Paint)this.speedTextPaint);
            c.drawText(this.getUnit(), (float)this.speedUnitTextBitmap.getWidth() * 0.5f, this.speedTextPaint.getTextSize() + this.unitSpeedInterval + this.unitTextPaint.getTextSize(), (Paint)this.unitTextPaint);
            return this.speedUnitTextBitmap;
        }
        float speedX = 0.0f;
        float unitX = this.speedTextPaint.measureText(this.getSpeedText()) + this.unitSpeedInterval;
        if (this.isSpeedometerTextRightToLeft()) {
            speedX = this.unitTextPaint.measureText(this.getUnit()) + this.unitSpeedInterval;
            unitX = 0.0f;
        }
        c.drawText(this.getSpeedText(), speedX, (float)c.getHeight() - 0.1f, (Paint)this.speedTextPaint);
        c.drawText(this.getUnit(), unitX, (float)c.getHeight() - 0.1f, (Paint)this.unitTextPaint);
        return this.speedUnitTextBitmap;
    }

    protected RectF getSpeedUnitTextBounds() {
        float left = (float)this.getWidthPa() * this.speedTextPosition.x - this.translatedDx + (float)this.padding - (float)this.speedUnitTextBitmap.getWidth() * this.speedTextPosition.width + this.speedTextPadding * (float)this.speedTextPosition.paddingH;
        float top = (float)this.getHeightPa() * this.speedTextPosition.y - this.translatedDy + (float)this.padding - (float)this.speedUnitTextBitmap.getHeight() * this.speedTextPosition.height + this.speedTextPadding * (float)this.speedTextPosition.paddingV;
        return new RectF(left, top, left + this.getSpeedUnitTextWidth(), top + this.getSpeedUnitTextHeight());
    }

    private float getMaxWidthForSpeedUnitText() {
        String speedUnitText;
        String string = speedUnitText = this.speedTextFormat == 1 ? String.format(this.locale, "%.2f", Float.valueOf((float)this.maxSpeed * 10.0f)) : String.format(this.locale, "%d", this.maxSpeed * 10);
        if (this.unitUnderSpeedText) {
            return Math.max(this.speedTextPaint.measureText(speedUnitText), this.unitTextPaint.measureText(this.getUnit()));
        }
        return this.speedTextPaint.measureText(speedUnitText) + this.unitTextPaint.measureText(this.getUnit()) + this.unitSpeedInterval;
    }

    private float getSpeedUnitTextWidth() {
        if (this.unitUnderSpeedText) {
            return Math.max(this.speedTextPaint.measureText(this.getSpeedText()), this.unitTextPaint.measureText(this.getUnit()));
        }
        return this.speedTextPaint.measureText(this.getSpeedText()) + this.unitTextPaint.measureText(this.getUnit()) + this.unitSpeedInterval;
    }

    private float getSpeedUnitTextHeight() {
        if (this.unitUnderSpeedText) {
            return this.speedTextPaint.getTextSize() + this.unitTextPaint.getTextSize() + this.unitSpeedInterval;
        }
        return Math.max(this.speedTextPaint.getTextSize(), this.unitTextPaint.getTextSize());
    }

    protected Canvas createBackgroundBitmapCanvas() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return new Canvas();
        }
        this.backgroundBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return new Canvas(this.backgroundBitmap);
    }

    protected void onSectionChangeEvent(byte oldSection, byte newSection) {
        if (this.onSectionChangeListener != null) {
            this.onSectionChangeListener.onSectionChangeListener(oldSection, newSection);
        }
    }

    @TargetApi(value=11)
    public void stop() {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        if (!this.speedAnimator.isRunning() && !this.realSpeedAnimator.isRunning()) {
            return;
        }
        this.speed = this.correctSpeed;
        this.cancelSpeedAnimator();
        this.tremble();
    }

    protected void cancelSpeedAnimator() {
        this.cancelSpeedMove();
        this.cancelTremble();
    }

    @TargetApi(value=11)
    private void cancelTremble() {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        this.canceled = true;
        this.trembleAnimator.cancel();
        this.canceled = false;
    }

    @TargetApi(value=11)
    private void cancelSpeedMove() {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        this.canceled = true;
        this.speedAnimator.cancel();
        this.realSpeedAnimator.cancel();
        this.canceled = false;
    }

    public void setSpeedAt(float speed) {
        this.speed = speed = speed > (float)this.maxSpeed ? (float)this.maxSpeed : (speed < (float)this.minSpeed ? (float)this.minSpeed : speed);
        this.correctSpeed = speed;
        this.cancelSpeedAnimator();
        this.invalidate();
        this.tremble();
    }

    public void speedPercentTo(int percent) {
        this.speedPercentTo(percent, 2000L);
    }

    public void speedPercentTo(int percent, long moveDuration) {
        this.speedTo(this.getSpeedValue(percent), moveDuration);
    }

    public void speedTo(float speed) {
        this.speedTo(speed, 2000L);
    }

    @TargetApi(value=11)
    public void speedTo(float speed, long moveDuration) {
        float f = speed > (float)this.maxSpeed ? (float)this.maxSpeed : (speed = speed < (float)this.minSpeed ? (float)this.minSpeed : speed);
        if (speed == this.speed) {
            return;
        }
        this.speed = speed;
        if (Build.VERSION.SDK_INT < 11) {
            this.setSpeedAt(speed);
            return;
        }
        this.cancelSpeedAnimator();
        this.speedAnimator = ValueAnimator.ofFloat((float[])new float[]{this.correctSpeed, speed});
        this.speedAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.speedAnimator.setDuration(moveDuration);
        this.speedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Gauge.this.correctSpeed = ((Float)Gauge.this.speedAnimator.getAnimatedValue()).floatValue();
                Gauge.this.postInvalidate();
            }
        });
        this.speedAnimator.addListener(this.animatorListener);
        this.speedAnimator.start();
    }

    public void speedUp() {
        this.realSpeedTo(this.getMaxSpeed());
    }

    public void slowDown() {
        this.realSpeedTo(0.0f);
    }

    public void realSpeedPercentTo(float percent) {
        this.realSpeedTo(this.getSpeedValue(percent));
    }

    @TargetApi(value=11)
    public void realSpeedTo(float speed) {
        boolean isSpeedUp;
        boolean oldIsSpeedUp;
        boolean bl = oldIsSpeedUp = this.speed > this.correctSpeed;
        float f = speed > (float)this.maxSpeed ? (float)this.maxSpeed : (speed = speed < (float)this.minSpeed ? (float)this.minSpeed : speed);
        if (speed == this.speed) {
            return;
        }
        this.speed = speed;
        if (Build.VERSION.SDK_INT < 11) {
            this.setSpeedAt(speed);
            return;
        }
        boolean bl2 = isSpeedUp = speed > this.correctSpeed;
        if (this.realSpeedAnimator.isRunning() && oldIsSpeedUp == isSpeedUp) {
            return;
        }
        this.cancelSpeedAnimator();
        this.realSpeedAnimator = ValueAnimator.ofInt((int[])new int[]{(int)this.correctSpeed, (int)speed});
        this.realSpeedAnimator.setRepeatCount(-1);
        this.realSpeedAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.realSpeedAnimator.setDuration(Math.abs((long)((speed - this.correctSpeed) * 10.0f)));
        final float finalSpeed = speed;
        this.realSpeedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (isSpeedUp) {
                    float per = 100.005f - Gauge.this.getPercentSpeed();
                    Gauge.this.correctSpeed = Gauge.this.correctSpeed + Gauge.this.accelerate * 10.0f * per * 0.01f;
                    if (Gauge.this.correctSpeed > finalSpeed) {
                        Gauge.this.correctSpeed = finalSpeed;
                    }
                } else {
                    float per = Gauge.this.getPercentSpeed() + 0.005f;
                    Gauge.this.correctSpeed = Gauge.this.correctSpeed - (Gauge.this.decelerate * 10.0f * per * 0.01f + 0.1f);
                    if (Gauge.this.correctSpeed < finalSpeed) {
                        Gauge.this.correctSpeed = finalSpeed;
                    }
                }
                Gauge.this.postInvalidate();
                if (finalSpeed == Gauge.this.correctSpeed) {
                    Gauge.this.stop();
                }
            }
        });
        this.realSpeedAnimator.addListener(this.animatorListener);
        this.realSpeedAnimator.start();
    }

    @TargetApi(value=11)
    protected void tremble() {
        this.cancelTremble();
        if (!this.isWithTremble() || Build.VERSION.SDK_INT < 11) {
            return;
        }
        Random random = new Random();
        float mad = this.trembleDegree * random.nextFloat() * (float)(random.nextBoolean() ? -1 : 1);
        mad = this.speed + mad > (float)this.maxSpeed ? (float)this.maxSpeed - this.speed : (this.speed + mad < (float)this.minSpeed ? (float)this.minSpeed - this.speed : mad);
        this.trembleAnimator = ValueAnimator.ofFloat((float[])new float[]{this.correctSpeed, this.speed + mad});
        this.trembleAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.trembleAnimator.setDuration((long)this.trembleDuration);
        this.trembleAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Gauge.this.correctSpeed = ((Float)Gauge.this.trembleAnimator.getAnimatedValue()).floatValue();
                Gauge.this.postInvalidate();
            }
        });
        this.trembleAnimator.addListener(this.animatorListener);
        this.trembleAnimator.start();
    }

    private float getSpeedValue(float percentSpeed) {
        percentSpeed = percentSpeed > 100.0f ? 100.0f : (percentSpeed < 0.0f ? 0.0f : percentSpeed);
        return percentSpeed * (float)(this.maxSpeed - this.minSpeed) * 0.01f + (float)this.minSpeed;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.attachedToWindow = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelSpeedAnimator();
        this.attachedToWindow = false;
    }

    public void setTrembleDegree(float trembleDegree) {
        this.setTrembleData(trembleDegree, this.trembleDuration);
    }

    public void setTrembleDuration(int trembleDuration) {
        this.setTrembleData(this.trembleDegree, trembleDuration);
    }

    public void setTrembleData(float trembleDegree, int trembleDuration) {
        this.trembleDegree = trembleDegree;
        this.trembleDuration = trembleDuration;
        this.checkTrembleData();
    }

    public byte getSpeedTextFormat() {
        return this.speedTextFormat;
    }

    public void setSpeedTextFormat(byte speedTextFormat) {
        this.speedTextFormat = speedTextFormat;
        this.recreateSpeedUnitTextBitmap();
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public void setCurrentSpeed(String speed) {
        this.currentSpeed = speed;
    }

    protected String getSpeedText() {
        return this.currentSpeed;
    }

    protected String getMaxSpeedText() {
        return String.format(this.locale, "%d", this.maxSpeed);
    }

    protected String getMinSpeedText() {
        return String.format(this.locale, "%d", this.minSpeed);
    }

    public void setWithTremble(boolean withTremble) {
        this.withTremble = withTremble;
        this.tremble();
    }

    public boolean isWithTremble() {
        return this.withTremble;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getCorrectSpeed() {
        return this.correctSpeed;
    }

    public int getCorrectIntSpeed() {
        return this.correctIntSpeed;
    }

    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(int maxSpeed) {
        if (maxSpeed <= this.minSpeed) {
            return;
        }
        this.maxSpeed = maxSpeed;
        this.recreateSpeedUnitTextBitmap();
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.speedTo(this.speed);
    }

    public int getMinSpeed() {
        return this.minSpeed;
    }

    public void setMinSpeed(int minSpeed) {
        if (minSpeed >= this.maxSpeed) {
            return;
        }
        this.minSpeed = minSpeed;
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.speedTo(this.speed);
    }

    public float getPercentSpeed() {
        return (this.correctSpeed - (float)this.minSpeed) * 100.0f / (float)(this.maxSpeed - this.minSpeed);
    }

    public float getOffsetSpeed() {
        return (this.correctSpeed - (float)this.minSpeed) / (float)(this.maxSpeed - this.minSpeed);
    }

    public int getTextColor() {
        return this.textPaint.getColor();
    }

    public void setTextColor(int textColor) {
        this.textPaint.setColor(textColor);
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public int getSpeedTextColor() {
        return this.speedTextPaint.getColor();
    }

    public void setSpeedTextColor(int speedTextColor) {
        this.speedTextPaint.setColor(speedTextColor);
        if (!this.attachedToWindow) {
            return;
        }
        this.invalidate();
    }

    public int getUnitTextColor() {
        return this.unitTextPaint.getColor();
    }

    public void setUnitTextColor(int unitTextColor) {
        this.unitTextPaint.setColor(unitTextColor);
        if (!this.attachedToWindow) {
            return;
        }
        this.invalidate();
    }

    public float getTextSize() {
        return this.textPaint.getTextSize();
    }

    public void setTextSize(float textSize) {
        this.textPaint.setTextSize(textSize);
        if (!this.attachedToWindow) {
            return;
        }
        this.invalidate();
    }

    public float getSpeedTextSize() {
        return this.speedTextPaint.getTextSize();
    }

    public void setSpeedTextSize(float speedTextSize) {
        this.speedTextPaint.setTextSize(speedTextSize);
        this.recreateSpeedUnitTextBitmap();
        if (!this.attachedToWindow) {
            return;
        }
        this.invalidate();
    }

    public float getUnitTextSize() {
        return this.unitTextPaint.getTextSize();
    }

    public void setUnitTextSize(float unitTextSize) {
        this.unitTextPaint.setTextSize(unitTextSize);
        this.recreateSpeedUnitTextBitmap();
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
        this.recreateSpeedUnitTextBitmap();
        if (!this.attachedToWindow) {
            return;
        }
        this.invalidate();
    }

    public void setOnSpeedChangeListener(OnSpeedChangeListener onSpeedChangeListener) {
        this.onSpeedChangeListener = onSpeedChangeListener;
    }

    public void setOnSectionChangeListener(OnSectionChangeListener onSectionChangeListener) {
        this.onSectionChangeListener = onSectionChangeListener;
    }

    public int getLowSpeedPercent() {
        return this.lowSpeedPercent;
    }

    public float getLowSpeedOffset() {
        return (float)this.lowSpeedPercent * 0.01f;
    }

    public void setLowSpeedPercent(int lowSpeedPercent) {
        this.lowSpeedPercent = lowSpeedPercent;
        this.checkSpeedometerPercent();
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public int getMediumSpeedPercent() {
        return this.mediumSpeedPercent;
    }

    public float getMediumSpeedOffset() {
        return (float)this.mediumSpeedPercent * 0.01f;
    }

    public void setMediumSpeedPercent(int mediumSpeedPercent) {
        this.mediumSpeedPercent = mediumSpeedPercent;
        this.checkSpeedometerPercent();
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public boolean isSpeedometerTextRightToLeft() {
        return this.speedometerTextRightToLeft;
    }

    public void setSpeedometerTextRightToLeft(boolean speedometerTextRightToLeft) {
        this.speedometerTextRightToLeft = speedometerTextRightToLeft;
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public int getWidthPa() {
        return this.widthPa;
    }

    public int getHeightPa() {
        return this.heightPa;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.updatePadding();
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        super.setPaddingRelative(start, top, end, bottom);
        this.updatePadding();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (!this.attachedToWindow) {
            return;
        }
        this.invalidate();
    }

    public boolean isInLowSection() {
        return (float)(this.maxSpeed - this.minSpeed) * this.getLowSpeedOffset() + (float)this.minSpeed >= this.correctSpeed;
    }

    public boolean isInMediumSection() {
        return (float)(this.maxSpeed - this.minSpeed) * this.getMediumSpeedOffset() + (float)this.minSpeed >= this.correctSpeed && !this.isInLowSection();
    }

    public boolean isInHighSection() {
        return this.correctSpeed > (float)(this.maxSpeed - this.minSpeed) * this.getMediumSpeedOffset() + (float)this.minSpeed;
    }

    public byte getSection() {
        if (this.isInLowSection()) {
            return 1;
        }
        if (this.isInMediumSection()) {
            return 2;
        }
        return 3;
    }

    public int getPadding() {
        return this.padding;
    }

    public boolean isAttachedToWindow() {
        return this.attachedToWindow;
    }

    public Typeface getSpeedTextTypeface() {
        return this.speedTextPaint.getTypeface();
    }

    public void setSpeedTextTypeface(Typeface typeface) {
        this.speedTextPaint.setTypeface(typeface);
        this.unitTextPaint.setTypeface(typeface);
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public Typeface getTextTypeface() {
        return this.textPaint.getTypeface();
    }

    public void setTextTypeface(Typeface typeface) {
        this.textPaint.setTypeface(typeface);
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public float getAccelerate() {
        return this.accelerate;
    }

    public void setAccelerate(float accelerate) {
        this.accelerate = accelerate;
        this.checkAccelerate();
    }

    public float getDecelerate() {
        return this.decelerate;
    }

    public void setDecelerate(float decelerate) {
        this.decelerate = decelerate;
    }

    protected final float getTranslatedDx() {
        return this.translatedDx;
    }

    protected final float getTranslatedDy() {
        return this.translatedDy;
    }

    public float getUnitSpeedInterval() {
        return this.unitSpeedInterval;
    }

    public void setUnitSpeedInterval(float unitSpeedInterval) {
        this.unitSpeedInterval = unitSpeedInterval;
        this.recreateSpeedUnitTextBitmap();
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public float getSpeedTextPadding() {
        return this.speedTextPadding;
    }

    public void setSpeedTextPadding(float speedTextPadding) {
        this.speedTextPadding = speedTextPadding;
        if (!this.attachedToWindow) {
            return;
        }
        this.invalidate();
    }

    public boolean isUnitUnderSpeedText() {
        return this.unitUnderSpeedText;
    }

    public void setUnitUnderSpeedText(boolean unitUnderSpeedText) {
        this.unitUnderSpeedText = unitUnderSpeedText;
        if (unitUnderSpeedText) {
            this.speedTextPaint.setTextAlign(Paint.Align.CENTER);
            this.unitTextPaint.setTextAlign(Paint.Align.CENTER);
        } else {
            this.speedTextPaint.setTextAlign(Paint.Align.LEFT);
            this.unitTextPaint.setTextAlign(Paint.Align.LEFT);
        }
        this.recreateSpeedUnitTextBitmap();
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public void setSpeedTextPosition(Position position) {
        this.speedTextPosition = position;
        if (!this.attachedToWindow) {
            return;
        }
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public static enum Position {
        TOP_LEFT(0.0f, 0.0f, 0.0f, 0.0f, 1, 1),
        TOP_CENTER(0.5f, 0.0f, 0.5f, 0.0f, 0, 1),
        TOP_RIGHT(1.0f, 0.0f, 1.0f, 0.0f, -1, 1),
        LEFT(0.0f, 0.5f, 0.0f, 0.5f, 1, 0),
        CENTER(0.5f, 0.5f, 0.5f, 0.5f, 0, 0),
        RIGHT(1.0f, 0.5f, 1.0f, 0.5f, -1, 0),
        BOTTOM_LEFT(0.0f, 1.0f, 0.0f, 1.0f, 1, -1),
        BOTTOM_CENTER(0.5f, 1.0f, 0.5f, 1.0f, 0, -1),
        BOTTOM_RIGHT(1.0f, 1.0f, 1.0f, 1.0f, -1, -1);

        final float x;
        final float y;
        final float width;
        final float height;
        final int paddingH;
        final int paddingV;

        private Position(float x, float y, float width, float height, int paddingH, int paddingV) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.paddingH = paddingH;
            this.paddingV = paddingV;
        }
    }
}

