/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.util.AttributeSet;
import com.tools.speedlib.R;
import com.tools.speedlib.views.base.Gauge;
import com.tools.speedlib.views.base.Speedometer;
import com.tools.speedlib.views.base.SpeedometerDefault;
import com.tools.speedlib.views.components.Indicators.TriangleIndicator;

public class AwesomeSpeedView
extends Speedometer {
    private Path markPath = new Path();
    private Path trianglesPath = new Path();
    private Paint markPaint = new Paint(1);
    private Paint ringPaint = new Paint(1);
    private Paint trianglesPaint = new Paint(1);
    private RectF speedometerRect = new RectF();
    private int speedometerColor = Color.parseColor((String)"#0072ff");

    public AwesomeSpeedView(Context context) {
        this(context, null);
    }

    public AwesomeSpeedView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AwesomeSpeedView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.initAttributeSet(context, attrs);
    }

    @Override
    protected void defaultValues() {
        super.setTextColor(Color.parseColor((String)"#ffc260"));
        super.setSpeedTextColor(-1);
        super.setUnitTextColor(-1);
        super.setTextTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        super.setSpeedTextPosition(Gauge.Position.CENTER);
        super.setUnitUnderSpeedText(true);
    }

    @Override
    protected SpeedometerDefault getSpeedometerDefault() {
        SpeedometerDefault speedometerDefault = new SpeedometerDefault();
        speedometerDefault.indicator = ((TriangleIndicator)new TriangleIndicator(this.getContext()).setIndicatorWidth(this.dpTOpx(30.0f))).setIndicatorColor(Color.parseColor((String)"#ffff00"));
        speedometerDefault.startDegree = 135;
        speedometerDefault.endDegree = 455;
        speedometerDefault.speedometerWidth = this.dpTOpx(60.0f);
        speedometerDefault.backgroundCircleColor = Color.parseColor((String)"#ffff00");
        speedometerDefault.backgroundCircleColor = Color.parseColor((String)"#212121");
        return speedometerDefault;
    }

    private void init() {
        this.markPaint.setStyle(Paint.Style.STROKE);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.ringPaint.setStyle(Paint.Style.STROKE);
        this.textPaint.setTextSize(this.dpTOpx(18.0f));
        this.trianglesPaint.setColor(Color.parseColor((String)"#ffff00"));
    }

    private void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AwesomeSpeedView, 0, 0);
        this.speedometerColor = a.getColor(R.styleable.AwesomeSpeedView_sv_speedometerColor, this.speedometerColor);
        this.trianglesPaint.setColor(a.getColor(R.styleable.AwesomeSpeedView_sv_trianglesColor, this.trianglesPaint.getColor()));
        a.recycle();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.updateGradient();
        this.updateBackgroundBitmap();
    }

    private void updateGradient() {
        float stop = ((float)this.getWidthPa() * 0.5f - this.getSpeedometerWidth()) / ((float)this.getWidthPa() * 0.5f);
        float stop2 = stop + (1.0f - stop) * 0.1f;
        float stop3 = stop + (1.0f - stop) * 0.36f;
        float stop4 = stop + (1.0f - stop) * 0.64f;
        float stop5 = stop + (1.0f - stop) * 0.9f;
        int[] colors = new int[]{this.getBackgroundCircleColor(), this.speedometerColor, this.getBackgroundCircleColor(), this.getBackgroundCircleColor(), this.speedometerColor, this.speedometerColor};
        RadialGradient radialGradient = new RadialGradient((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, (float)this.getWidthPa() * 0.5f, colors, new float[]{stop, stop2, stop3, stop4, stop5, 1.0f}, Shader.TileMode.CLAMP);
        this.ringPaint.setShader((Shader)radialGradient);
    }

    private void initDraw() {
        this.ringPaint.setStrokeWidth(this.getSpeedometerWidth());
        this.markPaint.setColor(this.getMarkColor());
        this.textPaint.setColor(this.getTextColor());
        this.textPaint.setTextSize(this.getTextSize());
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.initDraw();
        this.drawSpeedUnitText(canvas);
        this.drawIndicator(canvas);
        this.drawNotes(canvas);
    }

    @Override
    protected void updateBackgroundBitmap() {
        Canvas c = this.createBackgroundBitmapCanvas();
        this.initDraw();
        float markH = (float)this.getHeightPa() / 22.0f;
        this.markPath.reset();
        this.markPath.moveTo((float)this.getSize() * 0.5f, (float)this.getPadding());
        this.markPath.lineTo((float)this.getSize() * 0.5f, markH + (float)this.getPadding());
        this.markPaint.setStrokeWidth(markH / 5.0f);
        this.trianglesPath.reset();
        this.trianglesPath.moveTo((float)this.getSize() * 0.5f, (float)this.getPadding() + (float)this.getHeightPa() / 20.0f);
        this.trianglesPath.lineTo((float)this.getSize() * 0.5f - (float)this.getSize() / 40.0f, (float)this.getPadding());
        this.trianglesPath.lineTo((float)this.getSize() * 0.5f + (float)this.getSize() / 40.0f, (float)this.getPadding());
        float risk = this.getSpeedometerWidth() * 0.5f + (float)this.getPadding();
        this.speedometerRect.set(risk, risk, (float)this.getSize() - risk, (float)this.getSize() - risk);
        c.drawArc(this.speedometerRect, 0.0f, 360.0f, false, this.ringPaint);
        c.save();
        c.rotate((float)this.getStartDegree() + 90.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        for (float i = 0.0f; i <= (float)(this.getEndDegree() - this.getStartDegree()); i += 4.0f) {
            c.rotate(4.0f, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
            if (i % 40.0f == 0.0f) {
                c.drawPath(this.trianglesPath, this.trianglesPaint);
                c.drawText(String.format(this.getLocale(), "%d", (int)this.getSpeedAtDegree(i + (float)this.getStartDegree())), (float)this.getSize() * 0.5f, (float)this.getHeightPa() / 20.0f + this.textPaint.getTextSize() + (float)this.getPadding(), (Paint)this.textPaint);
                continue;
            }
            if (i % 20.0f == 0.0f) {
                this.markPaint.setStrokeWidth((float)this.getSize() / 22.0f / 5.0f);
            } else {
                this.markPaint.setStrokeWidth((float)this.getSize() / 22.0f / 9.0f);
            }
            c.drawPath(this.markPath, this.markPaint);
        }
        c.restore();
    }

    @Override
    public void setSpeedometerWidth(float speedometerWidth) {
        super.setSpeedometerWidth(speedometerWidth);
        float risk = speedometerWidth * 0.5f;
        this.speedometerRect.set(risk, risk, (float)this.getSize() - risk, (float)this.getSize() - risk);
        this.updateGradient();
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public int getSpeedometerColor() {
        return this.speedometerColor;
    }

    public void setSpeedometerColor(int speedometerColor) {
        this.speedometerColor = speedometerColor;
        this.updateGradient();
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    public int getTrianglesColor() {
        return this.trianglesPaint.getColor();
    }

    public void setTrianglesColor(int trianglesColor) {
        this.trianglesPaint.setColor(trianglesColor);
        this.updateBackgroundBitmap();
        this.invalidate();
    }

    @Override
    @Deprecated
    public int getLowSpeedColor() {
        return 0;
    }

    @Override
    @Deprecated
    public void setLowSpeedColor(int lowSpeedColor) {
    }

    @Override
    @Deprecated
    public int getMediumSpeedColor() {
        return 0;
    }

    @Override
    @Deprecated
    public void setMediumSpeedColor(int mediumSpeedColor) {
    }

    @Override
    @Deprecated
    public int getHighSpeedColor() {
        return 0;
    }

    @Override
    @Deprecated
    public void setHighSpeedColor(int highSpeedColor) {
    }
}

