/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.utils;

import java.text.DecimalFormat;

public class ConverUtil {
    private static final long ONE_128KB = 131072L;
    private static final long TWO_256KB = 262144L;
    private static final long THREE_512KB = 524288L;
    private static final long FOUR_1MB = 0x100000L;
    private static final long FIVE_2MB = 0x200000L;
    private static final long SIX_5MB = 0x500000L;
    private static final long SEVEN_10MB = 0xA00000L;
    private static final long EIGHT_20MB = 0x1400000L;
    private static final long NINE_50MB = 0x3200000L;
    private static final long TEN_100MB = 0x6400000L;

    public static int getSpeedPercent(long speed) {
        if (speed >= 0L && speed < 131072L) {
            return ConverUtil.conver(speed * 10L / 131072L);
        }
        if (speed >= 131072L && speed < 262144L) {
            return ConverUtil.conver(speed * 10L / 262144L) + 10;
        }
        if (speed >= 262144L && speed < 524288L) {
            return ConverUtil.conver(speed * 10L / 524288L) + 20;
        }
        if (speed >= 524288L && speed < 0x100000L) {
            return ConverUtil.conver(speed * 10L / 0x100000L) + 30;
        }
        if (speed >= 0x100000L && speed < 0x200000L) {
            return ConverUtil.conver(speed * 10L / 0x200000L) + 40;
        }
        if (speed >= 0x200000L && speed < 0x500000L) {
            return ConverUtil.conver(speed * 10L / 0x500000L) + 50;
        }
        if (speed >= 0x500000L && speed < 0xA00000L) {
            return ConverUtil.conver(speed * 10L / 0xA00000L) + 60;
        }
        if (speed >= 0xA00000L && speed < 0x1400000L) {
            return ConverUtil.conver(speed * 10L / 0x1400000L) + 70;
        }
        if (speed >= 0x1400000L && speed < 0x3200000L) {
            return ConverUtil.conver(speed * 10L / 0x3200000L) + 80;
        }
        return ConverUtil.conver(speed * 10L / 0x6400000L) + 90;
    }

    private static int conver(long originData) {
        return Integer.parseInt(new DecimalFormat("0").format(originData));
    }

    public static String[] fomartSpeed(long speed) {
        long UNIT_KB = 1024L;
        long UNIT_MB = 0x100000L;
        long UNIT_GB = 0x40000000L;
        int unit = 0;
        long temp = speed;
        while (temp / 1024L > 0L) {
            temp /= 1024L;
            ++unit;
        }
        String floatPart = null;
        switch (unit) {
            case 0: {
                return new String[]{temp + "", "B/S"};
            }
            case 1: {
                floatPart = speed % 1024L + "";
                if (floatPart.length() >= 2) {
                    floatPart = floatPart.substring(0, 2);
                }
                return new String[]{temp + "." + floatPart, "KB/S"};
            }
            case 2: {
                floatPart = speed % 0x100000L + "";
                if (floatPart.length() >= 2) {
                    floatPart = floatPart.substring(0, 2);
                }
                return new String[]{temp + "." + floatPart, "MB/S"};
            }
            case 3: {
                floatPart = speed % 0x40000000L + "";
                if (floatPart.length() >= 2) {
                    floatPart = floatPart.substring(0, 2);
                }
                return new String[]{temp + "." + floatPart, "GB/S"};
            }
        }
        return new String[]{"0", "B/S"};
    }
}

