/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.zhihu.matisse.R;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.entity.Item;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.internal.model.AlbumMediaCollection;
import com.zhihu.matisse.internal.model.SelectedItemCollection;
import com.zhihu.matisse.internal.ui.adapter.AlbumMediaAdapter;
import com.zhihu.matisse.internal.ui.widget.MediaGridInset;
import com.zhihu.matisse.internal.utils.UIUtils;

public class MediaSelectionFragment
extends Fragment
implements AlbumMediaCollection.AlbumMediaCallbacks,
AlbumMediaAdapter.CheckStateListener,
AlbumMediaAdapter.OnMediaClickListener {
    public static final String EXTRA_ALBUM = "extra_album";
    private final AlbumMediaCollection mAlbumMediaCollection = new AlbumMediaCollection();
    private RecyclerView mRecyclerView;
    private AlbumMediaAdapter mAdapter;
    private SelectionProvider mSelectionProvider;
    private AlbumMediaAdapter.CheckStateListener mCheckStateListener;
    private AlbumMediaAdapter.OnMediaClickListener mOnMediaClickListener;

    public static MediaSelectionFragment newInstance(Album album) {
        MediaSelectionFragment fragment = new MediaSelectionFragment();
        Bundle args = new Bundle();
        args.putParcelable(EXTRA_ALBUM, (Parcelable)album);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof SelectionProvider)) {
            throw new IllegalStateException("Context must implement SelectionProvider.");
        }
        this.mSelectionProvider = (SelectionProvider)context;
        if (context instanceof AlbumMediaAdapter.CheckStateListener) {
            this.mCheckStateListener = (AlbumMediaAdapter.CheckStateListener)context;
        }
        if (context instanceof AlbumMediaAdapter.OnMediaClickListener) {
            this.mOnMediaClickListener = (AlbumMediaAdapter.OnMediaClickListener)context;
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_media_selection, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Album album = (Album)this.getArguments().getParcelable(EXTRA_ALBUM);
        this.mAdapter = new AlbumMediaAdapter(this.getContext(), this.mSelectionProvider.provideSelectedItemCollection(), this.mRecyclerView);
        this.mAdapter.registerCheckStateListener(this);
        this.mAdapter.registerOnMediaClickListener(this);
        this.mRecyclerView.setHasFixedSize(true);
        SelectionSpec selectionSpec = SelectionSpec.getInstance();
        int spanCount = selectionSpec.gridExpectedSize > 0 ? UIUtils.spanCount(this.getContext(), selectionSpec.gridExpectedSize) : selectionSpec.spanCount;
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), spanCount));
        int spacing = this.getResources().getDimensionPixelSize(R.dimen.media_grid_spacing);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new MediaGridInset(spanCount, spacing, false));
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAlbumMediaCollection.onCreate(this.getActivity(), this);
        this.mAlbumMediaCollection.load(album, selectionSpec.capture);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mAlbumMediaCollection.onDestroy();
    }

    public void refreshMediaGrid() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void refreshSelection() {
        this.mAdapter.refreshSelection();
    }

    @Override
    public void onAlbumMediaLoad(Cursor cursor) {
        this.mAdapter.swapCursor(cursor);
    }

    @Override
    public void onAlbumMediaReset() {
        this.mAdapter.swapCursor(null);
    }

    @Override
    public void onUpdate() {
        if (this.mCheckStateListener != null) {
            this.mCheckStateListener.onUpdate();
        }
    }

    @Override
    public void onMediaClick(Album album, Item item, int adapterPosition) {
        if (this.mOnMediaClickListener != null) {
            this.mOnMediaClickListener.onMediaClick((Album)this.getArguments().getParcelable(EXTRA_ALBUM), item, adapterPosition);
        }
    }

    public static interface SelectionProvider {
        public SelectedItemCollection provideSelectedItemCollection();
    }
}

