/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui;

import android.database.Cursor;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.entity.Item;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.internal.model.AlbumMediaCollection;
import com.zhihu.matisse.internal.ui.BasePreviewActivity;
import com.zhihu.matisse.internal.ui.adapter.PreviewPagerAdapter;
import java.util.ArrayList;

public class AlbumPreviewActivity
extends BasePreviewActivity
implements AlbumMediaCollection.AlbumMediaCallbacks {
    public static final String EXTRA_ALBUM = "extra_album";
    public static final String EXTRA_ITEM = "extra_item";
    private AlbumMediaCollection mCollection = new AlbumMediaCollection();
    private boolean mIsAlreadySetPosition;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!SelectionSpec.getInstance().hasInited) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.mCollection.onCreate((FragmentActivity)this, this);
        Album album = (Album)this.getIntent().getParcelableExtra(EXTRA_ALBUM);
        this.mCollection.load(album);
        Item item = (Item)this.getIntent().getParcelableExtra(EXTRA_ITEM);
        if (this.mSpec.countable) {
            this.mCheckView.setCheckedNum(this.mSelectedCollection.checkedNumOf(item));
        } else {
            this.mCheckView.setChecked(this.mSelectedCollection.isSelected(item));
        }
        this.updateSize(item);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mCollection.onDestroy();
    }

    @Override
    public void onAlbumMediaLoad(Cursor cursor) {
        ArrayList<Item> items = new ArrayList<Item>();
        while (cursor.moveToNext()) {
            items.add(Item.valueOf(cursor));
        }
        if (items.isEmpty()) {
            return;
        }
        PreviewPagerAdapter adapter = (PreviewPagerAdapter)this.mPager.getAdapter();
        adapter.addAll(items);
        adapter.notifyDataSetChanged();
        if (!this.mIsAlreadySetPosition) {
            this.mIsAlreadySetPosition = true;
            Item selected = (Item)this.getIntent().getParcelableExtra(EXTRA_ITEM);
            int selectedIndex = items.indexOf(selected);
            this.mPager.setCurrentItem(selectedIndex, false);
            this.mPreviousPos = selectedIndex;
        }
    }

    @Override
    public void onAlbumMediaReset() {
    }
}

