/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.model;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import com.zhihu.matisse.R;
import com.zhihu.matisse.internal.entity.IncapableCause;
import com.zhihu.matisse.internal.entity.Item;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.internal.utils.PathUtils;
import com.zhihu.matisse.internal.utils.PhotoMetadataUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SelectedItemCollection {
    public static final String STATE_SELECTION = "state_selection";
    public static final String STATE_COLLECTION_TYPE = "state_collection_type";
    public static final int COLLECTION_UNDEFINED = 0;
    public static final int COLLECTION_IMAGE = 1;
    public static final int COLLECTION_VIDEO = 2;
    public static final int COLLECTION_MIXED = 3;
    private final Context mContext;
    private Set<Item> mItems;
    private int mCollectionType = 0;

    public SelectedItemCollection(Context context) {
        this.mContext = context;
    }

    public void onCreate(Bundle bundle) {
        if (bundle == null) {
            this.mItems = new LinkedHashSet<Item>();
        } else {
            ArrayList saved = bundle.getParcelableArrayList(STATE_SELECTION);
            this.mItems = new LinkedHashSet<Item>(saved);
            this.mCollectionType = bundle.getInt(STATE_COLLECTION_TYPE, 0);
        }
    }

    public void setDefaultSelection(List<Item> uris) {
        this.mItems.addAll(uris);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putParcelableArrayList(STATE_SELECTION, new ArrayList<Item>(this.mItems));
        outState.putInt(STATE_COLLECTION_TYPE, this.mCollectionType);
    }

    public Bundle getDataWithBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(STATE_SELECTION, new ArrayList<Item>(this.mItems));
        bundle.putInt(STATE_COLLECTION_TYPE, this.mCollectionType);
        return bundle;
    }

    public boolean add(Item item) {
        if (this.typeConflict(item)) {
            throw new IllegalArgumentException("Can't select images and videos at the same time.");
        }
        boolean added = this.mItems.add(item);
        if (added) {
            if (this.mCollectionType == 0) {
                if (item.isImage()) {
                    this.mCollectionType = 1;
                } else if (item.isVideo()) {
                    this.mCollectionType = 2;
                }
            } else if (this.mCollectionType == 1) {
                if (item.isVideo()) {
                    this.mCollectionType = 3;
                }
            } else if (this.mCollectionType == 2 && item.isImage()) {
                this.mCollectionType = 3;
            }
        }
        return added;
    }

    public boolean remove(Item item) {
        boolean removed = this.mItems.remove(item);
        if (removed) {
            if (this.mItems.size() == 0) {
                this.mCollectionType = 0;
            } else if (this.mCollectionType == 3) {
                this.refineCollectionType();
            }
        }
        return removed;
    }

    public void overwrite(ArrayList<Item> items, int collectionType) {
        this.mCollectionType = items.size() == 0 ? 0 : collectionType;
        this.mItems.clear();
        this.mItems.addAll(items);
    }

    public List<Item> asList() {
        return new ArrayList<Item>(this.mItems);
    }

    public List<Uri> asListOfUri() {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        for (Item item : this.mItems) {
            uris.add(item.getContentUri());
        }
        return uris;
    }

    public List<String> asListOfString() {
        ArrayList<String> paths = new ArrayList<String>();
        for (Item item : this.mItems) {
            paths.add(PathUtils.getPath(this.mContext, item.getContentUri()));
        }
        return paths;
    }

    public boolean isEmpty() {
        return this.mItems == null || this.mItems.isEmpty();
    }

    public boolean isSelected(Item item) {
        return this.mItems.contains(item);
    }

    public IncapableCause isAcceptable(Item item) {
        if (this.maxSelectableReached()) {
            String cause;
            int maxSelectable = this.currentMaxSelectable();
            try {
                cause = this.mContext.getResources().getQuantityString(R.plurals.error_over_count, maxSelectable, new Object[]{maxSelectable});
            }
            catch (Resources.NotFoundException e) {
                cause = this.mContext.getString(R.string.error_over_count, new Object[]{maxSelectable});
            }
            return new IncapableCause(cause);
        }
        if (this.typeConflict(item)) {
            return new IncapableCause(this.mContext.getString(R.string.error_type_conflict));
        }
        return PhotoMetadataUtils.isAcceptable(this.mContext, item);
    }

    public boolean maxSelectableReached() {
        return this.mItems.size() == this.currentMaxSelectable();
    }

    private int currentMaxSelectable() {
        SelectionSpec spec = SelectionSpec.getInstance();
        if (spec.maxSelectable > 0) {
            return spec.maxSelectable;
        }
        if (this.mCollectionType == 1) {
            return spec.maxImageSelectable;
        }
        if (this.mCollectionType == 2) {
            return spec.maxVideoSelectable;
        }
        return spec.maxSelectable;
    }

    public int getCollectionType() {
        return this.mCollectionType;
    }

    private void refineCollectionType() {
        boolean hasImage = false;
        boolean hasVideo = false;
        for (Item i : this.mItems) {
            if (i.isImage() && !hasImage) {
                hasImage = true;
            }
            if (!i.isVideo() || hasVideo) continue;
            hasVideo = true;
        }
        if (hasImage && hasVideo) {
            this.mCollectionType = 3;
        } else if (hasImage) {
            this.mCollectionType = 1;
        } else if (hasVideo) {
            this.mCollectionType = 2;
        }
    }

    public boolean typeConflict(Item item) {
        return SelectionSpec.getInstance().mediaTypeExclusive && (item.isImage() && (this.mCollectionType == 2 || this.mCollectionType == 3) || item.isVideo() && (this.mCollectionType == 1 || this.mCollectionType == 3));
    }

    public int count() {
        return this.mItems.size();
    }

    public int checkedNumOf(Item item) {
        int index = new ArrayList<Item>(this.mItems).indexOf(item);
        return index == -1 ? Integer.MIN_VALUE : index + 1;
    }
}

