/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.entity;

import android.content.Context;
import android.support.v4.app.FragmentActivity;
import android.widget.Toast;
import com.zhihu.matisse.internal.ui.widget.IncapableDialog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class IncapableCause {
    public static final int TOAST = 0;
    public static final int DIALOG = 1;
    public static final int NONE = 2;
    private int mForm = 0;
    private String mTitle;
    private String mMessage;

    public IncapableCause(String message) {
        this.mMessage = message;
    }

    public IncapableCause(String title, String message) {
        this.mTitle = title;
        this.mMessage = message;
    }

    public IncapableCause(int form, String message) {
        this.mForm = form;
        this.mMessage = message;
    }

    public IncapableCause(int form, String title, String message) {
        this.mForm = form;
        this.mTitle = title;
        this.mMessage = message;
    }

    public static void handleCause(Context context, IncapableCause cause) {
        if (cause == null) {
            return;
        }
        switch (cause.mForm) {
            case 2: {
                break;
            }
            case 1: {
                IncapableDialog incapableDialog = IncapableDialog.newInstance(cause.mTitle, cause.mMessage);
                incapableDialog.show(((FragmentActivity)context).getSupportFragmentManager(), IncapableDialog.class.getName());
                break;
            }
            default: {
                Toast.makeText((Context)context, (CharSequence)cause.mMessage, (int)0).show();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Form {
    }
}

