/*
 * Decompiled with CFR 0.152.
 */
package io.github.luizgrp.sectionedrecyclerviewadapter;

import androidx.annotation.LayoutRes;

public final class SectionParameters {
    @LayoutRes
    public final transient Integer itemResourceId;
    @LayoutRes
    public final transient Integer headerResourceId;
    @LayoutRes
    public final transient Integer footerResourceId;
    @LayoutRes
    public final transient Integer loadingResourceId;
    @LayoutRes
    public final transient Integer failedResourceId;
    @LayoutRes
    public final transient Integer emptyResourceId;
    public final transient boolean itemViewWillBeProvided;
    public final transient boolean headerViewWillBeProvided;
    public final transient boolean footerViewWillBeProvided;
    public final transient boolean loadingViewWillBeProvided;
    public final transient boolean failedViewWillBeProvided;
    public final transient boolean emptyViewWillBeProvided;

    private SectionParameters(Builder builder) {
        this.itemResourceId = builder.itemResourceId;
        this.headerResourceId = builder.headerResourceId;
        this.footerResourceId = builder.footerResourceId;
        this.loadingResourceId = builder.loadingResourceId;
        this.failedResourceId = builder.failedResourceId;
        this.emptyResourceId = builder.emptyResourceId;
        this.itemViewWillBeProvided = builder.itemViewWillBeProvided;
        this.headerViewWillBeProvided = builder.headerViewWillBeProvided;
        this.footerViewWillBeProvided = builder.footerViewWillBeProvided;
        this.loadingViewWillBeProvided = builder.loadingViewWillBeProvided;
        this.failedViewWillBeProvided = builder.failedViewWillBeProvided;
        this.emptyViewWillBeProvided = builder.emptyViewWillBeProvided;
        if (this.itemResourceId != null && this.itemViewWillBeProvided) {
            throw new IllegalArgumentException("itemResourceId and itemViewWillBeProvided cannot both be set");
        }
        if (this.itemResourceId == null && !this.itemViewWillBeProvided) {
            throw new IllegalArgumentException("Either itemResourceId or itemViewWillBeProvided must be set");
        }
        if (this.headerResourceId != null && this.headerViewWillBeProvided) {
            throw new IllegalArgumentException("headerResourceId and headerViewWillBeProvided cannot both be set");
        }
        if (this.footerResourceId != null && this.footerViewWillBeProvided) {
            throw new IllegalArgumentException("footerResourceId and footerViewWillBeProvided cannot both be set");
        }
        if (this.loadingResourceId != null && this.loadingViewWillBeProvided) {
            throw new IllegalArgumentException("loadingResourceId and loadingViewWillBeProvided cannot both be set");
        }
        if (this.failedResourceId != null && this.failedViewWillBeProvided) {
            throw new IllegalArgumentException("failedResourceId and failedViewWillBeProvided cannot both be set");
        }
        if (this.emptyResourceId != null && this.emptyViewWillBeProvided) {
            throw new IllegalArgumentException("emptyResourceId and emptyViewWillBeProvided cannot both be set");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @LayoutRes
        private transient Integer itemResourceId;
        @LayoutRes
        private transient Integer headerResourceId;
        @LayoutRes
        private transient Integer footerResourceId;
        @LayoutRes
        private transient Integer loadingResourceId;
        @LayoutRes
        private transient Integer failedResourceId;
        @LayoutRes
        private transient Integer emptyResourceId;
        private transient boolean itemViewWillBeProvided;
        private transient boolean headerViewWillBeProvided;
        private transient boolean footerViewWillBeProvided;
        private transient boolean loadingViewWillBeProvided;
        private transient boolean failedViewWillBeProvided;
        private transient boolean emptyViewWillBeProvided;

        private Builder() {
        }

        public Builder itemResourceId(@LayoutRes int itemResourceId) {
            this.itemResourceId = itemResourceId;
            return this;
        }

        public Builder itemViewWillBeProvided() {
            this.itemViewWillBeProvided = true;
            return this;
        }

        public Builder headerResourceId(@LayoutRes int headerResourceId) {
            this.headerResourceId = headerResourceId;
            return this;
        }

        public Builder headerViewWillBeProvided() {
            this.headerViewWillBeProvided = true;
            return this;
        }

        public Builder footerResourceId(@LayoutRes int footerResourceId) {
            this.footerResourceId = footerResourceId;
            return this;
        }

        public Builder footerViewWillBeProvided() {
            this.footerViewWillBeProvided = true;
            return this;
        }

        public Builder loadingResourceId(@LayoutRes int loadingResourceId) {
            this.loadingResourceId = loadingResourceId;
            return this;
        }

        public Builder loadingViewWillBeProvided() {
            this.loadingViewWillBeProvided = true;
            return this;
        }

        public Builder failedResourceId(@LayoutRes int failedResourceId) {
            this.failedResourceId = failedResourceId;
            return this;
        }

        public Builder failedViewWillBeProvided() {
            this.failedViewWillBeProvided = true;
            return this;
        }

        public Builder emptyResourceId(@LayoutRes int emptyResourceId) {
            this.emptyResourceId = emptyResourceId;
            return this;
        }

        public Builder emptyViewWillBeProvided() {
            this.emptyViewWillBeProvided = true;
            return this;
        }

        public SectionParameters build() {
            return new SectionParameters(this);
        }
    }
}

