/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class RecyclingBufferPool
implements BufferPool {
    public static final BufferPool INSTANCE = new RecyclingBufferPool();
    private final Map<Integer, SoftReference<Deque<ByteBuffer>>> pools = new HashMap<Integer, SoftReference<Deque<ByteBuffer>>>();

    private RecyclingBufferPool() {
    }

    private Deque<ByteBuffer> getDeque(int n) {
        ArrayDeque<ByteBuffer> arrayDeque;
        SoftReference<Deque<ByteBuffer>> softReference = this.pools.get(n);
        if (softReference == null || (arrayDeque = softReference.get()) == null) {
            arrayDeque = new ArrayDeque();
            softReference = new SoftReference<ArrayDeque<ByteBuffer>>(arrayDeque);
            this.pools.put(n, softReference);
        }
        return arrayDeque;
    }

    @Override
    public synchronized ByteBuffer get(int n) {
        ByteBuffer byteBuffer = this.getDeque(n).pollFirst();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(n);
        }
        return byteBuffer;
    }

    @Override
    public synchronized void release(ByteBuffer byteBuffer) {
        this.getDeque(byteBuffer.capacity()).addLast(byteBuffer);
    }
}

