/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Zstd {
    public static native long compress(byte[] var0, byte[] var1, int var2);

    public static native long compressByteArray(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5, int var6);

    public static native long compressDirectByteBuffer(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, int var6);

    public static native long compressUnsafe(long var0, long var2, long var4, long var6, int var8);

    public static native long compressUsingDict(byte[] var0, int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    public static native long compressDirectByteBufferUsingDict(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, byte[] var6, int var7);

    public static native long compressFastDict(byte[] var0, int var1, byte[] var2, int var3, int var4, ZstdDictCompress var5);

    public static native long compressDirectByteBufferFastDict(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, ZstdDictCompress var6);

    public static native long decompress(byte[] var0, byte[] var1);

    public static native long decompressByteArray(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5);

    public static native long decompressDirectByteBuffer(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5);

    public static native long decompressUnsafe(long var0, long var2, long var4, long var6);

    public static native long decompressUsingDict(byte[] var0, int var1, byte[] var2, int var3, int var4, byte[] var5);

    public static native long decompressDirectByteBufferUsingDict(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, byte[] var6);

    public static native long decompressFastDict(byte[] var0, int var1, byte[] var2, int var3, int var4, ZstdDictDecompress var5);

    public static native long decompressDirectByteBufferFastDict(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, int var5, ZstdDictDecompress var6);

    public static native long decompressedSize(byte[] var0);

    public static native long decompressedDirectByteBufferSize(ByteBuffer var0, int var1, int var2);

    public static native long compressBound(long var0);

    public static native boolean isError(long var0);

    public static native String getErrorName(long var0);

    public static native long trainFromBuffer(byte[][] var0, byte[] var1, boolean var2);

    public static native long trainFromBufferDirect(ByteBuffer var0, int[] var1, ByteBuffer var2, boolean var3);

    public static native long getDictIdFromFrame(byte[] var0);

    public static native long getDictIdFromDict(byte[] var0);

    public static long trainFromBuffer(byte[][] byArray, byte[] byArray2) {
        return Zstd.trainFromBuffer(byArray, byArray2, false);
    }

    public static long trainFromBufferDirect(ByteBuffer byteBuffer, int[] nArray, ByteBuffer byteBuffer2) {
        return Zstd.trainFromBufferDirect(byteBuffer, nArray, byteBuffer2, false);
    }

    public static native int magicNumber();

    public static native int windowLogMin();

    public static native int windowLogMax();

    public static native int chainLogMin();

    public static native int chainLogMax();

    public static native int hashLogMin();

    public static native int hashLogMax();

    public static native int searchLogMin();

    public static native int searchLogMax();

    public static native int searchLengthMin();

    public static native int searchLengthMax();

    public static native int frameHeaderSizeMin();

    public static native int frameHeaderSizeMax();

    public static native int blockSizeMax();

    public static byte[] compress(byte[] byArray) {
        return Zstd.compress(byArray, 3);
    }

    public static byte[] compress(byte[] byArray, int n) {
        long l = Zstd.compressBound(byArray.length);
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("Max output size is greater than MAX_INT");
        }
        byte[] byArray2 = new byte[(int)l];
        long l2 = Zstd.compress(byArray2, byArray, n);
        if (Zstd.isError(l2)) {
            throw new RuntimeException(Zstd.getErrorName(l2));
        }
        return Arrays.copyOfRange(byArray2, 0, (int)l2);
    }

    public static int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return Zstd.compress(byteBuffer, byteBuffer2, 3);
    }

    public static int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuf must be a direct buffer");
        }
        long l = Zstd.compressDirectByteBuffer(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit() - byteBuffer2.position(), n);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        byteBuffer2.position(byteBuffer2.limit());
        byteBuffer.position(byteBuffer.position() + (int)l);
        return (int)l;
    }

    public static ByteBuffer compress(ByteBuffer byteBuffer, int n) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        long l = Zstd.compressBound(byteBuffer.limit() - byteBuffer.position());
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("Max output size is greater than MAX_INT");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect((int)l);
        long l2 = Zstd.compressDirectByteBuffer(byteBuffer2, 0, (int)l, byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), n);
        if (Zstd.isError(l2)) {
            throw new RuntimeException(Zstd.getErrorName(l2));
        }
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.limit((int)l2);
        return byteBuffer2;
    }

    public static byte[] compress(byte[] byArray, ZstdDictCompress zstdDictCompress) {
        long l = Zstd.compressBound(byArray.length);
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("Max output size is greater than MAX_INT");
        }
        byte[] byArray2 = new byte[(int)l];
        long l2 = Zstd.compressFastDict(byArray2, 0, byArray, 0, byArray.length, zstdDictCompress);
        if (Zstd.isError(l2)) {
            throw new RuntimeException(Zstd.getErrorName(l2));
        }
        return Arrays.copyOfRange(byArray2, 0, (int)l2);
    }

    @Deprecated
    public static long compressUsingDict(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        return Zstd.compressUsingDict(byArray, 0, byArray2, 0, byArray2.length, byArray3, n);
    }

    public static byte[] compressUsingDict(byte[] byArray, byte[] byArray2, int n) {
        long l = Zstd.compressBound(byArray.length);
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("Max output size is greater than MAX_INT");
        }
        byte[] byArray3 = new byte[(int)l];
        long l2 = Zstd.compressUsingDict(byArray3, 0, byArray, 0, byArray.length, byArray2, n);
        if (Zstd.isError(l2)) {
            throw new RuntimeException(Zstd.getErrorName(l2));
        }
        return Arrays.copyOfRange(byArray3, 0, (int)l2);
    }

    public static long compress(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        return Zstd.compressUsingDict(byArray, 0, byArray2, 0, byArray2.length, byArray3, n);
    }

    public static int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, byte[] byArray, int n) {
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuf must be a direct buffer");
        }
        long l = Zstd.compressDirectByteBufferUsingDict(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit() - byteBuffer2.position(), byArray, n);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        byteBuffer2.position(byteBuffer2.limit());
        byteBuffer.limit((int)l);
        return (int)l;
    }

    public static ByteBuffer compress(ByteBuffer byteBuffer, byte[] byArray, int n) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        long l = Zstd.compressBound(byteBuffer.limit() - byteBuffer.position());
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("Max output size is greater than MAX_INT");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect((int)l);
        long l2 = Zstd.compressDirectByteBufferUsingDict(byteBuffer2, 0, (int)l, byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), byArray, n);
        if (Zstd.isError(l2)) {
            throw new RuntimeException(Zstd.getErrorName(l2));
        }
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.limit((int)l2);
        return byteBuffer2;
    }

    public static int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ZstdDictCompress zstdDictCompress) {
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuf must be a direct buffer");
        }
        long l = Zstd.compressDirectByteBufferFastDict(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit() - byteBuffer2.position(), zstdDictCompress);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        byteBuffer2.position(byteBuffer2.limit());
        byteBuffer.limit((int)l);
        return (int)l;
    }

    public static ByteBuffer compress(ByteBuffer byteBuffer, ZstdDictCompress zstdDictCompress) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        long l = Zstd.compressBound(byteBuffer.limit() - byteBuffer.position());
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("Max output size is greater than MAX_INT");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect((int)l);
        long l2 = Zstd.compressDirectByteBufferFastDict(byteBuffer2, 0, (int)l, byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), zstdDictCompress);
        if (Zstd.isError(l2)) {
            throw new RuntimeException(Zstd.getErrorName(l2));
        }
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.limit((int)l2);
        return byteBuffer2;
    }

    public static byte[] decompress(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        long l = Zstd.decompress(byArray2, byArray);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        if (l != (long)n) {
            return Arrays.copyOfRange(byArray2, 0, (int)l);
        }
        return byArray2;
    }

    public static int decompress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuf must be a direct buffer");
        }
        long l = Zstd.decompressDirectByteBuffer(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit() - byteBuffer2.position());
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        byteBuffer2.position(byteBuffer2.limit());
        byteBuffer.position(byteBuffer.position() + (int)l);
        return (int)l;
    }

    public static ByteBuffer decompress(ByteBuffer byteBuffer, int n) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("srcBuf must be a direct buffer");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
        long l = Zstd.decompressDirectByteBuffer(byteBuffer2, 0, n, byteBuffer, byteBuffer.position(), byteBuffer.limit());
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        byteBuffer.position(byteBuffer.limit());
        return byteBuffer2;
    }

    public static byte[] decompress(byte[] byArray, ZstdDictDecompress zstdDictDecompress, int n) {
        byte[] byArray2 = new byte[n];
        long l = Zstd.decompressFastDict(byArray2, 0, byArray, 0, byArray.length, zstdDictDecompress);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        if (l != (long)n) {
            return Arrays.copyOfRange(byArray2, 0, (int)l);
        }
        return byArray2;
    }

    @Deprecated
    public static long decompressUsingDict(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return Zstd.decompressUsingDict(byArray, 0, byArray2, 0, byArray2.length, byArray3);
    }

    public static long decompress(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return Zstd.decompressUsingDict(byArray, 0, byArray2, 0, byArray2.length, byArray3);
    }

    public static byte[] decompress(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[n];
        long l = Zstd.decompressUsingDict(byArray3, 0, byArray, 0, byArray.length, byArray2);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        if (l != (long)n) {
            return Arrays.copyOfRange(byArray3, 0, (int)l);
        }
        return byArray3;
    }

    public static long decompressedSize(ByteBuffer byteBuffer) {
        return Zstd.decompressedDirectByteBufferSize(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
    }

    public static int decompress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, byte[] byArray) {
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        long l = Zstd.decompressDirectByteBufferUsingDict(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit() - byteBuffer2.position(), byArray);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        byteBuffer2.position(byteBuffer2.limit());
        byteBuffer.position(byteBuffer.position() + (int)l);
        return (int)l;
    }

    public static ByteBuffer decompress(ByteBuffer byteBuffer, byte[] byArray, int n) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
        long l = Zstd.decompressDirectByteBufferUsingDict(byteBuffer2, 0, n, byteBuffer, byteBuffer.position(), byteBuffer.limit(), byArray);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        byteBuffer.position(byteBuffer.limit());
        return byteBuffer2;
    }

    public static int decompress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ZstdDictDecompress zstdDictDecompress) {
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        long l = Zstd.decompressDirectByteBufferFastDict(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit() - byteBuffer2.position(), zstdDictDecompress);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        byteBuffer2.position(byteBuffer2.limit());
        byteBuffer.position(byteBuffer.position() + (int)l);
        return (int)l;
    }

    public static ByteBuffer decompress(ByteBuffer byteBuffer, ZstdDictDecompress zstdDictDecompress, int n) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
        long l = Zstd.decompressDirectByteBufferFastDict(byteBuffer2, 0, n, byteBuffer, byteBuffer.position(), byteBuffer.limit(), zstdDictDecompress);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        byteBuffer.position(byteBuffer.limit());
        return byteBuffer2;
    }

    static {
        Native.load();
    }
}

