/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdDirectBufferDecompressingStream
implements Closeable {
    private ByteBuffer source;
    private final long stream;
    private boolean finishedFrame = false;
    private boolean closed = false;
    private boolean streamEnd = false;
    private int consumed;
    private int produced;

    protected ByteBuffer refill(ByteBuffer byteBuffer) {
        return byteBuffer;
    }

    private static native int recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native long decompressStream(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    public ZstdDirectBufferDecompressingStream(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Source buffer should be a direct buffer");
        }
        this.source = byteBuffer;
        this.stream = ZstdDirectBufferDecompressingStream.createDStream();
        this.initDStream(this.stream);
    }

    public boolean hasRemaining() {
        return !this.streamEnd && (this.source.hasRemaining() || !this.finishedFrame);
    }

    public static int recommendedTargetBufferSize() {
        return ZstdDirectBufferDecompressingStream.recommendedDOutSize();
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Target buffer should be a direct buffer");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.streamEnd) {
            return 0;
        }
        long l = this.decompressStream(this.stream, byteBuffer, byteBuffer.position(), byteBuffer.remaining(), this.source, this.source.position(), this.source.remaining());
        if (Zstd.isError(l)) {
            throw new IOException(Zstd.getErrorName(l));
        }
        this.source.position(this.source.position() + this.consumed);
        byteBuffer.position(byteBuffer.position() + this.produced);
        if (!this.source.hasRemaining()) {
            this.source = this.refill(this.source);
            if (!this.source.isDirect()) {
                throw new IllegalArgumentException("Source buffer should be a direct buffer");
            }
        }
        boolean bl = this.finishedFrame = l == 0L;
        if (this.finishedFrame) {
            if (this.source.hasRemaining()) {
                long l2 = this.initDStream(this.stream);
                if (Zstd.isError(l2)) {
                    throw new IOException("Decompression error: " + Zstd.getErrorName(l2));
                }
            } else {
                this.streamEnd = true;
            }
        }
        return this.produced;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                ZstdDirectBufferDecompressingStream.freeDStream(this.stream);
            }
            finally {
                this.closed = true;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            ZstdDirectBufferDecompressingStream.freeDStream(this.stream);
            this.source = null;
        }
    }

    static {
        Native.load();
    }
}

