/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdInputStream
extends FilterInputStream {
    private long stream;
    private long dstPos = 0L;
    private long srcPos = 0L;
    private long srcSize = 0L;
    private byte[] src = new byte[srcBuffSize];
    private long toRead = 0L;
    private static final int srcBuffSize;
    private boolean isContinuous = false;
    private boolean frameFinished = false;

    private static native long recommendedDInSize();

    private static native long recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native int decompressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public ZstdInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        if (this.src == null) {
            throw new IOException("Error allocating the input buffer of size " + srcBuffSize);
        }
        this.stream = ZstdInputStream.createDStream();
        this.toRead = this.initDStream(this.stream);
        if (Zstd.isError(this.toRead)) {
            throw new IOException("Decompression error: " + Zstd.getErrorName(this.toRead));
        }
    }

    public ZstdInputStream setContinuous(boolean bl) {
        this.isContinuous = bl;
        return this;
    }

    public boolean getContinuous() {
        return this.isContinuous;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Requested lenght " + n2 + " from offset " + n + " in buffer of size " + byArray.length);
        }
        int n3 = n + n2;
        this.dstPos = n;
        boolean bl = false;
        while (this.dstPos < (long)n3) {
            long l = this.srcSize - this.srcPos;
            if (l == 0L && (this.toRead != 1L || bl)) {
                this.srcSize = this.in.read(this.src, 0, srcBuffSize);
                this.srcPos = 0L;
                if (this.srcSize < 0L) {
                    this.srcSize = 0L;
                    if (this.frameFinished) {
                        return -1;
                    }
                    if (this.isContinuous) {
                        return (int)(this.dstPos - (long)n);
                    }
                    throw new IOException("Read error or truncated source");
                }
                this.frameFinished = false;
            }
            long l2 = this.dstPos;
            this.toRead = this.decompressStream(this.stream, byArray, n3, this.src, (int)this.srcSize);
            boolean bl2 = bl = l2 == this.dstPos;
            if (Zstd.isError(this.toRead)) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(this.toRead));
            }
            if (this.toRead != 0L) continue;
            this.frameFinished = true;
            this.toRead = this.initDStream(this.stream);
            if (Zstd.isError(this.toRead)) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(this.toRead));
            }
            return (int)(this.dstPos - (long)n);
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n > 0) {
            return byArray[0] & 0xFF;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.toRead == 1L || this.srcSize - this.srcPos > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        int n = (int)ZstdInputStream.recommendedDOutSize();
        byte[] byArray = new byte[n];
        while (l > (long)n) {
            long l3 = this.read(byArray, 0, n);
            l -= l3;
            l2 += l3;
        }
        return l2 += (long)this.read(byArray, 0, (int)l);
    }

    @Override
    public void close() throws IOException {
        ZstdInputStream.freeDStream(this.stream);
        this.in.close();
    }

    static {
        Native.load();
        srcBuffSize = (int)ZstdInputStream.recommendedDInSize();
    }
}

