/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.util.Native;
import java.util.Arrays;

public class Zstd {
    public static native long compress(byte[] var0, byte[] var1, int var2);

    public static native long decompress(byte[] var0, byte[] var1);

    public static native long compressUsingDict(byte[] var0, int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    public static native long decompressUsingDict(byte[] var0, int var1, byte[] var2, int var3, int var4, byte[] var5);

    public static native long compressBound(long var0);

    public static native boolean isError(long var0);

    public static native String getErrorName(long var0);

    public static native long trainFromBuffer(byte[][] var0, byte[] var1);

    public static native int magicNumber();

    public static native int windowLogMin();

    public static native int windowLogMax();

    public static native int chainLogMin();

    public static native int chainLogMax();

    public static native int hashLogMin();

    public static native int hashLogMax();

    public static native int searchLogMin();

    public static native int searchLogMax();

    public static native int searchLengthMin();

    public static native int searchLengthMax();

    public static native int targetLengthMin();

    public static native int targetLengthMax();

    public static native int frameHeaderSizeMin();

    public static native int frameHeaderSizeMax();

    public static native int blockSizeMax();

    public static byte[] compress(byte[] byArray, int n) {
        long l = Zstd.compressBound(byArray.length);
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("Max output size is greater than MAX_INT");
        }
        byte[] byArray2 = new byte[(int)l];
        long l2 = Zstd.compress(byArray2, byArray, n);
        if (Zstd.isError(l2)) {
            throw new RuntimeException(Zstd.getErrorName(l2));
        }
        return Arrays.copyOfRange(byArray2, 0, (int)l2);
    }

    public static byte[] compress(byte[] byArray) {
        return Zstd.compress(byArray, 1);
    }

    public static byte[] decompress(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        long l = Zstd.decompress(byArray2, byArray);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        if (l != (long)n) {
            return Arrays.copyOfRange(byArray2, 0, (int)l);
        }
        return byArray2;
    }

    public static long compressUsingDict(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        return Zstd.compressUsingDict(byArray, 0, byArray2, 0, byArray2.length, byArray3, n);
    }

    public static long decompressUsingDict(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return Zstd.decompressUsingDict(byArray, 0, byArray2, 0, byArray2.length, byArray3);
    }

    static {
        Native.load();
    }
}

